package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.BaseRecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public class RecordLayoutSchemeBeanImpl extends AbstractMaintainableBeanImpl
		implements RecordLayoutSchemeBean {

	private InitializingSchemeItemList<RecordLayoutBean> recordLayoutList;
	private Set<String> otherBaseRecordLayoutUrns = new HashSet<String>();

	public RecordLayoutSchemeBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		recordLayoutList = new ResolvingSchemeItemListImpl<RecordLayoutBean>(
				this.getUrn(), RecordLayoutBean.class, beanInitializer, factory, this);
	}

	public void initSetRecordLayouts(String[] urns) {
		recordLayoutList.initSetIdentifiableUrns(urns);		
		
		otherBaseRecordLayoutUrns.removeAll(Arrays.asList(recordLayoutList.getUrns()));
	}
	
	public void initSetBaseRecordLyaouts(String[] urns){
		Set<String> allBaseRecordLayoutUrns = new HashSet<String>();
		allBaseRecordLayoutUrns.addAll(Arrays.asList(urns));
		
		otherBaseRecordLayoutUrns.clear();
		otherBaseRecordLayoutUrns.addAll(allBaseRecordLayoutUrns);
		otherBaseRecordLayoutUrns.removeAll(Arrays.asList(recordLayoutList.getUrns()));
	}
	
	@Override
	public BaseRecordLayoutBean[] getBaseRecordLayouts() {
		List<BaseRecordLayoutBean> list = new ArrayList<BaseRecordLayoutBean>();
		for(RecordLayoutBean rl : this.recordLayoutList){
			list.add(rl);
		}
				
		try {
			Set<BaseRecordLayoutBean> recordLayouts = 
					this.getResolver().resolve(BaseRecordLayoutBean.class, otherBaseRecordLayoutUrns);		
			list.addAll(recordLayouts);
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
		
		return list.toArray(new BaseRecordLayoutBean[0]);
	}
	
	protected void setRecordLayoutList(
			InitializingSchemeItemList<RecordLayoutBean> recordLayoutList) {
		this.recordLayoutList = recordLayoutList;
	}

	@Override
	public InitializingSchemeItemList<RecordLayoutBean> getRecordLayouts() {
		return recordLayoutList;
	}
	
	@Override
	public void doChangeReference(IdentifiableBean current,
			IdentifiableBean another) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.RecordLayoutScheme;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return RecordLayoutSchemeBean.class;
	}
}
