package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DdiBeanListImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategorySchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LevelBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class CodeSchemeBeanImpl extends AbstractMaintainableBeanImpl implements
		CodeSchemeBean {

	private final ReferenceBeanImpl<CategorySchemeBean> categorySchemeRef;
	private final CodeListImpl codeList;
	private final DdiBeanListImpl<LevelBean> levelList;

	public CodeSchemeBeanImpl(Boolean isNewInstance, URN urn,
			final MutableBeanInitializer beanInitializer,
			final DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);

		categorySchemeRef = new ReferenceBeanImpl<CategorySchemeBean>(
				CategorySchemeBean.class, factory, this);

		codeList = new CodeListImpl(this, beanInitializer, factory, this);
		
		levelList = new DdiBeanListImpl<LevelBean>(LevelBean.class, beanInitializer, factory, this){
			@Override
			protected LevelBean createNew() {
				return new LevelBeanImpl(beanInitializer, factory, CodeSchemeBeanImpl.this);
			}			
		};
	}

	public void internalAddCode(CodeBean code) {
		codeList.internalAddCode(code);
	}

	public ReferenceBeanImpl<CategorySchemeBean> getCategorySchemeReference() {
		return categorySchemeRef;
	}

	@Override
	public String getCategorySchemeUrn() {
		return categorySchemeRef.getUrn();
	}

	@Override
	public boolean isSetCategoryScheme() {
		return categorySchemeRef.isSet();
	}

	@Override
	public void setCategoryScheme(CategorySchemeBean categoryScheme)
		 {
		categorySchemeRef.setReferenceTo(categoryScheme);
	}

	@Override
	public void unsetCategoryScheme() {
		categorySchemeRef.unset();
	}

	@Override
	public CategorySchemeBean getCategoryScheme() {
		try {
			return categorySchemeRef.getReferredObject();
		} catch (ResolverException e) {
			return null;
		}
	}

	@Override
	public CodeListImpl getCodeList() {
		return codeList;
	}
	
	@Override
	public DdiBeanListImpl<LevelBean> getLevelList() {
		return levelList;
	}

	@Override
	public void doChangeReference(IdentifiableBean toDerefer,
			IdentifiableBean toRefer)  {

		if (toDerefer instanceof CategorySchemeBean
				&& toRefer instanceof CategorySchemeBean) {
			if (toDerefer.getUrn().equals(this.categorySchemeRef.getUrn())) {
				CategorySchemeBean anotherScheme = (CategorySchemeBean) toRefer;
				categorySchemeRef.setReferenceTo(anotherScheme);
			}
		}
	}

	@Override
	public void doRemoveReference(IdentifiableBean toRemove) {

		if (toRemove instanceof CategorySchemeBean) {
			if (toRemove.getUrn().equals(this.categorySchemeRef.getUrn())) {
				this.categorySchemeRef.unset();
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.CodeScheme;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return CodeSchemeBean.class;
	}
}
