package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.ArrayList;
import java.util.List;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ConstructSequenceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionBlockBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.SequenceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.StatementItemBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;

public class ControlConstructSchemeBeanImpl extends
		AbstractMaintainableBeanImpl implements ControlConstructSchemeBean {

	private InitializingSchemeItemList<ConstructSequenceBean> constructSequences;
	private InitializingSchemeItemList<QuestionBlockBean> questionBlocks;
	private InitializingSchemeItemList<QuestionConstructBean> questionConstructs;
	private InitializingSchemeItemList<StatementItemBean> statementItems;

	public ControlConstructSchemeBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		constructSequences = new ResolvingSchemeItemListImpl<ConstructSequenceBean>(
				this.getUrn(), ConstructSequenceBean.class, beanInitializer, factory, this);
		questionBlocks = new ResolvingSchemeItemListImpl<QuestionBlockBean>(
				this.getUrn(), QuestionBlockBean.class, beanInitializer, factory, this);

		questionConstructs = new ResolvingSchemeItemListImpl<QuestionConstructBean>(
				this.getUrn(), QuestionConstructBean.class, beanInitializer, factory, this);
		statementItems = new ResolvingSchemeItemListImpl<StatementItemBean>(
				this.getUrn(), StatementItemBean.class, beanInitializer, factory, this);
	}

	public void initSetControlConstructs(String[] controlConstructUrns)
			throws URNFormatException {
		List<String> sequenceUrns = new ArrayList<String>();
		List<String> questionConstructUrns = new ArrayList<String>();
		List<String> stmtItemUrns = new ArrayList<String>();

		for (String ccUrn : controlConstructUrns) {
			URN urnObj = URN.getURN(ccUrn);
			if (urnObj.getDDIClass() == DdiClass.Sequence) {
				sequenceUrns.add(ccUrn);
			} else if (urnObj.getDDIClass() == DdiClass.QuestionConstruct) {
				questionConstructUrns.add(ccUrn);
			} else if (urnObj.getDDIClass() == DdiClass.StatementItem) {
				stmtItemUrns.add(ccUrn);
			}
		}

		questionBlocks.initSetIdentifiableUrns(sequenceUrns
				.toArray(new String[0]));
		questionConstructs.initSetIdentifiableUrns(questionConstructUrns
				.toArray(new String[0]));
		statementItems.initSetIdentifiableUrns(stmtItemUrns
				.toArray(new String[0]));
	}

	protected void setConstructSequences(
			InitializingSchemeItemList<ConstructSequenceBean> constructSequences) {
		this.constructSequences = constructSequences;
	}
	
	@Override
	public InitializingSchemeItemList<ConstructSequenceBean> getConstructSequenceList() {
		return this.constructSequences;
	}
	
	protected void setQuestionBlocks(
			InitializingSchemeItemList<QuestionBlockBean> questionBlocks) {
		this.questionBlocks = questionBlocks;
	}

	@Override
	public InitializingSchemeItemList<QuestionBlockBean> getQuestionBlockList() {
		return this.questionBlocks;
	}

	protected void setQuestionConstructs(
			InitializingSchemeItemList<QuestionConstructBean> questionConstructs) {
		this.questionConstructs = questionConstructs;
	}
	
	@Override
	public InitializingSchemeItemList<QuestionConstructBean> getQuestionConstructList() {
		return this.questionConstructs;
	}

	protected void setStatementItems(
			InitializingSchemeItemList<StatementItemBean> statementItems) {
		this.statementItems = statementItems;
	}
	
	@Override
	public InitializingSchemeItemList<StatementItemBean> getStatementItemList() {
		return this.statementItems;
	}
	
	@Override
	public SequenceBean[] getSequences() {
		List<SequenceBean> sequenceList = new ArrayList<SequenceBean>();
		ConstructSequenceBean[] constructSeqs = this.constructSequences.toArray();
		for (ConstructSequenceBean cseq : constructSeqs) {
			sequenceList.add(cseq);
		}
		QuestionBlockBean[] blocks = this.questionBlocks.toArray();
		for (QuestionBlockBean block : blocks) {
			sequenceList.add(block);
		}
		return sequenceList.toArray(new SequenceBean[0]);
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// TODO Auto-generated method stub
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO Auto-generated method stub
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.ControlConstructScheme;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return ControlConstructSchemeBean.class;
	}

}
