package org.openmetadata.beans.ddi.lifecycle.datacollection;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.SchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.CoverageBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface DataCollectionBean extends MaintainableBean {

	public final static DdiClass ddiClass = DdiClass.DataCollection;

	CoverageBean getCoverage();

	boolean isSetMethodology();

	MethodologyBean addNewMethodology();

	MethodologyBean getMethodology();

	String getMethodologyUrn();

	// void setMethodology(MethodologyBean bean);

	void unsetMethodology();

	SchemeItemList<OtherMaterialBean> getOtherMaterialList();

	DdiBeanList<NoteBean> getNoteList();

	SchemeItemList<CollectionEventBean> getCollectionEventList();

	ReferenceSet<QuestionSchemeBean> getQuestionSchemeList();

	ReferenceSet<ControlConstructSchemeBean> getControlConstructSchemeList();

	ReferenceSet<InterviewerInstructionSchemeBean> getInterviewInstructionSchemeList();

	ReferenceSet<InstrumentBean> getInstrumentList();

	SchemeItemList<ProcessingBean> getProcessingEventList();

	// ...

	StructuredStringValueBean getErrorDetection();

	StructuredStringValueBean getImputation();

	StructuredStringValueBean getEstimation();

	StructuredStringValueBean getQualityEvaluation();
	
	StructuredStringValueBean getDataAccuracy();
	
	StructuredStringValueBean getDisclosureControl();
}
