/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.beans.ddi.lifecycle.adt.DirectedEdge;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DirectedEdgeImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalRecordBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.RecordRelationshipBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.RelationCode;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.ValueTypeCode;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class RecordRelationshipBeanImpl
extends AbstractIdentifiableBeanImpl
implements RecordRelationshipBean {
    private ValueTypeCode type;
    private RelationCode relationCode;
    private ReferenceBeanImpl<LogicalRecordBean> sourceLogicalRecordRef;
    private ReferenceBeanImpl<LogicalRecordBean> targetLogicalRecordRef;
    private List<DirectedEdge<VariableBean>> edges;
    private MutableBeanInitializer beanInitializer;

    public RecordRelationshipBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.beanInitializer = beanInitializer;
        this.sourceLogicalRecordRef = new ReferenceBeanImpl<LogicalRecordBean>(LogicalRecordBean.class, this.getBeanFactory(), (ChangeListener)this);
        this.targetLogicalRecordRef = new ReferenceBeanImpl<LogicalRecordBean>(LogicalRecordBean.class, this.getBeanFactory(), (ChangeListener)this);
        this.edges = new ArrayList<DirectedEdge<VariableBean>>();
    }

    public void initSetSourceLogicalRecordUrn(String urn) {
        this.sourceLogicalRecordRef.setReferenceUrn(urn);
    }

    public void initSetTargetLogicalRecordUrn(String urn) {
        this.targetLogicalRecordRef.setReferenceUrn(urn);
    }

    public void initAddVariableAssociation(String sourceVariableUrn, String targetVariableUrn) {
        DirectedEdgeImpl<VariableBean> edge = new DirectedEdgeImpl<VariableBean>(this.getUrn(), VariableBean.class, this.beanInitializer, this.getBeanFactory(), (ChangeListener)this);
        edge.initSetSource(sourceVariableUrn);
        edge.initSetTarget(targetVariableUrn);
        this.edges.add(edge);
    }

    @Override
    public boolean isSetType() {
        return this.type != null;
    }

    @Override
    public void setType(ValueTypeCode type) {
        this.type = type;
        this.change();
    }

    @Override
    public ValueTypeCode getType() {
        return this.type != null ? this.type : ValueTypeCode.EQUAL;
    }

    @Override
    public void setRelation(RelationCode value) {
        this.relationCode = value;
        this.change();
    }

    @Override
    public RelationCode getRelation() {
        return this.relationCode;
    }

    @Override
    public LogicalRecordBean getSourceLogicalRecord() {
        try {
            return this.sourceLogicalRecordRef.getReferredObject();
        }
        catch (ResolverException e) {
            return null;
        }
    }

    @Override
    public String getSourceLogicalRecordUrn() {
        return this.sourceLogicalRecordRef.getUrn();
    }

    @Override
    public void setSourceLogicalRecordBean(LogicalRecordBean logicalRecord) {
        this.sourceLogicalRecordRef.setReferenceTo(logicalRecord);
        this.change();
    }

    @Override
    public LogicalRecordBean getTargetLogicalRecord() {
        try {
            return this.targetLogicalRecordRef.getReferredObject();
        }
        catch (ResolverException e) {
            return null;
        }
    }

    @Override
    public String getTargetLogicalRecordUrn() {
        return this.targetLogicalRecordRef.getUrn();
    }

    @Override
    public void setTargetLogicalRecordBean(LogicalRecordBean logicalRecord) {
        this.targetLogicalRecordRef.setReferenceTo(logicalRecord);
        this.change();
    }

    @Override
    public List<DirectedEdge<VariableBean>> getVariableRelations() {
        ArrayList<DirectedEdge<VariableBean>> unbackedList = new ArrayList<DirectedEdge<VariableBean>>();
        unbackedList.addAll(this.edges);
        return unbackedList;
    }

    @Override
    public void addVariableRelation(VariableBean source, VariableBean target) {
        if (!this.containsedge(source, target)) {
            DirectedEdgeImpl<VariableBean> edge = new DirectedEdgeImpl<VariableBean>(this.getUrn(), VariableBean.class, this.beanInitializer, this.getBeanFactory(), (ChangeListener)this);
            edge.initSetSource(source.getUrn());
            edge.initSetTarget(target.getUrn());
            this.edges.add(edge);
            System.out.println("added " + this.edges.size());
            this.change();
        }
    }

    private DirectedEdge<VariableBean> getExistingedgeWith(VariableBean source, VariableBean target) {
        for (DirectedEdge<VariableBean> edge : this.edges) {
            if (!edge.getSourceUrn().equals(source.getUrn()) || !edge.getTargetUrn().equals(target.getUrn())) continue;
            return edge;
        }
        return null;
    }

    @Override
    public void removeVariableRelation(VariableBean source, VariableBean target) {
        DirectedEdge<VariableBean> edge = this.getExistingedgeWith(source, target);
        if (edge != null) {
            this.edges.remove(edge);
            this.change();
        }
    }

    @Override
    public void removeAllVariableRelations() {
        this.edges.clear();
        this.change();
    }

    private boolean containsedge(VariableBean source, VariableBean target) {
        DirectedEdge<VariableBean> edge = this.getExistingedgeWith(source, target);
        return edge != null;
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.RecordRelationship;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return RecordRelationshipBean.class;
    }

    @Override
    protected void doChangeReference(IdentifiableBean toRemove, IdentifiableBean toAdd) {
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
    }
}

