/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.datacollection.impl;

import java.util.ArrayList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ConstructSequenceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionBlockBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.SequenceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.StatementItemBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class ControlConstructSchemeBeanImpl
extends AbstractMaintainableBeanImpl
implements ControlConstructSchemeBean {
    private InitializingSchemeItemList<ConstructSequenceBean> constructSequences;
    private InitializingSchemeItemList<QuestionBlockBean> questionBlocks;
    private InitializingSchemeItemList<QuestionConstructBean> questionConstructs;
    private InitializingSchemeItemList<StatementItemBean> statementItems;

    public ControlConstructSchemeBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super(isNewInstance, urn, beanInitializer, factory);
        this.constructSequences = new ResolvingSchemeItemListImpl<ConstructSequenceBean>(this.getUrn(), ConstructSequenceBean.class, beanInitializer, factory, (ChangeListener)this);
        this.questionBlocks = new ResolvingSchemeItemListImpl<QuestionBlockBean>(this.getUrn(), QuestionBlockBean.class, beanInitializer, factory, (ChangeListener)this);
        this.questionConstructs = new ResolvingSchemeItemListImpl<QuestionConstructBean>(this.getUrn(), QuestionConstructBean.class, beanInitializer, factory, (ChangeListener)this);
        this.statementItems = new ResolvingSchemeItemListImpl<StatementItemBean>(this.getUrn(), StatementItemBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetControlConstructs(String[] controlConstructUrns) throws URNFormatException {
        ArrayList<String> sequenceUrns = new ArrayList<String>();
        ArrayList<String> questionConstructUrns = new ArrayList<String>();
        ArrayList<String> stmtItemUrns = new ArrayList<String>();
        String[] stringArray = controlConstructUrns;
        int n = controlConstructUrns.length;
        int n2 = 0;
        while (n2 < n) {
            String ccUrn = stringArray[n2];
            URN urnObj = URN.getURN((String)ccUrn);
            if (urnObj.getDDIClass() == DdiClass.Sequence) {
                sequenceUrns.add(ccUrn);
            } else if (urnObj.getDDIClass() == DdiClass.QuestionConstruct) {
                questionConstructUrns.add(ccUrn);
            } else if (urnObj.getDDIClass() == DdiClass.StatementItem) {
                stmtItemUrns.add(ccUrn);
            }
            ++n2;
        }
        this.questionBlocks.initSetIdentifiableUrns(sequenceUrns.toArray(new String[0]));
        this.questionConstructs.initSetIdentifiableUrns(questionConstructUrns.toArray(new String[0]));
        this.statementItems.initSetIdentifiableUrns(stmtItemUrns.toArray(new String[0]));
    }

    protected void setConstructSequences(InitializingSchemeItemList<ConstructSequenceBean> constructSequences) {
        this.constructSequences = constructSequences;
    }

    public InitializingSchemeItemList<ConstructSequenceBean> getConstructSequenceList() {
        return this.constructSequences;
    }

    protected void setQuestionBlocks(InitializingSchemeItemList<QuestionBlockBean> questionBlocks) {
        this.questionBlocks = questionBlocks;
    }

    public InitializingSchemeItemList<QuestionBlockBean> getQuestionBlockList() {
        return this.questionBlocks;
    }

    protected void setQuestionConstructs(InitializingSchemeItemList<QuestionConstructBean> questionConstructs) {
        this.questionConstructs = questionConstructs;
    }

    public InitializingSchemeItemList<QuestionConstructBean> getQuestionConstructList() {
        return this.questionConstructs;
    }

    protected void setStatementItems(InitializingSchemeItemList<StatementItemBean> statementItems) {
        this.statementItems = statementItems;
    }

    public InitializingSchemeItemList<StatementItemBean> getStatementItemList() {
        return this.statementItems;
    }

    @Override
    public SequenceBean[] getSequences() {
        QuestionBlockBean[] blocks;
        ConstructSequenceBean[] constructSeqs;
        ArrayList<SequenceBean> sequenceList = new ArrayList<SequenceBean>();
        ConstructSequenceBean[] constructSequenceBeanArray = constructSeqs = (ConstructSequenceBean[])this.constructSequences.toArray();
        int n = constructSeqs.length;
        int n2 = 0;
        while (n2 < n) {
            ConstructSequenceBean cseq = constructSequenceBeanArray[n2];
            sequenceList.add(cseq);
            ++n2;
        }
        QuestionBlockBean[] questionBlockBeanArray = blocks = (QuestionBlockBean[])this.questionBlocks.toArray();
        int n3 = blocks.length;
        n = 0;
        while (n < n3) {
            QuestionBlockBean block = questionBlockBeanArray[n];
            sequenceList.add(block);
            ++n;
        }
        return sequenceList.toArray(new SequenceBean[0]);
    }

    @Override
    protected void doChangeReference(IdentifiableBean toRemove, IdentifiableBean toAdd) {
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.ControlConstructScheme;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return ControlConstructSchemeBean.class;
    }
}

