/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class ConceptBeanImpl
extends AbstractSchemeItemBean<ConceptSchemeBean>
implements ConceptBean {
    private ReferenceSetImpl<ConceptBean> similarConcepts;

    public ConceptBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super((boolean)isNewInstance, urn, beanInitializer, factory);
        this.similarConcepts = new ReferenceSetImpl<ConceptBean>(ConceptBean.class, beanInitializer, factory, (ChangeListener)this);
    }

    public void initSetSimilarConcepts(String[] similarConceptUrns) {
        this.similarConcepts.initReferenceUrns(similarConceptUrns);
    }

    public ReferenceSetImpl<ConceptBean> getSimilarConceptList() {
        return this.similarConcepts;
    }

    @Override
    public void doChangeReference(IdentifiableBean toDerefer, IdentifiableBean toRefer) {
        if (toDerefer instanceof ConceptBean && toRefer instanceof ConceptBean) {
            ConceptBean conceptToDerefer = (ConceptBean)toDerefer;
            ConceptBean conceptToRefer = (ConceptBean)toRefer;
            if (this.similarConcepts.contains(conceptToDerefer)) {
                this.similarConcepts.remove(conceptToDerefer);
                this.similarConcepts.add(conceptToRefer);
            }
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        ConceptBean concept;
        if (toRemove instanceof ConceptBean && this.similarConcepts.contains(concept = (ConceptBean)toRemove)) {
            this.similarConcepts.remove(concept);
        }
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.Concept;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return ConceptBean.class;
    }
}

