/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.DynamicIdentifiableIterator;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.notification.ReferenceAddedEvent;
import org.openmetadata.beans.ddi.lifecycle.notification.ReferenceRemovedEvent;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.DdiBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class ReferenceSetImpl<B extends IdentifiableBean>
extends DdiBeanImpl
implements ReferenceSet<B> {
    private Set<String> urnSet = new HashSet<String>();
    private Class<B> beanClass;

    public ReferenceSetImpl(Class<B> beanClass, MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener listener) {
        super(beanInitializer, factory, listener);
        this.beanClass = beanClass;
    }

    public void initReferenceUrns(String[] urns) {
        String[] stringArray = urns;
        int n = urns.length;
        int n2 = 0;
        while (n2 < n) {
            String urn = stringArray[n2];
            this.urnSet.add(urn);
            ++n2;
        }
    }

    @Override
    public String[] getUrns() {
        return this.urnSet.toArray(new String[0]);
    }

    @Override
    public boolean contains(B bean) {
        return bean != null ? this.urnSet.contains(bean.getUrn()) : false;
    }

    @Override
    public boolean contains(String urn) {
        return this.urnSet.contains(urn);
    }

    @Override
    public boolean add(B bean) {
        HashSet<String> addedSet = new HashSet<String>();
        addedSet.add(bean.getUrn());
        boolean result = this.urnSet.add(bean.getUrn());
        this.notifyChange(new ReferenceAddedEvent(bean.getUrn()));
        return result;
    }

    @Override
    public boolean remove(B bean) {
        HashSet<String> toDeleteSet = new HashSet<String>();
        toDeleteSet.add(bean.getUrn());
        boolean result = this.urnSet.remove(bean.getUrn());
        this.notifyChange(new ReferenceRemovedEvent(bean.getUrn()));
        return result;
    }

    @Override
    public boolean remove(String urn) {
        HashSet<String> toDeleteSet = new HashSet<String>();
        toDeleteSet.add(urn);
        boolean result = this.urnSet.remove(urn);
        this.notifyChange(new ReferenceRemovedEvent(urn));
        return result;
    }

    @Override
    public B[] toArray(B[] arr) {
        ArrayList<IdentifiableBean> list = new ArrayList<IdentifiableBean>();
        for (String urn : this.urnSet) {
            try {
                IdentifiableBean bean = (IdentifiableBean)this.getResolver().resolve(this.beanClass, urn);
                list.add(bean);
            }
            catch (ResolverException e) {
                e.printStackTrace();
            }
        }
        return (IdentifiableBean[])list.toArray(arr);
    }

    @Override
    public Iterator<B> iterator() {
        return new DynamicIdentifiableIterator<B>(this.urnSet, this.beanClass, this.getResolver());
    }

    @Override
    public int size() {
        return this.urnSet.size();
    }

    @Override
    public void clear() {
        HashSet<String> deletedSet = new HashSet<String>();
        deletedSet.addAll(this.urnSet);
        this.urnSet.clear();
        this.notifyChange(new ReferenceRemovedEvent(deletedSet));
    }
}

