/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openmetadata.beans.ddi.lifecycle.adt.KeyedBean;
import org.openmetadata.beans.ddi.lifecycle.adt.KeyedValueBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class KeyedValueBeanImpl<B extends KeyedBean>
extends UnsettableDdiBeanImpl
implements KeyedValueBean<B> {
    private final Class<B> beanClass;
    private Map<Map<Enum<?>, Object>, B> map = new LinkedHashMap();

    protected abstract B createNewBean(Map<Enum<?>, Object> var1);

    protected KeyedValueBeanImpl(Class<B> beanClass, DdiBeanFactory beanFactory, ChangeListener changeListener) {
        super(beanFactory, changeListener);
        this.beanClass = beanClass;
    }

    @Override
    public B getBean(Map<Enum<?>, Object> keys) {
        if (this.map.containsKey(keys)) {
            return (B)((KeyedBean)this.map.get(keys));
        }
        B newBean = this.createNewBean(keys);
        this.map.put(keys, newBean);
        return newBean;
    }

    @Override
    public B[] findBeans(Map<Enum<?>, Object> query) {
        ArrayList<KeyedBean> tmpList = new ArrayList<KeyedBean>();
        for (Map<Enum<?>, Object> myKeys : this.map.keySet()) {
            if (!myKeys.entrySet().containsAll(query.entrySet())) continue;
            KeyedBean bean = (KeyedBean)this.map.get(myKeys);
            tmpList.add(bean);
        }
        return tmpList.toArray((KeyedBean[])Array.newInstance(this.beanClass, 0));
    }

    @Override
    public void remove(Map<Enum<?>, Object> keys) {
        this.map.remove(keys);
        this.ddiBeanChanged();
    }

    @Override
    public void removeAll(Map<Enum<?>, Object> query) {
        HashSet keysMapToRemove = new HashSet();
        for (Map<Enum<?>, Object> map : this.map.keySet()) {
            if (!map.entrySet().containsAll(query.entrySet())) continue;
            keysMapToRemove.add(map);
        }
        for (Map<Enum, Object> map : keysMapToRemove) {
            this.map.remove(map);
        }
        this.ddiBeanChanged();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public B[] getAllValues() {
        return this.map.values().toArray((KeyedBean[])Array.newInstance(this.beanClass, 0));
    }

    @Override
    protected final boolean internalIsSet() {
        return !this.map.isEmpty();
    }
}

