/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.c2metadata.xml;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.c2metadata.ddi_2_5.extensions.xml.xmlbeans.FileCommandType;
import org.c2metadata.ddi_2_5.extensions.xml.xmlbeans.FileDerivationCasesType;
import org.c2metadata.ddi_2_5.extensions.xml.xmlbeans.FileDerivationType;
import org.c2metadata.ddi_2_5.extensions.xml.xmlbeans.FileDerivationVarsType;
import org.c2metadata.ddi_2_5.extensions.xml.xmlbeans.FileDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.BaseElementType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CatgryType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CitationType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DataDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DerivationType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DrvcmdType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.FileTxtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.MaterialReferenceType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.OthrStdyMatType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.ProdStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.SimpleTextAndDateType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.SoftwareType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.StdyDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.TitlStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.VarType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.VerStmtType;
import org.openmetadata.util.xmlbeans.XhtmlUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.c2metadata.xml.XmlUpdater;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.FileTransform;
import us.mtna.pojo.Metadata;
import us.mtna.pojo.Transform;
import us.mtna.pojo.TransformCommand;
import us.mtna.pojo.Variable;
import us.mtna.updater.Author;
import us.mtna.updater.DatasetMetadata;
import us.mtna.updater.DdiAuthor;

public class Ddi25XmlUpdater
implements XmlUpdater {
    private HashSet<String> fileIds;
    private HashMap<String, VarType> originalVarMap;
    private Logger log = LoggerFactory.getLogger(Ddi25XmlUpdater.class);
    private DatasetMetadata datasetMetadata;
    private static final String SOFTWARE_VERSION = "1.2.2";
    private static final String SOFTWARE_NAME = "C2Metadata XML Updater";
    private static final String DOCUMENT_ID = "SAMPLE_XU_OUTPUT";

    public Ddi25XmlUpdater() {
        this.fileIds = new HashSet();
        this.originalVarMap = new HashMap();
    }

    @Override
    public XmlObject updateXml(XmlObject original, DataSet ... newDataSets) {
        if (this.datasetMetadata == null) {
            this.datasetMetadata = new DatasetMetadata();
        }
        CodeBookDocument originalDocument = (CodeBookDocument)original.changeType(CodeBookDocument.type);
        CodeBookDocument updatedDocument = this.initializeDocument();
        this.copyOriginalXml(originalDocument.getCodeBook(), updatedDocument.getCodeBook());
        int varCount = this.originalVarMap.size();
        int fileCount = this.fileIds.size();
        DataSet[] dataSetArray = newDataSets;
        int n = newDataSets.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<String> transformedIds;
            TransformCommand command;
            int n3;
            int n4;
            TransformCommand[] transformCommandArray;
            DrvcmdType drvcmd;
            Object transform;
            String codeLabel;
            CatgryType catgry;
            Classification classification;
            String classificationId;
            String label;
            DerivationType derivation;
            String newId;
            boolean copied;
            LinkedHashSet<String> sources;
            VarType var;
            String fileId;
            DataSet dataSet = dataSetArray[n2];
            this.log.debug("Updating XML for dataset [" + dataSet.getId() + "]");
            while (this.fileIds.contains(fileId = "F" + ++fileCount)) {
            }
            FileDscrType derivedFileDscr = FileDscrType.Factory.newInstance();
            derivedFileDscr.setID(fileId);
            DataDscrType dataDscr = updatedDocument.getCodeBook().addNewDataDscr();
            Metadata metadata = dataSet.getMetadata();
            int fileVarCount = 0;
            HashMap<String, String> oldToNewIds = new HashMap<String, String>();
            for (Variable variable : metadata.getFinalVariables()) {
                var = this.originalVarMap.get(variable.getId());
                sources = new LinkedHashSet<String>();
                copied = false;
                if (var == null) {
                    var = dataDscr.addNewVar();
                    this.log.trace("no variable found in the original variable map for [" + variable.getId() + "] so creating a new one");
                } else {
                    copied = true;
                    sources.add(var.getID());
                    this.log.trace("Found variable [" + variable.getId() + "] in the original variable map, adding it to derivation sources");
                }
                while (this.originalVarMap.containsKey(newId = "V" + ++varCount)) {
                }
                oldToNewIds.put(variable.getId(), newId);
                var.setID(newId);
                derivation = var.addNewDerivation();
                if (variable.getTransforms().length > 0) {
                    var.setName(variable.getName());
                    var.getLablList().clear();
                    label = variable.getLabel();
                    if (label != null && !label.isEmpty()) {
                        XhtmlUtilities.setXhtmlContent((XmlObject)var.addNewLabl(), (String)label);
                    }
                    if ((classificationId = variable.getClassificationId()) != null && !classificationId.isEmpty()) {
                        var.getCatgryList().clear();
                        classification = (Classification)metadata.getClassifs().get(classificationId);
                        if (classification != null) {
                            for (Code code : classification.getCodeList()) {
                                catgry = var.addNewCatgry();
                                XhtmlUtilities.setXhtmlContent((XmlObject)catgry.addNewCatValu(), (String)code.getCodeValue());
                                codeLabel = code.getLabel();
                                if (codeLabel != null && !codeLabel.isEmpty()) {
                                    XhtmlUtilities.setXhtmlContent((XmlObject)catgry.addNewLabl(), (String)codeLabel);
                                }
                                if (!code.isMissing()) continue;
                                catgry.setMissing(CatgryType.Missing.Enum.forInt((int)1));
                            }
                        }
                    } else {
                        this.log.debug("No classification found on variable [" + variable.getId() + "]");
                    }
                    catgry = variable.getTransforms();
                    int n5 = ((Transform[])catgry).length;
                    int code = 0;
                    while (code < n5) {
                        transform = catgry[code];
                        sources.addAll(transform.getSourceIds());
                        if (transform.getDescription() != null) {
                            XhtmlUtilities.setXhtmlContent((XmlObject)derivation.addNewDrvdesc(), (String)transform.getDescription());
                        }
                        drvcmd = derivation.addNewDrvcmd();
                        drvcmd.setSource(BaseElementType.Source.PRODUCER);
                        drvcmd.setSyntax(transform.getOriginalCommand().getSyntax());
                        XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd, (String)transform.getOriginalCommand().getCommand());
                        transformCommandArray = transform.getAlternativeCommands();
                        n4 = transformCommandArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            command = transformCommandArray[n3];
                            if ("sdtl-pseudocode".equals(command.getSyntax())) {
                                XhtmlUtilities.setXhtmlContent((XmlObject)derivation.addNewDrvdesc(), (String)command.getCommand());
                            } else {
                                drvcmd = derivation.addNewDrvcmd();
                                drvcmd.setSource(BaseElementType.Source.ARCHIVE);
                                drvcmd.setSyntax(command.getSyntax());
                                XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd, (String)command.getCommand());
                            }
                            ++n3;
                        }
                        ++code;
                    }
                }
                transformedIds = new ArrayList<String>();
                for (String s : sources) {
                    if (oldToNewIds.containsKey(s)) {
                        transformedIds.add((String)oldToNewIds.get(s));
                        continue;
                    }
                    transformedIds.add(s);
                }
                derivation.setVar(transformedIds);
                if (!variable.isDeleted()) {
                    ++fileVarCount;
                    var.setFiles(Arrays.asList(fileId));
                }
                if (copied) {
                    dataDscr.getVarList().add(var);
                }
                this.originalVarMap.put(var.getID(), var);
            }
            for (Variable variable : metadata.getVariables()) {
                var = this.originalVarMap.get(variable.getId());
                sources = new LinkedHashSet();
                copied = false;
                if (var == null) {
                    var = dataDscr.addNewVar();
                    this.log.trace("no variable found in the original variable map for [" + variable.getId() + "] so creating a new one");
                } else {
                    copied = true;
                    sources.add(var.getID());
                    this.log.trace("Found variable [" + variable.getId() + "] in the original variable map, adding it to derivation sources");
                }
                while (this.originalVarMap.containsKey(newId = "V" + ++varCount)) {
                }
                oldToNewIds.put(variable.getId(), newId);
                var.setID(newId);
                derivation = var.addNewDerivation();
                if (variable.getTransforms().length > 0) {
                    var.setName(variable.getName());
                    var.getLablList().clear();
                    label = variable.getLabel();
                    if (label != null && !label.isEmpty()) {
                        XhtmlUtilities.setXhtmlContent((XmlObject)var.addNewLabl(), (String)label);
                    }
                    if ((classificationId = variable.getClassificationId()) != null && !classificationId.isEmpty()) {
                        var.getCatgryList().clear();
                        classification = (Classification)metadata.getClassifs().get(classificationId);
                        if (classification != null) {
                            for (Code code : classification.getCodeList()) {
                                catgry = var.addNewCatgry();
                                XhtmlUtilities.setXhtmlContent((XmlObject)catgry.addNewCatValu(), (String)code.getCodeValue());
                                codeLabel = code.getLabel();
                                if (codeLabel != null && !codeLabel.isEmpty()) {
                                    XhtmlUtilities.setXhtmlContent((XmlObject)catgry.addNewLabl(), (String)codeLabel);
                                }
                                if (!code.isMissing()) continue;
                                catgry.setMissing(CatgryType.Missing.Enum.forInt((int)1));
                            }
                        }
                    } else {
                        this.log.debug("No classification found on variable [" + variable.getId() + "]");
                    }
                    Transform[] transformArray = variable.getTransforms();
                    int n6 = transformArray.length;
                    int code = 0;
                    while (code < n6) {
                        transform = transformArray[code];
                        sources.addAll(transform.getSourceIds());
                        if (transform.getDescription() != null) {
                            XhtmlUtilities.setXhtmlContent((XmlObject)derivation.addNewDrvdesc(), (String)transform.getDescription());
                        }
                        drvcmd = derivation.addNewDrvcmd();
                        drvcmd.setSource(BaseElementType.Source.PRODUCER);
                        drvcmd.setSyntax(transform.getOriginalCommand().getSyntax());
                        XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd, (String)transform.getOriginalCommand().getCommand());
                        transformCommandArray = transform.getAlternativeCommands();
                        n4 = transformCommandArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            command = transformCommandArray[n3];
                            if ("sdtl-pseudocode".equals(command.getSyntax())) {
                                XhtmlUtilities.setXhtmlContent((XmlObject)derivation.addNewDrvdesc(), (String)command.getCommand());
                            } else {
                                drvcmd = derivation.addNewDrvcmd();
                                drvcmd.setSource(BaseElementType.Source.ARCHIVE);
                                drvcmd.setSyntax(command.getSyntax());
                                XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd, (String)command.getCommand());
                            }
                            ++n3;
                        }
                        ++code;
                    }
                }
                transformedIds = new ArrayList();
                for (String s : sources) {
                    if (oldToNewIds.containsKey(s)) {
                        transformedIds.add((String)oldToNewIds.get(s));
                        continue;
                    }
                    transformedIds.add(s);
                }
                derivation.setVar(transformedIds);
                if (!variable.isDeleted()) {
                    ++fileVarCount;
                    var.setFiles(Arrays.asList(fileId));
                }
                if (!copied) continue;
                dataDscr.getVarList().add(var);
            }
            this.addCitations(Arrays.asList(originalDocument), updatedDocument);
            for (FileTransform fileTransform : dataSet.getCommands()) {
                FileDerivationType deriv = derivedFileDscr.addNewFileDerivation();
                FileCommandType command2 = deriv.addNewFileCommand();
                Transform transform2 = fileTransform.getTransform();
                if (transform2.getDescription() != null) {
                    XhtmlUtilities.setXhtmlContent((XmlObject)command2.addNewDrvdesc(), (String)transform2.getDescription());
                }
                ArrayList<String> sources2 = new ArrayList<String>();
                sources2.add(fileTransform.getSourceDataset());
                deriv.setSourceFiles(sources2);
                DrvcmdType drvcmd2 = command2.addNewDrvcmd();
                drvcmd2.setSource(BaseElementType.Source.PRODUCER);
                drvcmd2.setSyntax(transform2.getOriginalCommand().getSyntax());
                XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd2, (String)transform2.getOriginalCommand().getCommand());
                TransformCommand[] code = transform2.getAlternativeCommands();
                int transform3 = code.length;
                int s = 0;
                while (s < transform3) {
                    TransformCommand tc = code[s];
                    if ("sdtl-pseudocode".equals(tc.getSyntax())) {
                        XhtmlUtilities.setXhtmlContent((XmlObject)command2.addNewDrvdesc(), (String)tc.getCommand());
                    } else {
                        drvcmd2 = command2.addNewDrvcmd();
                        drvcmd2.setSource(BaseElementType.Source.ARCHIVE);
                        drvcmd2.setSyntax(tc.getSyntax());
                        XhtmlUtilities.setXhtmlContent((XmlObject)drvcmd2, (String)tc.getCommand());
                    }
                    ++s;
                }
                if (fileTransform.hasDerivedVars()) {
                    FileDerivationVarsType vars = command2.addNewFileDerivationVars();
                    ArrayList<String> addedVars = new ArrayList<String>();
                    ArrayList<String> droppedVars = new ArrayList<String>();
                    ArrayList<String> keptVars = new ArrayList<String>();
                    for (String added : fileTransform.getAddedVariables()) {
                        if (oldToNewIds.containsKey(added)) {
                            addedVars.add((String)oldToNewIds.get(added));
                            vars.setAdd(addedVars);
                            continue;
                        }
                        vars.setAdd(new ArrayList(fileTransform.getAddedVariables()));
                    }
                    for (String dropped : fileTransform.getDroppedVariables()) {
                        if (oldToNewIds.containsKey(dropped)) {
                            droppedVars.add((String)oldToNewIds.get(dropped));
                            vars.setDrop(droppedVars);
                            continue;
                        }
                        vars.setDrop(new ArrayList(fileTransform.getDroppedVariables()));
                    }
                    for (String kept : fileTransform.getKeptVariables()) {
                        if (oldToNewIds.containsKey(kept)) {
                            keptVars.add((String)oldToNewIds.get(kept));
                            vars.setKeep(keptVars);
                            continue;
                        }
                        vars.setKeep(new ArrayList(fileTransform.getKeptVariables()));
                    }
                }
                if (fileTransform.isAddCases()) {
                    command2.setFileDerivationCases(FileDerivationCasesType.ADD);
                }
                if (!fileTransform.isDropCases()) continue;
                command2.setFileDerivationCases(FileDerivationCasesType.DROP);
            }
            FileTxtType ftt = derivedFileDscr.addNewFileTxt();
            XhtmlUtilities.setXhtmlContent((XmlObject)ftt.addNewDimensns().addNewVarQnty(), (String)String.valueOf(fileVarCount));
            XhtmlUtilities.setXhtmlContent((XmlObject)ftt.addNewFileName(), (String)String.valueOf(dataSet.getName()));
            updatedDocument.getCodeBook().getFileDscrList().add(derivedFileDscr);
            ++n2;
        }
        return updatedDocument;
    }

    @Override
    public SchemaType supports() {
        return CodeBookDocument.type;
    }

    private CodeBookDocument initializeDocument() {
        CodeBookDocument document = CodeBookDocument.Factory.newInstance();
        CodeBookType documentXml = document.addNewCodeBook();
        documentXml.setID(DOCUMENT_ID);
        CitationType citation = documentXml.addNewStdyDscr().addNewCitation();
        ProdStmtType prodStmt = citation.addNewProdStmt();
        SimpleTextAndDateType prodDate = prodStmt.addNewProdDate();
        LocalDate now = LocalDate.now();
        prodDate.setDate(now.toString());
        XhtmlUtilities.setXhtmlContent((XmlObject)prodDate, (String)now.toString());
        SoftwareType software = prodStmt.addNewSoftware();
        software.setVersion(SOFTWARE_VERSION);
        software.setDate(now.toString());
        XhtmlUtilities.setXhtmlContent((XmlObject)software, (String)SOFTWARE_NAME);
        return document;
    }

    private void copyOriginalXml(CodeBookType original, CodeBookType updated) {
        for (org.ddialliance.ddi_2_5.xml.xmlbeans.FileDscrType fileDscr : original.getFileDscrList()) {
            this.fileIds.add(fileDscr.getID());
            updated.getFileDscrList().add((org.ddialliance.ddi_2_5.xml.xmlbeans.FileDscrType)fileDscr.copy());
        }
        for (DataDscrType dataDscr : original.getDataDscrList()) {
            updated.getDataDscrList().add((DataDscrType)dataDscr.copy());
            for (VarType var : dataDscr.getVarList()) {
                int ivr;
                var = (VarType)var.copy();
                var.getSumStatList().clear();
                var.getLocationList().clear();
                var.unsetFiles();
                int vr = var.sizeOfValrngArray();
                if (vr > 0) {
                    var.removeValrng(vr - 1);
                }
                if ((ivr = var.sizeOfInvalrngArray()) > 0) {
                    var.removeInvalrng(ivr - 1);
                }
                for (CatgryType cat : var.getCatgryList()) {
                    cat.getCatStatList().clear();
                }
                this.originalVarMap.put(var.getID(), var);
            }
        }
    }

    private void addCitations(Collection<CodeBookDocument> documents, CodeBookDocument newDoc) {
        StdyDscrType newDocStdy = (StdyDscrType)newDoc.getCodeBook().getStdyDscrList().get(0);
        OthrStdyMatType other = newDocStdy.addNewOthrStdyMat();
        for (CodeBookDocument cbd : documents) {
            ArrayList<CitationType> citations = new ArrayList<CitationType>();
            MaterialReferenceType relStdy = other.addNewRelStdy();
            for (StdyDscrType sdt : cbd.getCodeBook().getStdyDscrList()) {
                for (CitationType citation : sdt.getCitationList()) {
                    citations.add(citation);
                }
                relStdy.setCitationArray(citations.toArray(new CitationType[0]));
            }
        }
        CitationType citation = (CitationType)newDocStdy.getCitationList().get(0);
        TitlStmtType titleType = citation.addNewTitlStmt();
        String title = null;
        title = this.datasetMetadata.getDocumentId() != null && !this.datasetMetadata.getDocumentId().isEmpty() ? this.datasetMetadata.getDocumentId() : this.datasetMetadata.getDefaultDocumentId();
        XhtmlUtilities.setXhtmlContent((XmlObject)titleType.addNewTitl(), (String)title);
        if (!this.datasetMetadata.getAuthors().isEmpty()) {
            ProdStmtType prod = citation.getProdStmt();
            for (Author author : this.datasetMetadata.getAuthors()) {
                DdiAuthor ddiAuthor;
                if (!(author instanceof DdiAuthor) || (ddiAuthor = (DdiAuthor)author).getFullName() == null || ddiAuthor.getFullName().isEmpty()) continue;
                XhtmlUtilities.setXhtmlContent((XmlObject)prod.addNewProducer(), (String)ddiAuthor.getFullName());
            }
        }
        VerStmtType ver = citation.addNewVerStmt();
        XhtmlUtilities.setXhtmlContent((XmlObject)ver.addNewVersion(), (String)"VERSION OF DATASET RESULTED FROM TRANSFORMATION (EX: V1)");
        XhtmlUtilities.setXhtmlContent((XmlObject)ver.addNewNotes(), (String)"Data from this study were used in the transformations described in this DDI Instance ");
    }

    @Override
    public void setDatasetMetadata(DatasetMetadata metadata) {
        this.datasetMetadata = metadata;
    }

    public DatasetMetadata getDatasetMetadata() {
        return this.datasetMetadata;
    }

    @Override
    public void setLog(Logger log) {
        this.log = log;
    }

    public Logger getLog() {
        return this.log;
    }
}

