/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.reader;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.AttributeListType;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.AttributeType;
import org.ecoinformatics.eml_2_1_1.attribute.xml.xmlbeans.NonNumericDomainType;
import org.ecoinformatics.eml_2_1_1.dataset.xml.xmlbeans.DatasetType;
import org.ecoinformatics.eml_2_1_1.datatable.xml.xmlbeans.DataTableType;
import org.ecoinformatics.eml_2_1_1.party.xml.xmlbeans.Person;
import org.ecoinformatics.eml_2_1_1.party.xml.xmlbeans.ResponsibleParty;
import org.ecoinformatics.eml_2_1_1.resource.xml.xmlbeans.I18NNonEmptyStringType;
import org.ecoinformatics.eml_2_1_1.xml.xmlbeans.EmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.data.transform.command.object.FileDetails;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.DataType;
import us.mtna.pojo.Variable;
import us.mtna.reader.Reader;
import us.mtna.reader.exceptions.ReaderException;
import us.mtna.updater.Citation;
import us.mtna.updater.EmlAuthor;
import us.mtna.updater.EmlCitation;

public class ReaderImplEML211
extends Reader {
    private Logger log = LoggerFactory.getLogger(ReaderImplEML211.class);
    private Map<String, DataTableType> dataTableMap = new HashMap<String, DataTableType>();
    private FileDetails details;
    private Map<String, Object> referenceMap = new HashMap<String, Object>();

    public ReaderImplEML211() {
        this.details = new FileDetails();
        this.dataTableMap = new HashMap<String, DataTableType>();
    }

    public List<DataSet> parseDataSets(EmlDocument emlDoc) {
        ArrayList<DataSet> datasets = new ArrayList<DataSet>();
        if (emlDoc == null) {
            this.log.error("EmlDocument is null when trying to parse datsaets.");
            throw new ReaderException("Document cannot be read as an EML 2.1.1 Document");
        }
        DatasetType dataSetType = emlDoc.getEml().getDataset();
        for (DataTableType dataTable : dataSetType.getDataTableList()) {
            DataSet dataset = new DataSet();
            this.dataTableMap.put(dataTable.getEntityName(), dataTable);
            AttributeListType attributeList = dataTable.getAttributeList();
            HashMap<String, Classification> classifications = new HashMap<String, Classification>();
            for (AttributeType attribute : attributeList.getAttributeList()) {
                Classification classification = null;
                Variable variable = new Variable();
                variable.setName(attribute.getAttributeName());
                variable.setDescription(attribute.getAttributeDefinition());
                dataset.getMetadata().addVariables(new Variable[]{variable});
                if (attribute.getMeasurementScale() != null) {
                    AttributeType.MeasurementScale scale = attribute.getMeasurementScale();
                    if (scale.getNominal() != null) {
                        variable.setMeasure(Variable.Measure.NOMINAL);
                        if (scale.getNominal().getNonNumericDomain() != null) {
                            variable.setDataType(DataType.STRING);
                            classification = this.getNonNumericClassification(classification, scale.getNominal().getNonNumericDomain(), classifications);
                        }
                    }
                    if (scale.getOrdinal() != null) {
                        variable.setMeasure(Variable.Measure.ORDINAL);
                        if (scale.getOrdinal().getNonNumericDomain() != null) {
                            variable.setDataType(DataType.STRING);
                            classification = this.getNonNumericClassification(classification, scale.getOrdinal().getNonNumericDomain(), classifications);
                        }
                    }
                    variable = this.checkOtherScaleTypes(scale, variable);
                }
                if (classification == null) continue;
                classification.setName(attribute.getAttributeName());
                this.getMissingCodes(attribute, classification);
                if (!this.populated(classification)) continue;
                classifications.put(classification.getId(), classification);
                variable.setClassification(classification);
                variable.setClassificationId(classification.getId());
            }
            this.fillOutFileInfo(emlDoc);
            dataset.setFileDetails(this.details);
            if (dataTable.getNumberOfRecords() != null) {
                dataset.setRecordCount(Integer.valueOf(dataTable.getNumberOfRecords()).intValue());
            }
            dataset.setCitation((Citation)this.createCitation(emlDoc));
            dataset.getMetadata().setClassifs(classifications);
            if (dataTable.getEntityName() != null) {
                dataset.setName(dataTable.getEntityName());
            }
            datasets.add(dataset);
        }
        return datasets;
    }

    public Classification getNonNumericClassification(Classification classification, NonNumericDomainType nonNumericDomain, Map<String, Classification> classifications) {
        if (nonNumericDomain.xgetId() != null) {
            this.referenceMap.put(nonNumericDomain.xgetId().getStringValue(), nonNumericDomain);
            classification = new Classification();
            classification.setId(nonNumericDomain.xgetId().getStringValue());
        }
        if (nonNumericDomain.getReferences() != null) {
            NonNumericDomainType.References ref = nonNumericDomain.getReferences();
            nonNumericDomain = (NonNumericDomainType)this.referenceMap.get(ref.getStringValue());
            classification = classifications.get(ref.getStringValue());
        }
        if (classification == null) {
            classification = new Classification();
        }
        this.getCodesFromEnumeratedDomains(classification, nonNumericDomain);
        this.getTextDomains(classification, nonNumericDomain);
        return classification;
    }

    private boolean populated(Classification classification) {
        return classification.getName() != null || !classification.getCodeList().isEmpty();
    }

    private void getMissingCodes(AttributeType attributeType, Classification classification) {
        if (attributeType.getMissingValueCodeList() != null && !attributeType.getMissingValueCodeList().isEmpty()) {
            ArrayList<Code> missingCodes = new ArrayList<Code>();
            for (AttributeType.MissingValueCode missing : attributeType.getMissingValueCodeList()) {
                Code code = new Code();
                code.setCodeValue(missing.getCode());
                code.setLabel(missing.getCodeExplanation());
                code.setMissing(true);
                missingCodes.add(code);
            }
            classification.addCodesToCodeList(missingCodes);
        }
    }

    private Variable checkOtherScaleTypes(AttributeType.MeasurementScale scale, Variable variable) {
        if (scale.getDateTime() != null) {
            variable.setMeasure(Variable.Measure.DATE);
            variable.setDataType(DataType.DATE);
        }
        if (scale.getInterval() != null) {
            variable.setMeasure(Variable.Measure.INTERVAL);
            variable.setDataType(DataType.NUMBER);
        }
        if (scale.getRatio() != null) {
            variable.setMeasure(Variable.Measure.RATIO);
            variable.setDataType(DataType.NUMBER);
        }
        return variable;
    }

    private void getTextDomains(Classification classification, NonNumericDomainType nonNumericDomain) {
        if (nonNumericDomain.getTextDomainList() != null && !nonNumericDomain.getTextDomainList().isEmpty()) {
            for (NonNumericDomainType.TextDomain textDomain : nonNumericDomain.getTextDomainList()) {
                if (textDomain.getDefinition() == null) continue;
                textDomain.getDefinition();
            }
        }
    }

    private Classification getCodesFromEnumeratedDomains(Classification classification, NonNumericDomainType nonNumericDomain) {
        if (nonNumericDomain.getEnumeratedDomainList() != null && !nonNumericDomain.getEnumeratedDomainList().isEmpty()) {
            for (NonNumericDomainType.EnumeratedDomain enumeratedDomain : nonNumericDomain.getEnumeratedDomainList()) {
                if (enumeratedDomain.getCodeDefinitionList() == null || enumeratedDomain.getCodeDefinitionList().isEmpty()) continue;
                for (NonNumericDomainType.EnumeratedDomain.CodeDefinition codeDefinition : enumeratedDomain.getCodeDefinitionList()) {
                    Code code = new Code();
                    code.setCodeValue(codeDefinition.getCode());
                    code.setLabel(codeDefinition.getDefinition());
                    classification.addNewCode(code);
                }
            }
        }
        return classification;
    }

    private EmlCitation createCitation(EmlDocument emlDoc) {
        DatasetType dsType = emlDoc.getEml().getDataset();
        EmlCitation citation = new EmlCitation();
        ArrayList<EmlAuthor> authors = new ArrayList<EmlAuthor>();
        for (ResponsibleParty rp : dsType.getCreatorList()) {
            EmlAuthor author = new EmlAuthor();
            for (Person person : rp.getIndividualNameList()) {
                author.setSurName(person.getSurName().xmlText());
                for (I18NNonEmptyStringType givenName : person.getGivenNameList()) {
                    author.addGivenNames(new String[]{givenName.xmlText()});
                }
                for (I18NNonEmptyStringType salutation : person.getSalutationList()) {
                    author.addSalutations(new String[]{salutation.xmlText()});
                }
            }
            for (I18NNonEmptyStringType org : rp.getOrganizationNameList()) {
                author.setAffiliation(org.xmlText());
            }
            for (I18NNonEmptyStringType position : rp.getPositionNameList()) {
                author.setPosition(position.xmlText());
            }
            authors.add(author);
        }
        citation.setAuthors(authors);
        return citation;
    }

    private void fillOutFileInfo(EmlDocument emlDoc) {
        if (this.details.getUploadTime() == null) {
            this.details.setUploadTime(ZonedDateTime.now());
        }
        if (!emlDoc.getEml().getDataset().getTitleList().isEmpty()) {
            this.details.setDocumentTitle(((I18NNonEmptyStringType)emlDoc.getEml().getDataset().getTitleList().get(0)).xmlText());
        }
        this.details.setFileId(emlDoc.getEml().getPackageId());
    }
}

