/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.reader;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.ddialliance.ddi_2_5.xml.xmlbeans.BaseElementType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CatgryType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CitationType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DataDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.DimensnsType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.FileDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.FileTxtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.LablType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.LocationType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.QstnLitType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.QstnType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.SimpleTextType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.StdyDscrType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.SumStatType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.TitlStmtType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.VarFormatType;
import org.ddialliance.ddi_2_5.xml.xmlbeans.VarType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.data.transform.command.object.FileDetails;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.DataType;
import us.mtna.pojo.SummaryStatistics;
import us.mtna.pojo.Variable;
import us.mtna.reader.Reader;
import us.mtna.reader.exceptions.ReaderException;
import us.mtna.reporting.simple.CodeSorter;

public class ReaderImplDDI25
extends Reader {
    private CodeBookType codebookType;
    private Map<String, FileDscrType> fileDscrMap = new HashMap<String, FileDscrType>();
    private static Logger log = LoggerFactory.getLogger(ReaderImplDDI25.class);

    public List<DataSet> parseDataSets(CodeBookDocument codeDoc) {
        CodeBookType codeBook = codeDoc.getCodeBook();
        if (codeBook == null) {
            log.error("Codebook is null when trying to parse datsaets.");
            throw new ReaderException("Document cannot be read as a DDI 2.5 codeBook");
        }
        this.setCodebookType(codeBook);
        List<String> fileDscrIds = this.getFileDscrList(codeBook);
        List<DataSet> dataSetList = this.getDataDscrType(codeBook, fileDscrIds);
        int recordCount = this.getRecordCount(codeBook);
        String name = this.getCodeBookName(codeBook);
        String codebookId = this.getCodeBookId(codeBook);
        String nameWithId = this.appendIdToTitle(codeBook, name);
        int x = -1;
        ZonedDateTime date = ZonedDateTime.now();
        List<String> names = this.createDataSetIds(codeBook);
        for (DataSet dataSet : dataSetList) {
            log.trace("reading/creating dataset [codebookId=" + dataSet.getId() + "]");
            ++x;
            dataSet.getFile().setUploadTime(date);
            dataSet.setRecordCount(recordCount);
            dataSet.setName(nameWithId);
            dataSet.getFile().setFileId(codeBook.getID());
            dataSet.getFile().setDocumentTitle(name);
            dataSet.getFile().setFileId(codebookId);
            dataSet.getFile().setUploadTime(ZonedDateTime.now());
            dataSet.setFileDetails(this.fillOutFileInfo(dataSet));
        }
        return dataSetList;
    }

    private FileDetails fillOutFileInfo(DataSet dataSet) {
        FileDetails details = new FileDetails();
        return details;
    }

    private List<String> getFileDscrList(CodeBookType codeBook) {
        ArrayList<String> fileDescrIds = new ArrayList<String>();
        for (FileDscrType fileDscrType : codeBook.getFileDscrList()) {
            String id = null;
            if (fileDscrType.getID() != null) {
                id = fileDscrType.getID();
            } else if (fileDscrType.getFileTxtList() != null && !fileDscrType.getFileTxtList().isEmpty()) {
                for (FileTxtType ftt : fileDscrType.getFileTxtList()) {
                    Iterator iterator;
                    if (ftt.getFileNameList() == null || ftt.getFileNameList().isEmpty() || !(iterator = ftt.getFileNameList().iterator()).hasNext()) continue;
                    SimpleTextType stt = (SimpleTextType)iterator.next();
                    id = stt.getID() != null ? stt.getID() : this.getXmlTextValue((BaseElementType)stt);
                }
            } else if (fileDscrType.getURI() != null) {
                id = fileDscrType.getURI();
            }
            fileDescrIds.add(id);
            this.fileDscrMap.put(id, fileDscrType);
        }
        return fileDescrIds;
    }

    private int getRecordCount(CodeBookType codeBook) {
        int recordCountInteger = 0;
        for (FileDscrType fileDscrType : codeBook.getFileDscrList()) {
            FileTxtType fileTxtType;
            List fileTxtList = fileDscrType.getFileTxtList();
            if (fileTxtList == null || fileTxtList.isEmpty() || (fileTxtType = (FileTxtType)fileTxtList.get(0)).getDimensns() == null) continue;
            DimensnsType dimens = fileTxtType.getDimensns();
            if (dimens.getCaseQntyList() != null && !dimens.getCaseQntyList().isEmpty()) {
                String recordCount = this.getXmlTextValue((BaseElementType)dimens.getCaseQntyList().get(0));
                recordCountInteger = Integer.parseInt(recordCount.trim());
                List<DataSet> dataSetList = null;
                List<String> fileDscrIds = this.getFileDscrList(codeBook);
                dataSetList = this.getDataDscrType(codeBook, fileDscrIds);
                for (DataSet dataSet : dataSetList) {
                    dataSet.setRecordCount(recordCountInteger);
                }
                continue;
            }
            log.debug("record count is null on fileDscrType [id=" + fileDscrType.getID() + "]");
        }
        return recordCountInteger;
    }

    private List<String> createDataSetIds(CodeBookType codeBook) {
        List<String> fileDscrList = this.getFileDscrList(codeBook);
        String codeBookId = "";
        ArrayList<String> idList = new ArrayList<String>();
        if (codeBook != null && codeBook.getID() != null) {
            codeBookId = codeBook.getID();
        }
        for (String id : fileDscrList) {
            String dsId = codeBookId.concat(".").concat(id);
            idList.add(dsId);
        }
        return idList;
    }

    private String getCodeBookName(CodeBookType codeBook) {
        String name = null;
        if (codeBook.getStdyDscrList() != null && !codeBook.getStdyDscrList().isEmpty()) {
            StdyDscrType stdyDscr = (StdyDscrType)codeBook.getStdyDscrList().get(0);
            if (stdyDscr.getCitationList() != null && !stdyDscr.getCitationList().isEmpty()) {
                TitlStmtType titlStmt;
                CitationType citation = (CitationType)stdyDscr.getCitationList().get(0);
                if (citation != null && (titlStmt = citation.getTitlStmt()) != null) {
                    SimpleTextType titl = titlStmt.getTitl();
                    name = this.getXmlTextValue((BaseElementType)titl);
                }
            } else {
                log.debug("No citation list on StudyDscr [id=" + stdyDscr.getID() + "]");
            }
        } else {
            log.debug("No StdyDscrType on codebook [id=" + codeBook.getID() + "]");
        }
        return name;
    }

    private String appendIdToTitle(CodeBookType codeBook, String name) {
        String id = "";
        if (codeBook.getID() != null) {
            id = codeBook.getID();
        }
        StringBuilder sb = new StringBuilder(id);
        return sb.append("_" + name).toString();
    }

    private String getCodeBookId(CodeBookType codeBook) {
        String id = "";
        if (codeBook.getID() != null) {
            id = codeBook.getID();
        }
        return id;
    }

    private List<DataSet> getDataDscrType(CodeBookType codeBook, List<String> fileDscrIds) {
        Long startPosition = 1L;
        LinkedList<DataSet> dataSets = new LinkedList<DataSet>();
        for (String fileDscrId : fileDscrIds) {
            FileTxtType fileTxt;
            DataSet dataSet = new DataSet();
            dataSet.setDatasetId(fileDscrId);
            LinkedList<Variable> variables = new LinkedList<Variable>();
            LinkedHashMap<String, Classification> uniqueClassificationMap = new LinkedHashMap<String, Classification>();
            LinkedHashMap<String, Classification> classifIdMap = new LinkedHashMap<String, Classification>();
            for (DataDscrType dataDescriptionType : codeBook.getDataDscrList()) {
                for (VarType variableType : dataDescriptionType.getVarList()) {
                    if (!variableType.isSetFiles() || !variableType.getFiles().contains(fileDscrId)) continue;
                    Variable codebookVariable = new Variable();
                    codebookVariable.setName(variableType.getName());
                    codebookVariable.setLabel(this.getVariableLabel(variableType));
                    String variableId = variableType.getID();
                    codebookVariable.setId(variableId);
                    this.setStartEndPositions(startPosition, variableType, codebookVariable);
                    String storageWidth = this.getStorageWidth(variableType);
                    codebookVariable.setTextStorageWidth(storageWidth);
                    SummaryStatistics summaryStatistics = this.getSummaryStatistics(variableType);
                    codebookVariable.setSummaryStatistics(summaryStatistics);
                    String literalQuestionText = this.getQuestionText(variableType);
                    codebookVariable.setQuestionText(literalQuestionText);
                    DataType dataType = this.getDataType(variableType);
                    codebookVariable.setDataType(dataType);
                    Classification classification = this.getClassificationFromVariable(variableType, uniqueClassificationMap);
                    codebookVariable.setClassification(classification);
                    classifIdMap.put(classification.getId(), classification);
                    variables.add(codebookVariable);
                }
            }
            FileDscrType fileDscr = this.fileDscrMap.get(fileDscrId);
            if (fileDscr.getFileTxtList() != null && !fileDscr.getFileTxtList().isEmpty() && (fileTxt = (FileTxtType)fileDscr.getFileTxtList().get(0)).getFileNameList() != null && !fileTxt.getFileNameList().isEmpty()) {
                dataSet.setName(this.getXmlTextValue((BaseElementType)fileTxt.getFileNameList().get(0)));
            }
            dataSet.getMetadata().setClassifs(classifIdMap);
            dataSet.getMetadata().setVariables(variables);
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    private VarType getVarTypeFromId(String variableId) {
        for (DataDscrType dataDescriptionType : this.codebookType.getDataDscrList()) {
            for (VarType variableType : dataDescriptionType.getVarList()) {
                if (!variableType.getID().equals(variableId)) continue;
                return variableType;
            }
        }
        return null;
    }

    private SummaryStatistics getSummaryStatistics(VarType varType) {
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        List ssList = varType.getSumStatList();
        if (!ssList.isEmpty()) {
            HashSet<String> weightedVariableNames = new HashSet<String>();
            for (SumStatType sst : ssList) {
                List wgtd;
                if (sst.getType() == null) continue;
                String summaryStatisticsValue = this.getXmlTextValue((BaseElementType)sst);
                double summaryStatisticsDouble = ReaderImplDDI25.parseStringToDouble(summaryStatisticsValue);
                SumStatType.Type.Enum type = sst.getType();
                boolean weighted = false;
                ArrayList<String> weightedVariableIds = new ArrayList<String>();
                if (sst.getWgtd() != null) {
                    VarType varTypeFomId;
                    wgtd = sst.getWeight();
                    List weightedVars = sst.getWgtVar();
                    if (wgtd != null) {
                        for (Object weightVariableId : wgtd) {
                            weightedVariableIds.add((String)weightVariableId);
                            varTypeFomId = this.getVarTypeFromId((String)weightVariableId);
                            if (varTypeFomId == null || varTypeFomId.getName() == null) continue;
                            weightedVariableNames.add(varTypeFomId.getName());
                        }
                    }
                    if (weightedVars != null) {
                        for (Object weightVariableId : weightedVars) {
                            weightedVariableIds.add((String)weightVariableId);
                            varTypeFomId = this.getVarTypeFromId((String)weightVariableId);
                            if (varTypeFomId == null || varTypeFomId.getName() == null) continue;
                            weightedVariableNames.add(varTypeFomId.getName());
                        }
                    }
                }
                summaryStatistics.setWeightedVariableNames(weightedVariableNames);
                if (sst.getWgtd() != null) {
                    wgtd = sst.getWgtd();
                    weighted = wgtd.intValue() == 1;
                }
                this.setSumStatsMeasures(summaryStatistics, summaryStatisticsDouble, type, weighted);
            }
        }
        return summaryStatistics;
    }

    private void setSumStatsMeasures(SummaryStatistics summaryStatistics, double summaryStatisticsDouble, SumStatType.Type.Enum type, boolean weighted) {
        switch (type.intValue()) {
            case 1: {
                if (weighted) {
                    summaryStatistics.setWeightedMean(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setMean(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            case 2: {
                if (weighted) {
                    summaryStatistics.setWeightedMedian(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setMedian(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            case 3: {
                if (weighted) {
                    summaryStatistics.setWeightedMode(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setMode(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            case 4: {
                if (weighted) {
                    summaryStatistics.setWeightedValid(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setValid(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            case 5: {
                if (weighted) {
                    summaryStatistics.setWeightedInvalid(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setInvalid(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            case 6: {
                if (weighted) {
                    summaryStatistics.setWeightedMin(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setMin(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            case 7: {
                if (weighted) {
                    summaryStatistics.setWeightedMax(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setMax(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            case 8: {
                if (weighted) {
                    summaryStatistics.setWeightedStdDev(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setStdDev(Double.valueOf(summaryStatisticsDouble));
                break;
            }
            default: {
                if (weighted) {
                    summaryStatistics.setWeightedOther(Double.valueOf(summaryStatisticsDouble));
                    break;
                }
                summaryStatistics.setOther(Double.valueOf(summaryStatisticsDouble));
            }
        }
    }

    private static final double parseStringToDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    private String getVariableLabel(VarType varType) {
        String label = null;
        if (varType.getLablList().size() > 0) {
            LablType labelType = varType.getLablArray(0);
            label = this.getXmlTextValue((BaseElementType)labelType);
            label = label.replaceAll("(\\r|\\n)", "").trim();
        }
        return label;
    }

    private String getStorageWidth(VarType varType) {
        String width = null;
        String decimals = "0";
        if (varType.getDcml() != null) {
            decimals = varType.getDcml();
        }
        width = String.valueOf(width) + "." + decimals;
        return width;
    }

    private String getQuestionText(VarType varType) {
        QstnType qstn;
        String literalQuestionText = null;
        if (varType.getQstnList() != null && !varType.getQstnList().isEmpty() && (qstn = (QstnType)varType.getQstnList().get(0)).getQstnLitList() != null && !qstn.getQstnLitList().isEmpty()) {
            QstnLitType qstnLit = (QstnLitType)qstn.getQstnLitList().get(0);
            literalQuestionText = this.getXmlTextValue((BaseElementType)qstnLit);
        }
        return literalQuestionText;
    }

    private void setStartEndPositions(Long startPosition, VarType varType, Variable variable) {
        if (varType.getLocationList() != null && !varType.getLocationList().isEmpty()) {
            LocationType location = varType.getLocationArray(0);
            if (location.getWidth() != null) {
                String width = location.getWidth();
                variable.setTextDisplayWidth(Integer.valueOf(Integer.parseInt(width)));
            } else {
                log.debug("No width value on location [id=" + location.getID() + "]");
            }
            if (location.getStartPos() != null) {
                variable.setOriginalStart(Long.valueOf(Long.parseLong(location.getStartPos())));
                variable.setStartPosition(Long.valueOf(Long.parseLong(location.getStartPos())));
            } else {
                variable.setOriginalStart(startPosition);
                variable.setStartPosition(startPosition);
            }
            if (location.getEndPos() != null) {
                variable.setOriginalEnd(Long.valueOf(Long.parseLong(location.getEndPos())));
                variable.setEndPosition(Long.valueOf(Long.parseLong(location.getEndPos())));
            } else {
                Long end = startPosition + (Long.parseLong(location.getWidth()) - 1L);
                variable.setOriginalEnd(end);
                variable.setEndPosition(end);
                if (end == startPosition) {
                    startPosition = startPosition + 1L;
                    variable.setStartPosition(startPosition);
                } else {
                    startPosition = end + 1L;
                    variable.setStartPosition(startPosition);
                }
            }
        }
    }

    private DataType getDataType(VarType var) {
        VarFormatType varFormat = var.getVarFormat();
        if (varFormat == null) {
            return DataType.STRING;
        }
        VarFormatType.Type.Enum type = varFormat.getType();
        if (type != null && "numeric".equalsIgnoreCase(type.toString())) {
            return DataType.NUMBER;
        }
        if (type != null && "character".equalsIgnoreCase(type.toString())) {
            return DataType.STRING;
        }
        return DataType.STRING;
    }

    private Classification getClassification(VarType var) {
        Classification classification = new Classification();
        List<Code> classifCodeList = this.populateCodeListFromCat(var);
        classification.setCodeList(classifCodeList);
        return classification;
    }

    private Classification getClassificationFromVariable(VarType var, Map<String, Classification> uniqueClassMap) {
        Classification variableClassification = this.getClassification(var);
        String classificationHash = this.getClassificationHash(variableClassification);
        Classification classification = uniqueClassMap.get(classificationHash);
        if (classification == null) {
            uniqueClassMap.put(classificationHash, variableClassification);
            classification = variableClassification;
        }
        return classification;
    }

    private String getClassificationHash(Classification classification) {
        List codeList = classification.getCodeList();
        Collections.sort(codeList, new CodeSorter());
        StringBuilder sb = new StringBuilder();
        for (Code code : codeList) {
            sb.append(code.getCodeValue());
            if (code.getLabel() == null) continue;
            sb.append(code.getLabel().toLowerCase());
        }
        String codeString = sb.toString();
        try {
            byte[] bytesOfMessage = codeString.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashedString = md.digest(bytesOfMessage);
            return new String(hashedString);
        }
        catch (UnsupportedEncodingException e) {
            throw new ReaderException("UTF-8 encoding is not supported by environment", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReaderException("MD5 is not supported by environment", e);
        }
    }

    private List<Code> populateCodeListFromCat(VarType var) {
        ArrayList<Code> classifCodeList = new ArrayList<Code>();
        for (CatgryType cat : var.getCatgryList()) {
            Code code = new Code();
            code.setCodeValue(this.getXmlTextValue((BaseElementType)cat.getCatValu()));
            if (cat.getLablList() != null && !cat.getLablList().isEmpty()) {
                code.setLabel(this.getXmlTextValue((BaseElementType)cat.getLablList().get(0)));
            }
            if (cat.isSetMissing()) {
                code.setMissing(true);
            }
            classifCodeList.add(code);
        }
        return classifCodeList;
    }

    private String getXmlTextValue(BaseElementType element) {
        XmlCursor curs = element.newCursor();
        String text = curs.getTextValue();
        curs.dispose();
        return text;
    }

    public CodeBookType getCodebookType() {
        return this.codebookType;
    }

    public void setCodebookType(CodeBookType codebookType) {
        this.codebookType = codebookType;
    }

    public void setLog(Logger log) {
        ReaderImplDDI25.log = log;
    }
}

