/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.reader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.ecoinformatics.eml_2_1_1.xml.xmlbeans.EmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.data.transform.command.object.FileDetails;
import us.mtna.pojo.DataSet;
import us.mtna.reader.ReaderImplDDI25;
import us.mtna.reader.ReaderImplEML211;
import us.mtna.reader.exceptions.ReaderException;
import us.mtna.reader.exceptions.RequestException;
import us.mtna.reader.exceptions.XmlValidationException;

public abstract class Reader {
    protected static boolean validate;
    protected FileDetails details = new FileDetails();
    private static final String FAILED_AT_STARTUP = "failed at startup";
    protected static Logger log;

    static {
        log = LoggerFactory.getLogger(ReaderImplEML211.class);
    }

    public List<DataSet> getDataSets(File file) {
        this.fillOutFileDetails(file);
        return Reader.getDataSets(this.getXmlObjectFromFile(file));
    }

    private void fillOutFileDetails(File file) {
        String[] tokens = file.getName().split("\\.(?=[^\\.]+$)");
        this.details.setExtension(tokens[1]);
        this.details.setFileName(tokens[0]);
        this.details.setFilePath(file.getPath());
        this.details.setUploadTime(ZonedDateTime.now());
    }

    public List<DataSet> getDataSets(InputStream inputStream) {
        return Reader.getDataSets(Reader.getXmlObjectFromInputStream(inputStream));
    }

    public static List<DataSet> getDataSets(XmlObject xml) {
        return Reader.getDataSets(xml, Reader.isValidate());
    }

    public static List<DataSet> getDataSets(XmlObject xml, boolean validate) {
        if (validate) {
            Reader.validateXml(xml);
        }
        if (xml instanceof CodeBookDocument) {
            ReaderImplDDI25 reader = new ReaderImplDDI25();
            return reader.parseDataSets((CodeBookDocument)xml);
        }
        if (xml instanceof EmlDocument) {
            ReaderImplEML211 reader = new ReaderImplEML211();
            return reader.parseDataSets((EmlDocument)xml);
        }
        if (xml.schemaType().getName() != null) {
            log.error("Unsupported input document [" + xml.schemaType().getName().toString() + "]");
            throw new RequestException("Unsupported input document [" + xml.schemaType().getName().toString() + "]");
        }
        throw new RequestException("XML type not recognized");
    }

    public DataSet getDataSets(InputStream xml, String scriptName, String xmlName, Integer position) {
        XmlObject xmlObject = Reader.getXmlObjectFromInputStream(xml);
        if (validate) {
            Reader.validateXml(xmlObject);
        }
        List<DataSet> datasets = Reader.getDataSets(xmlObject);
        DataSet dataset = datasets.get(0);
        if (position != null && datasets.size() >= position) {
            dataset = datasets.get(position - 1);
        } else if (xmlName != null) {
            for (DataSet set : datasets) {
                if (!set.getName().equals(xmlName)) continue;
                dataset = set;
            }
        }
        if (scriptName == null) {
            dataset.setScriptName(scriptName);
        }
        dataset.setScriptName(scriptName);
        return dataset;
    }

    public static XmlObject getXmlObjectFromInputStream(InputStream xml) {
        try {
            return XmlObject.Factory.parse((InputStream)xml, (XmlOptions)new XmlOptions().setLoadStripWhitespace());
        }
        catch (XmlException e) {
            log.error("xml exception", (Throwable)e);
            throw new ReaderException("Error reading XML", e);
        }
        catch (IOException e) {
            log.error(FAILED_AT_STARTUP, (Throwable)e);
            throw new ReaderException("IO error reading XML", e);
        }
    }

    public XmlObject getXmlObjectFromFile(File file) {
        try {
            return XmlObject.Factory.parse((File)file, (XmlOptions)new XmlOptions().setLoadStripWhitespace());
        }
        catch (XmlException e) {
            log.error("xml exception", (Throwable)e);
            throw new ReaderException("Error reading XML", e);
        }
        catch (FileNotFoundException e) {
            log.error(FAILED_AT_STARTUP, (Throwable)e);
            throw new ReaderException("File not found", e);
        }
        catch (IOException e) {
            log.error(FAILED_AT_STARTUP, (Throwable)e);
            throw new ReaderException("IO error reading XML", e);
        }
    }

    public void setValidate(boolean validate) {
        Reader.validate = validate;
    }

    public static boolean isValidate() {
        return validate;
    }

    public static void validateXml(XmlObject xml) {
        if (Reader.isValidate()) {
            ArrayList<XmlError> errors = new ArrayList<XmlError>();
            xml.validate(new XmlOptions().setErrorListener(errors));
            if (!errors.isEmpty()) {
                throw new XmlValidationException(errors);
            }
        }
    }
}

