/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.transform.cogs.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.c2metadata.sdtl.pojo.command.CommandBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.pojo.Transform;
import us.mtna.pojo.TransformCommand;
import us.mtna.transform.cogs.json.PseudocodeService;

public class TransformMapper {
    public static final String SDTL_POJO = "sdtl-pojo";
    public static final String SDTL_PSEUDOCODE = "sdtl-pseudocode";
    private static PseudocodeService pseudocodeService;
    private static ObjectMapper mapper;
    private static Logger log;

    private static TransformCommand baseToCommand(CommandBase base, String syntax) {
        TransformCommand command = new TransformCommand();
        if (base.getSourceInformation() != null) {
            command.setCommand(base.getSourceInformation().getOriginalSourceText());
        } else if (base.getCommand() != null) {
            command.setCommand(base.getCommand());
        }
        if (syntax != null) {
            command.setSyntax(syntax);
        }
        return command;
    }

    public static Transform mapTransformBase(CommandBase base, String syntax) {
        Transform transform = new Transform();
        transform.setOriginalCommand(TransformMapper.baseToCommand(base, syntax));
        try {
            transform.addAlternativeCommands(new TransformCommand(SDTL_POJO, mapper.writeValueAsString((Object)base)));
        }
        catch (JsonProcessingException e) {
            log.warn("Error transforming TransformBase to JSON", (Throwable)e);
        }
        if (pseudocodeService != null) {
            try {
                transform.addAlternativeCommands(new TransformCommand(SDTL_PSEUDOCODE, pseudocodeService.generate(mapper.writeValueAsString((Object)base))));
            }
            catch (JsonProcessingException | RuntimeException e) {
                log.warn("Error transforming TransformBase to SDTL pseudocode", e);
            }
        } else {
            log.warn("PseudocodeService is null when trying to add pseudoce to transform.");
        }
        return transform;
    }

    public static Transform mapTransformBase(CommandBase base, String syntax, String pseudocode) {
        Transform transform = new Transform();
        transform.setOriginalCommand(TransformMapper.baseToCommand(base, syntax));
        try {
            transform.addAlternativeCommands(new TransformCommand(SDTL_POJO, mapper.writeValueAsString((Object)base)));
        }
        catch (JsonProcessingException e) {
            log.warn("Error transforming TransformBase to JSON", (Throwable)e);
        }
        try {
            transform.addAlternativeCommands(new TransformCommand(SDTL_PSEUDOCODE, pseudocode));
        }
        catch (RuntimeException e) {
            log.warn("Error transforming TransformBase to SDTL pseudocode", (Throwable)e);
        }
        return transform;
    }

    public static void setPseudocodeService(PseudocodeService service) {
        pseudocodeService = service;
    }

    static {
        log = LoggerFactory.getLogger(TransformMapper.class);
        mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

