/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.reporting.simple;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.mtna.config.VariablePair;
import us.mtna.pojo.Attribute;
import us.mtna.pojo.Code;
import us.mtna.pojo.Variable;
import us.mtna.reporting.ComparisonResult;
import us.mtna.reporting.Report;
import us.mtna.reporting.ResultType;
import us.mtna.reporting.simple.AttributeComparisonResult;
import us.mtna.reporting.simple.ClassificationComparisonResult;
import us.mtna.reporting.simple.ClassificationStatistics;
import us.mtna.reporting.simple.ComparisonOutput;
import us.mtna.reporting.simple.ComparisonOutputResults;
import us.mtna.reporting.simple.ComparisonRequest;
import us.mtna.reporting.simple.DataSetComparisonResults;
import us.mtna.reporting.simple.DataSetComparisonStatistics;
import us.mtna.reporting.simple.DataSetComparisonVariables;
import us.mtna.reporting.simple.SimpleComparisonResult;
import us.mtna.reporting.simple.VariableComparisonResult;
import us.mtna.reporting.simple.VariableStatistics;

public class SimpleMapper {
    public ComparisonOutput populateComparisonOutput(Report report) {
        ComparisonOutput comparisonOutput = new ComparisonOutput();
        ComparisonOutputResults results = new ComparisonOutputResults();
        ArrayList<ClassificationComparisonResult> classifications = this.populateClassificationsList(report);
        ArrayList<SimpleComparisonResult> updatedVariablesList = this.populateUpdatedVariablesList(report);
        DataSetComparisonResults dataSet = this.populateDataSetResult(report);
        VariableComparisonResult variableComparisonResults = this.populateVariableComparisonResult(report, updatedVariablesList);
        results.setDataSetComparisonResults(dataSet);
        results.setVariableComparisonResults(variableComparisonResults);
        results.setClassificationComparisonResults(classifications);
        ComparisonRequest request = new ComparisonRequest();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
        ZonedDateTime time = ZonedDateTime.now();
        request.setTimestamp(time.format(dateTimeFormatter));
        comparisonOutput.setService("DDI2.5 Dataset Comparison");
        comparisonOutput.setRequest(request);
        comparisonOutput.setResults(results);
        comparisonOutput.setConfig(report.getConfiguration());
        return comparisonOutput;
    }

    private VariableComparisonResult populateVariableComparisonResult(Report report, ArrayList<SimpleComparisonResult> variableComparisonResults) {
        VariableComparisonResult vcr = new VariableComparisonResult();
        List<ComparisonResult> varComparisonResults = report.getVarComparisonResultList();
        DataSetComparisonVariables dataSetVars = this.setDataSetComparisonVariables(varComparisonResults, variableComparisonResults);
        vcr.setVariables(dataSetVars);
        return vcr;
    }

    private DataSetComparisonResults populateDataSetResult(Report report) {
        DataSetComparisonResults dataSetComparisonResult = new DataSetComparisonResults();
        List<ComparisonResult> variableComparisonResults = report.getVarComparisonResultList();
        List<ComparisonResult> classifComparisonResults = report.getClassComparisonResultList();
        AttributeComparisonResult<?> dataSetNames = this.getDataSetNames(report);
        AttributeComparisonResult<?> dataSetClassificationCount = this.getClassificationCountComparisonResult(report);
        AttributeComparisonResult<?> dataSetRecordCount = this.getRecordCountComparisonResult(report);
        AttributeComparisonResult<?> dataSetVariableCount = this.getVariableCountComparisonResult(variableComparisonResults);
        ArrayList dataSetAttributeList = new ArrayList();
        DataSetComparisonStatistics dataSetStatistics = this.computeDataSetStatistics(variableComparisonResults, classifComparisonResults);
        dataSetAttributeList.add(dataSetNames);
        dataSetAttributeList.add(dataSetVariableCount);
        dataSetAttributeList.add(dataSetClassificationCount);
        dataSetAttributeList.add(dataSetRecordCount);
        dataSetComparisonResult.setSource(report.getDs1().getId());
        dataSetComparisonResult.setTarget(report.getDs2().getId());
        dataSetComparisonResult.setAttributes(dataSetAttributeList);
        dataSetComparisonResult.setStatistics(dataSetStatistics);
        return dataSetComparisonResult;
    }

    private AttributeComparisonResult<?> getDataSetNames(Report report) {
        String ds1Name = report.getDs1().getName();
        String ds2Name = report.getDs2().getName();
        boolean match = ds1Name.equals(ds2Name);
        return new AttributeComparisonResult<String>("dataSetNames", ds1Name, ds2Name, match, null);
    }

    private ArrayList<ClassificationComparisonResult> populateClassificationsList(Report report) {
        ArrayList<ClassificationComparisonResult> classifications = new ArrayList<ClassificationComparisonResult>();
        List<ComparisonResult> reportClassificationResults = report.getClassComparisonResultList();
        LinkedHashMap<String, ComparisonResult> indexedClassificationResults = new LinkedHashMap<String, ComparisonResult>();
        for (ComparisonResult comparisonResult : reportClassificationResults) {
            StringBuilder sb = new StringBuilder();
            if (comparisonResult.getSourceAttribute() != null) {
                Attribute<?> sourceClassification = comparisonResult.getSourceAttribute();
                sb.append(sourceClassification.getValue().toString());
            }
            if (comparisonResult.getTargetAttribute() != null) {
                Attribute<?> targetClassification = comparisonResult.getTargetAttribute();
                sb.append(targetClassification.getValue().toString());
            }
            if (comparisonResult.getType() == ResultType.MATCH) continue;
            indexedClassificationResults.put(sb.toString(), comparisonResult);
        }
        for (ComparisonResult comparisonResult : indexedClassificationResults.values()) {
            int numberOfSourceCodes = 0;
            int numberOfTargetCodes = 0;
            ClassificationComparisonResult classificationResult = this.populateClassificationResult(report.getSrcVarToClassifMap(), report.getTargetVarToClassifMap(), comparisonResult);
            LinkedHashMap<String, SimpleComparisonResult> codes = new LinkedHashMap<String, SimpleComparisonResult>();
            for (ComparisonResult child : comparisonResult.getChildResults()) {
                String name = child.getSourceAttribute() != null ? child.getSourceAttribute().getName() : child.getTargetAttribute().getName();
                if (name.equals("codeCount")) {
                    numberOfSourceCodes = (Integer)child.getSourceAttribute().getValue();
                    numberOfTargetCodes = (Integer)child.getTargetAttribute().getValue();
                    continue;
                }
                SimpleComparisonResult codeResult = new SimpleComparisonResult();
                Attribute<?> sourceAttribute = child.getSourceAttribute();
                Attribute<?> targetAttribute = child.getTargetAttribute();
                String codeValue = sourceAttribute != null ? ((Code)sourceAttribute.getValue()).getCodeValue() : ((Code)targetAttribute.getValue()).getCodeValue();
                AttributeComparisonResult<String> labelResult = new AttributeComparisonResult<String>();
                labelResult.setName("label");
                if (targetAttribute != null) {
                    labelResult.setTargetValue(((Code)targetAttribute.getValue()).getLabel());
                }
                if (sourceAttribute != null) {
                    labelResult.setSourceValue(((Code)sourceAttribute.getValue()).getLabel());
                }
                if (child.getType() != null) {
                    boolean match = this.isMatch(child.getType());
                    labelResult.setMatch(match);
                    labelResult.setDifference(child.getType());
                    codeResult.setResultType(child.getType());
                }
                codeResult.addAttributes(labelResult);
                if (codeResult.getResultType() == null || codeResult.getResultType() == ResultType.MATCH) continue;
                codes.put(codeValue, codeResult);
            }
            ArrayList classificationAttributes = new ArrayList();
            AttributeComparisonResult<Integer> codeCountComparison = new AttributeComparisonResult<Integer>("codeCount", numberOfSourceCodes, numberOfTargetCodes, this.compareCounts(numberOfSourceCodes, numberOfTargetCodes), this.getDifference(numberOfSourceCodes, numberOfTargetCodes));
            classificationAttributes.add(codeCountComparison);
            classificationResult.setAttributes(classificationAttributes);
            classificationResult.setCodes(codes);
            classifications.add(classificationResult);
        }
        return classifications;
    }

    private ClassificationComparisonResult populateClassificationResult(Map<String, List<Variable>> sourceVariableClassificationMap, Map<String, List<Variable>> targetVariableClassificationMap, ComparisonResult comparisonResult) {
        ClassificationComparisonResult classificationResult = new ClassificationComparisonResult();
        LinkedHashMap<String, String> sourceVariables = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> targetVariables = new LinkedHashMap<String, String>();
        if (comparisonResult.getSourceAttribute() != null) {
            Attribute<?> sourceClassification = comparisonResult.getSourceAttribute();
            classificationResult.setSource(sourceClassification.getValue().toString());
            if (sourceVariableClassificationMap.get(comparisonResult.getSourceAttribute().getValue()) != null) {
                Attribute<?> sourceAttribute = comparisonResult.getSourceAttribute();
                for (Variable variable : sourceVariableClassificationMap.get(sourceAttribute.getValue().toString())) {
                    sourceVariables.put(variable.getName().toLowerCase(), variable.getName());
                }
            }
        }
        if (comparisonResult.getTargetAttribute() != null) {
            Attribute<?> targetClassification = comparisonResult.getTargetAttribute();
            classificationResult.setTarget(targetClassification.getValue().toString());
            if (targetVariableClassificationMap.get(comparisonResult.getTargetAttribute().getValue()) != null) {
                Attribute<?> targetAttribute = comparisonResult.getTargetAttribute();
                for (Variable variable : targetVariableClassificationMap.get(targetAttribute.getValue().toString())) {
                    targetVariables.put(variable.getName().toLowerCase(), variable.getName());
                }
            }
        }
        ArrayList<VariablePair> variablePairList = new ArrayList<VariablePair>();
        ArrayList sourceRemovals = new ArrayList();
        ArrayList targetRemovals = new ArrayList();
        for (Map.Entry entry : sourceVariables.entrySet()) {
            if (!targetVariables.containsKey(entry.getKey())) continue;
            VariablePair pair = new VariablePair();
            pair.setSource((String)entry.getValue());
            pair.setTarget((String)targetVariables.get(entry.getKey()));
            variablePairList.add(pair);
            sourceRemovals.add(entry.getValue());
            targetRemovals.add(targetVariables.get(entry.getKey()));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> additionalTargetVariables = new ArrayList<String>();
        arrayList.addAll(sourceVariables.values());
        additionalTargetVariables.addAll(targetVariables.values());
        arrayList.removeAll(sourceRemovals);
        additionalTargetVariables.removeAll(targetRemovals);
        classificationResult.setMatch(this.isMatch(comparisonResult.getType()));
        classificationResult.setResultType(comparisonResult.getType());
        classificationResult.setVariablePairs(variablePairList);
        classificationResult.setAdditionalSourceVariables(arrayList);
        classificationResult.setAdditionalTargetVariables(additionalTargetVariables);
        classificationResult.setSourceVariableCount(targetVariables.size());
        classificationResult.setTargetVariableCount(sourceVariables.size());
        return classificationResult;
    }

    private ArrayList<SimpleComparisonResult> populateUpdatedVariablesList(Report report) {
        ArrayList<SimpleComparisonResult> variableComparisonResults = new ArrayList<SimpleComparisonResult>();
        block3: for (ComparisonResult comparisonResult : report.getVarComparisonResultList()) {
            Attribute<?> sourceAttribute = comparisonResult.getSourceAttribute();
            Attribute<?> targetAttribute = comparisonResult.getTargetAttribute();
            Boolean match = this.isMatch(comparisonResult.getType());
            SimpleComparisonResult variableComparison = new SimpleComparisonResult();
            if (sourceAttribute != null) {
                variableComparison.setSource(sourceAttribute.getValue().toString());
            }
            if (targetAttribute != null) {
                variableComparison.setTarget(targetAttribute.getValue().toString());
            }
            variableComparison.setMatch(match);
            List<ComparisonResult> childResults = comparisonResult.getChildResults();
            if (!childResults.isEmpty()) {
                List<AttributeComparisonResult<?>> variableAttributes = new ArrayList();
                variableAttributes = this.addComparisonToVariableAttributeComparisonList(childResults, variableAttributes);
                variableComparison.setAttributes(variableAttributes);
                for (ComparisonResult cr : childResults) {
                    List<ComparisonResult> grandchildResults = cr.getChildResults();
                    if (!"summaryStats".equals(cr.getSourceAttribute().getName()) || grandchildResults.isEmpty()) continue;
                    List<AttributeComparisonResult<?>> varAtts = this.addComparisonToVariableAttributeComparisonList(grandchildResults, new ArrayList());
                    for (AttributeComparisonResult<?> att : variableAttributes) {
                        if (!att.getName().equals("summaryStats")) continue;
                        att.setAttributes(varAtts);
                    }
                }
            }
            if (variableComparison.getMatch().booleanValue()) continue;
            variableComparison.setResultType(comparisonResult.getType());
            switch (variableComparison.getResultType()) {
                case MATCH: 
                case NO_TARGET: 
                case NO_SOURCE: {
                    continue block3;
                }
            }
            variableComparisonResults.add(variableComparison);
        }
        return variableComparisonResults;
    }

    public DataSetComparisonVariables setDataSetComparisonVariables(List<ComparisonResult> varComparisons, List<SimpleComparisonResult> variableComaprisonResults) {
        ArrayList<String> addedList = new ArrayList<String>();
        ArrayList<String> deletedList = new ArrayList<String>();
        for (ComparisonResult cr : varComparisons) {
            ResultType type = cr.getType();
            if (type == ResultType.NO_SOURCE) {
                addedList.add(cr.getTargetAttribute().getValue().toString());
            }
            if (type != ResultType.NO_TARGET) continue;
            deletedList.add(cr.getSourceAttribute().getValue().toString());
        }
        DataSetComparisonVariables variables = new DataSetComparisonVariables();
        variables.setNewVariables(addedList);
        variables.setDroppedVariables(deletedList);
        variables.setUpdatedVariables(variableComaprisonResults);
        return variables;
    }

    private DataSetComparisonStatistics computeDataSetStatistics(List<ComparisonResult> varComparisons, List<ComparisonResult> classifComparisons) {
        VariableStatistics variableStats = this.computeVariableStats(varComparisons);
        ClassificationStatistics classifStats = this.computeClassificationStats(classifComparisons);
        DataSetComparisonStatistics dataSetStatistics = new DataSetComparisonStatistics();
        dataSetStatistics.setClassificationStatistics(classifStats);
        dataSetStatistics.setVariableStatistics(variableStats);
        return dataSetStatistics;
    }

    private ClassificationStatistics computeClassificationStats(List<ComparisonResult> classifComparisons) {
        int droppedClassificationCount = 0;
        int matchedClassificationCount = 0;
        int newClassificationCount = 0;
        int updatedClassificationCount = 0;
        HashSet<String> sourceClassifications = new HashSet<String>();
        HashSet<String> targetClassifications = new HashSet<String>();
        HashSet<String> matchedClassifications = new HashSet<String>();
        for (ComparisonResult comparisonResult : classifComparisons) {
            Attribute<?> targetClassification;
            Attribute<?> sourceClassification;
            boolean add;
            StringBuilder sb = new StringBuilder();
            ResultType type = comparisonResult.getType();
            if (comparisonResult.getSourceAttribute() == null && comparisonResult.getSourceAttribute() != null && (add = sourceClassifications.add((sourceClassification = comparisonResult.getSourceAttribute()).getValue().toString()))) {
                ++newClassificationCount;
            }
            if (comparisonResult.getSourceAttribute() == null && comparisonResult.getTargetAttribute() != null && (add = targetClassifications.add((targetClassification = comparisonResult.getTargetAttribute()).getValue().toString()))) {
                ++droppedClassificationCount;
            }
            if (comparisonResult.getSourceAttribute() == null || comparisonResult.getTargetAttribute() == null) continue;
            if (comparisonResult.getType() == ResultType.MATCH) {
                targetClassification = comparisonResult.getTargetAttribute();
                Attribute<?> sourceClassification2 = comparisonResult.getSourceAttribute();
                sb.append(sourceClassification2.getValue().toString());
                sb.append(targetClassification.getValue().toString());
                boolean add2 = matchedClassifications.add(sb.toString());
                if (!add2) continue;
                ++matchedClassificationCount;
                continue;
            }
            if (type != ResultType.MISMATCH && type != ResultType.CASE_MISMATCH && type != ResultType.CLOSE_MATCH && type != ResultType.SPACE_MISMATCH) continue;
            ++updatedClassificationCount;
        }
        ClassificationStatistics classifStats = new ClassificationStatistics();
        classifStats.setDroppedClassificationCount(droppedClassificationCount);
        classifStats.setMatchedClassificationCount(matchedClassificationCount);
        classifStats.setNewClassificationCount(newClassificationCount);
        classifStats.setUpdatedClassificationCount(updatedClassificationCount);
        return classifStats;
    }

    private VariableStatistics computeVariableStats(List<ComparisonResult> varComparisons) {
        int matched = 0;
        int dropped = 0;
        int updated = 0;
        int added = 0;
        for (ComparisonResult cr : varComparisons) {
            ResultType type = cr.getType();
            if (type == ResultType.NO_SOURCE) {
                ++added;
            }
            if (type == ResultType.NO_TARGET) {
                ++dropped;
            }
            if (type == ResultType.MATCH) {
                ++matched;
            }
            if (type != ResultType.MISMATCH && type != ResultType.CASE_MISMATCH && type != ResultType.CLOSE_MATCH && type != ResultType.SPACE_MISMATCH) continue;
            ++updated;
        }
        VariableStatistics variableStats = new VariableStatistics();
        variableStats.setDroppedVariableCount(dropped);
        variableStats.setMatchedVariableCount(matched);
        variableStats.setNewVariableCount(added);
        variableStats.setUpdatedVariableCount(updated);
        return variableStats;
    }

    private AttributeComparisonResult<?> getClassificationCountComparisonResult(Report report) {
        List<ComparisonResult> classificationComparisonResults = report.getClassComparisonResultList();
        int sourceClassificationCount = 0;
        int targetClassificationCount = 0;
        HashSet<String> sourceClassifications = new HashSet<String>();
        HashSet<String> targetClassifications = new HashSet<String>();
        for (ComparisonResult comparisonResult : classificationComparisonResults) {
            boolean added;
            StringBuilder sb = new StringBuilder();
            if (comparisonResult.getSourceAttribute() != null) {
                Attribute<?> sourceClassification = comparisonResult.getSourceAttribute();
                added = sourceClassifications.add(sourceClassification.getValue().toString());
                if (added) {
                    ++sourceClassificationCount;
                }
                sb.append(sourceClassification.getValue().toString());
            }
            if (comparisonResult.getTargetAttribute() == null) continue;
            Attribute<?> targetClassification = comparisonResult.getTargetAttribute();
            added = targetClassifications.add(targetClassification.getValue().toString());
            if (added) {
                ++targetClassificationCount;
            }
            sb.append(targetClassification.getValue().toString());
        }
        return new AttributeComparisonResult<Integer>("classificationCount", sourceClassificationCount, targetClassificationCount, this.compareCounts(sourceClassificationCount, targetClassificationCount), this.getDifference(sourceClassificationCount, targetClassificationCount));
    }

    private AttributeComparisonResult<?> getVariableCountComparisonResult(List<ComparisonResult> variableComparisonResults) {
        int sourceAttributeCount = 0;
        int targetAttributeCount = 0;
        for (ComparisonResult comparisonResult : variableComparisonResults) {
            if (comparisonResult.getSourceAttribute() != null) {
                ++sourceAttributeCount;
            }
            if (comparisonResult.getTargetAttribute() == null) continue;
            ++targetAttributeCount;
        }
        return new AttributeComparisonResult<Integer>("variableCount", sourceAttributeCount, targetAttributeCount, this.compareCounts(sourceAttributeCount, targetAttributeCount), this.getDifference(sourceAttributeCount, targetAttributeCount));
    }

    private AttributeComparisonResult<?> getRecordCountComparisonResult(Report report) {
        int numberOfSourceRecords = report.getDs1().getRecordCount();
        int numberOfTargetRecords = report.getDs2().getRecordCount();
        return new AttributeComparisonResult<Integer>("recordCount", numberOfSourceRecords, numberOfTargetRecords, this.compareCounts(numberOfSourceRecords, numberOfTargetRecords), this.getDifference(numberOfSourceRecords, numberOfTargetRecords));
    }

    private boolean compareCounts(int sourceAttributeCount, int targetAttributeCount) {
        boolean numbersMatch = false;
        if (targetAttributeCount == sourceAttributeCount) {
            numbersMatch = true;
        }
        return numbersMatch;
    }

    private ResultType getDifference(int src, int target) {
        ResultType type = ResultType.MISMATCH;
        if (target > src) {
            type = ResultType.GREATER_THAN;
        }
        if (target < src) {
            type = ResultType.LESS_THAN;
        }
        if (target == src) {
            type = null;
        }
        return type;
    }

    private List<AttributeComparisonResult<?>> addComparisonToVariableAttributeComparisonList(List<ComparisonResult> childResults, List<AttributeComparisonResult<?>> variableAttributes) {
        for (ComparisonResult comparisonResult : childResults) {
            AttributeComparisonResult attributeComparisonResult = new AttributeComparisonResult();
            if (comparisonResult.getSourceAttribute() != null) {
                attributeComparisonResult.setSourceValue(comparisonResult.getSourceAttribute().getValue());
                attributeComparisonResult.setName(comparisonResult.getSourceAttribute().getName());
            }
            if (comparisonResult.getTargetAttribute() != null) {
                attributeComparisonResult.setTargetValue(comparisonResult.getTargetAttribute().getValue());
                attributeComparisonResult.setName(comparisonResult.getTargetAttribute().getName());
            }
            ResultType type = null;
            type = comparisonResult.getType();
            if (type == null) continue;
            attributeComparisonResult.setMatch(this.isMatch(type));
            attributeComparisonResult.setDifference(type);
            if ("summaryStats".equals(attributeComparisonResult.getName()) && !comparisonResult.getChildResults().isEmpty()) {
                attributeComparisonResult.setSourceValue(null);
                attributeComparisonResult.setTargetValue(null);
            }
            if (type != ResultType.MATCH && type != ResultType.NO_SOURCE && type != ResultType.NO_TARGET) {
                variableAttributes.add(attributeComparisonResult);
            }
            if (!"SummaryStats:WeightVariables".equals(attributeComparisonResult.getName()) || type == ResultType.MATCH) continue;
            variableAttributes.add(attributeComparisonResult);
        }
        return variableAttributes;
    }

    private boolean isMatch(ResultType type) {
        return ResultType.MATCH == type;
    }
}

