/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.pojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import us.mtna.pojo.Attribute;
import us.mtna.pojo.Classification;
import us.mtna.pojo.DataType;
import us.mtna.pojo.ResourceImpl;
import us.mtna.pojo.SummaryStatistics;
import us.mtna.pojo.Transform;

public class Variable
extends ResourceImpl {
    public static final String SUMMARY_STATS = "summaryStats";
    private DataType dataType;
    private SummaryStatistics summaryStatistics;
    private String classificationId;
    private String questionText;
    private Integer textDisplayWidth;
    private Long originalStart;
    private Long startPosition;
    private Long originalEnd;
    private Long endPosition;
    private String textStorageWidth;
    private String label;
    private List<Transform> transforms = new ArrayList<Transform>();
    private String originalSourceId;
    private boolean modified;
    private boolean deleted;
    private boolean referenced;
    private String description;
    private Measure measure;
    public static final Comparator<Variable> StartPositionComparator = new Comparator<Variable>(){

        @Override
        public int compare(Variable v1, Variable v2) {
            Long startPos1 = v1.getStartPosition();
            Long startPos2 = v2.getStartPosition();
            return startPos1.compareTo(startPos2);
        }
    };

    public Variable() {
    }

    public Variable(String name, String id) {
        this(name, id, null);
    }

    public Variable(String name, String id, DataType dataType) {
        this();
        this.name = name;
        this.uuid = id;
        this.dataType = dataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public SummaryStatistics getSummaryStatistics() {
        return this.summaryStatistics;
    }

    public void setSummaryStatistics(SummaryStatistics summaryStatistics) {
        this.summaryStatistics = summaryStatistics;
    }

    public String getClassificationId() {
        return this.classificationId;
    }

    public void setClassification(Classification classification) {
        this.classificationId = classification.getId();
    }

    public String getQuestionText() {
        return this.questionText;
    }

    public void setQuestionText(String questionText) {
        this.questionText = questionText;
    }

    public Integer getTextDisplayWidth() {
        return this.textDisplayWidth;
    }

    public void setTextDisplayWidth(Integer textDisplayWidth) {
        this.textDisplayWidth = textDisplayWidth;
    }

    public Long getOriginalStart() {
        return this.originalStart;
    }

    public void setOriginalStart(Long originalStart) {
        this.originalStart = originalStart;
    }

    public Long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(Long startPosition) {
        this.startPosition = startPosition;
    }

    public Long getOriginalEnd() {
        return this.originalEnd;
    }

    public void setOriginalEnd(Long originalEnd) {
        this.originalEnd = originalEnd;
    }

    public Long getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(Long endPosition) {
        this.endPosition = endPosition;
    }

    public String getTextStorageWidth() {
        return this.textStorageWidth;
    }

    public void setTextStorageWidth(String textStorageWidth) {
        this.textStorageWidth = textStorageWidth;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public String getOriginalSourceId() {
        return this.originalSourceId;
    }

    public void setOriginalSourceId(String originalSourceId) {
        this.originalSourceId = originalSourceId;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public Transform[] getTransforms() {
        return this.transforms.toArray(new Transform[0]);
    }

    public void setTransforms(Collection<Transform> transforms) {
        this.transforms.clear();
        this.transforms.addAll(transforms);
    }

    public void addTransforms(Transform ... transforms) {
        for (Transform transform : transforms) {
            this.transforms.add(transform);
        }
    }

    public void removeAllTransforms() {
        this.transforms.clear();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isReferenced() {
        return this.referenced;
    }

    public void setReferenced(boolean referenced) {
        this.referenced = referenced;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        List<Attribute<?>> attributes = super.getAttributes();
        if (this.dataType != null) {
            Attribute<DataType> dataTypeAttribute = new Attribute<DataType>(DataType.class);
            dataTypeAttribute.setName("DataType");
            dataTypeAttribute.setValue(this.dataType);
            attributes.add(dataTypeAttribute);
        }
        if (this.summaryStatistics != null) {
            Attribute<SummaryStatistics> summaryStatsAttribute = new Attribute<SummaryStatistics>(SummaryStatistics.class);
            summaryStatsAttribute.setName(SUMMARY_STATS);
            summaryStatsAttribute.setValue(this.summaryStatistics);
            attributes.add(summaryStatsAttribute);
        }
        if (this.questionText != null) {
            Attribute<String> questionTextAtt = new Attribute<String>(String.class);
            questionTextAtt.setName("QuestionText");
            questionTextAtt.setValue(this.questionText);
            attributes.add(questionTextAtt);
        }
        Attribute<Boolean> deletedAttribute = new Attribute<Boolean>(Boolean.class);
        deletedAttribute.setName("Deleted");
        deletedAttribute.setValue(this.deleted);
        attributes.add(deletedAttribute);
        return attributes;
    }

    public static enum Measure {
        NOMINAL,
        ORDINAL,
        INTERVAL,
        RATIO,
        PERCENT,
        DATE,
        OTHER;

    }
}

