/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.pojo;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import us.mtna.pojo.Attribute;
import us.mtna.pojo.Code;
import us.mtna.pojo.ResourceImpl;

public class Classification
extends ResourceImpl {
    public static final String CODE_COUNT = "codeCount";
    public static final String CODE_LIST = "codeList";
    public static final String CODE = "code";
    private LinkedHashMap<String, Code> codeList = new LinkedHashMap();

    public List<Code> getCodeList() {
        return new ArrayList<Code>(this.codeList.values());
    }

    public Attribute<List<Code>> getCodeListAttr() {
        if (this.codeList != null) {
            Attribute<List<Code>> codeListAttribute = new Attribute<List<Code>>();
            codeListAttribute.setName(CODE_LIST);
            codeListAttribute.setValue(this.getCodeList());
            return codeListAttribute;
        }
        return null;
    }

    public void setCodeList(List<Code> codeList) {
        this.codeList.clear();
        this.addCodesToCodeList(codeList);
    }

    public void addCodesToCodeList(List<Code> codeList) {
        for (Code c : codeList) {
            this.codeList.put(c.getCodeValue().trim(), c);
        }
    }

    public List<Attribute<Code>> getCodes() {
        ArrayList<Attribute<Code>> codes = new ArrayList<Attribute<Code>>();
        if (this.codeList != null) {
            for (Code code : this.codeList.values()) {
                Attribute<Code> codeAttribute = new Attribute<Code>(Code.class);
                codeAttribute.setName(CODE);
                codeAttribute.setValue(code);
                codes.add(codeAttribute);
            }
        }
        return codes;
    }

    public Attribute<Code> getCodeForLabel(String label) {
        if (this.codeList != null) {
            for (Code code : this.codeList.values()) {
                if (!code.getLabel().equals(label)) continue;
                Attribute<Code> codeAttribute = new Attribute<Code>(Code.class);
                codeAttribute.setName(CODE);
                codeAttribute.setValue(code);
                return codeAttribute;
            }
        }
        return null;
    }

    public Attribute<Integer> getCodeCount() {
        Attribute<Integer> codeCount = new Attribute<Integer>(Integer.class);
        codeCount.setName(CODE_COUNT);
        if (this.codeList != null) {
            codeCount.setValue(this.codeList.size());
        } else {
            codeCount.setValue(0);
        }
        return codeCount;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        List<Attribute<?>> attributes = super.getAttributes();
        if (this.codeList != null) {
            for (Code code : this.codeList.values()) {
                Attribute<Code> codeAttribute = new Attribute<Code>(Code.class);
                codeAttribute.setName(CODE);
                codeAttribute.setValue(code);
                attributes.add(codeAttribute);
            }
        }
        return attributes;
    }

    public Code lookupCode(String codeValue) {
        return this.codeList.get(codeValue);
    }

    public List<Code> getCodesByValues(List<String> codeValues) {
        ArrayList<Code> codes = new ArrayList<Code>();
        for (String value : codeValues) {
            codes.add(this.lookupCode(value));
        }
        return codes;
    }

    public void removeCode(String codeValue) {
        this.codeList.remove(codeValue);
    }

    public void addNewCode(Code code) {
        this.codeList.put(code.getCodeValue().trim(), code);
    }

    public List<Code> selectCodeRange(String startValue, String endValue) {
        ArrayList<Code> codes = new ArrayList<Code>();
        boolean inRange = false;
        Integer start = null;
        Integer end = null;
        if (startValue.matches("-?\\d+")) {
            start = Integer.parseInt(startValue);
        }
        if (endValue.matches("-?\\d+")) {
            end = Integer.parseInt(endValue);
        }
        for (Code code : this.codeList.values()) {
            if (start != null && end != null) {
                Integer codeVal = null;
                if (code.getCodeValue().trim().matches("-?\\d+")) {
                    codeVal = Integer.parseInt(code.getCodeValue().trim());
                }
                if (codeVal > end || codeVal < start) continue;
                codes.add(code);
                continue;
            }
            if (startValue == null && !inRange) {
                inRange = true;
            } else if (startValue != null && !inRange) {
                inRange = startValue.equals(code.getCodeValue().trim());
            }
            if (!inRange) continue;
            codes.add(code);
            if (endValue == null) continue;
            inRange = !endValue.equals(code.getCodeValue().trim());
        }
        return codes;
    }
}

