/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.pojo.DataType;

public class SetVariableLabel
implements SelectsVariables,
UpdatesVariables {
    private final org.c2metadata.sdtl.pojo.command.SetVariableLabel sdtl;

    public SetVariableLabel(org.c2metadata.sdtl.pojo.command.SetVariableLabel sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getLabel() == null) {
            result.setValid(false);
            result.addMessages("SetVariableLabels SDTL does not have any variable labels to assign in command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "]");
        }
        if (this.sdtl.getVariable() == null) {
            result.setValid(false);
            result.addMessages("SetVariableLabels SDTL does not provide a variable to assign a label to in command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "]");
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        return this.getRangesFromVariableReferenceBase(this.sdtl.getVariable());
    }

    @Override
    public Set<String> getVariables() {
        return this.getVariablesFromVariableReferenceBase(this.sdtl.getVariable());
    }

    @Override
    public VariableNamePair[] getUpdatedVariables() {
        VariableSymbolExpression var;
        VariableNamePair pair = null;
        if (VariableSymbolExpression.class.isAssignableFrom(this.sdtl.getVariable().getClass()) && (var = (VariableSymbolExpression)this.sdtl.getVariable()).getVariableName() != null) {
            pair = new VariableNamePair(var.getVariableName(), var.getVariableName());
            if (this.sdtl.getLabel() != null) {
                pair.setLabel(this.sdtl.getLabel());
            }
        }
        return new VariableNamePair[]{pair};
    }

    @Override
    public DataType getDataType() {
        return null;
    }
}

