/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.ExpressionBase;
import org.c2metadata.sdtl.pojo.expression.NumberRangeExpression;
import org.c2metadata.sdtl.pojo.expression.StringRangeExpression;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesClassification;
import us.mtna.data.transform.command.object.ClassificationUpdate;
import us.mtna.data.transform.command.object.CodeDetail;
import us.mtna.data.transform.command.object.CodeRangeDetail;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class SetMissingValues
implements SelectsVariables,
UpdatesClassification {
    private final org.c2metadata.sdtl.pojo.command.SetMissingValues sdtl;
    private boolean requiresCopyOfClassification;
    private boolean copyFloatingCodes;

    public SetMissingValues(org.c2metadata.sdtl.pojo.command.SetMissingValues sdtl) {
        this.sdtl = sdtl;
        this.requiresCopyOfClassification = true;
        this.copyFloatingCodes = true;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.sdtl.getValues() == null || this.sdtl.getValues().length < 1) {
            validation.setValid(false);
            validation.addMessages("No values found on the SetMissingValues command.[" + this.sdtl.getSourceInformation().getOriginalSourceText() + "].");
        } else if (this.sdtl.getVariables() == null || this.sdtl.getVariables().length < 1) {
            validation.setValid(false);
            validation.addMessages("No variables found on the SetMissingValues command. [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "].");
        }
        return validation;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        return this.getRangesFromVariableReferenceBaseArray(this.sdtl.getVariables());
    }

    @Override
    public Set<String> getVariables() {
        return this.getVariablesFromVariableReferenceBaseArray(this.sdtl.getVariables());
    }

    @Override
    public ClassificationUpdate getUpdate() {
        ClassificationUpdate update = new ClassificationUpdate();
        ArrayList<CodeDetail> details = new ArrayList<CodeDetail>();
        ArrayList<CodeRangeDetail> rangeDetails = new ArrayList<CodeRangeDetail>();
        Set<Object> values = new HashSet();
        for (ExpressionBase base : this.sdtl.getValues()) {
            if (NumberRangeExpression.class.isAssignableFrom(base.getClass()) || StringRangeExpression.class.isAssignableFrom(base.getClass())) {
                Object rangeStart;
                Object rangeEnd;
                NumberRangeExpression nre;
                Range range = new Range();
                if (NumberRangeExpression.class.isAssignableFrom(base.getClass())) {
                    nre = (NumberRangeExpression)base;
                    rangeEnd = nre.getNumberRangeEnd();
                    rangeStart = nre.getNumberRangeStart();
                    range.setEnd(this.checkConstantExpressions((ExpressionBase)rangeEnd));
                    range.setStart(this.checkConstantExpressions((ExpressionBase)rangeStart));
                } else if (StringRangeExpression.class.isAssignableFrom(base.getClass())) {
                    nre = (StringRangeExpression)base;
                    rangeEnd = nre.getRangeEnd();
                    rangeStart = nre.getRangeStart();
                    range.setEnd((String)rangeEnd);
                    range.setStart((String)rangeStart);
                }
                CodeRangeDetail rangeDetail = new CodeRangeDetail();
                rangeDetail.setFromRange(range);
                rangeDetail.setMissing(true);
                rangeDetails.add(rangeDetail);
                continue;
            }
            if (this.checkConstantExpressions(base) != null) {
                String value = this.checkConstantExpressions(base);
                values.add(value);
            } else {
                values = this.parseExpression(base);
            }
            CodeDetail detail = new CodeDetail();
            detail.setMissing(true);
            detail.setFromValue(null);
            detail.setNewValue((String)values.iterator().next());
            details.add(detail);
        }
        update.setUpdatesCodeRange(rangeDetails.toArray(new CodeRangeDetail[rangeDetails.size()]));
        update.setUpdatesCodes(details.toArray(new CodeDetail[details.size()]));
        return update;
    }

    @Override
    public boolean requiresCopyOfClassification() {
        return this.requiresCopyOfClassification;
    }

    @Override
    public boolean copyFloatingCodes() {
        return this.copyFloatingCodes;
    }

    public void setCopyFloatingCodes(boolean copyFloatingCodes) {
        this.copyFloatingCodes = copyFloatingCodes;
    }

    public void setRequiresCopyOfClassification(boolean requiresCopyOfClassification) {
        this.requiresCopyOfClassification = requiresCopyOfClassification;
    }
}

