/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.RecodeRule;
import org.c2metadata.sdtl.pojo.RecodeVariable;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.ExpressionBase;
import org.c2metadata.sdtl.pojo.expression.MissingValueConstantExpression;
import org.c2metadata.sdtl.pojo.expression.NumberRangeExpression;
import org.c2metadata.sdtl.pojo.expression.NumericConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringRangeExpression;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesClassification;
import us.mtna.data.transform.command.object.ClassificationUpdate;
import us.mtna.data.transform.command.object.CodeDetail;
import us.mtna.data.transform.command.object.CodeRangeDetail;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class Recode
implements SelectsVariables,
UpdatesClassification,
CreatesVariables {
    private final org.c2metadata.sdtl.pojo.command.Recode sdtl;
    private boolean requiresCopyOfClassification;
    private boolean copyFloatingCodes;

    public Recode(org.c2metadata.sdtl.pojo.command.Recode sdtl) {
        this.sdtl = sdtl;
        this.requiresCopyOfClassification = true;
        this.copyFloatingCodes = true;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if ((this.sdtl.getRecodedVariables() == null || this.sdtl.getRecodedVariables().length < 1) && this.sdtl.getRecodedVariableRange() == null) {
            result.setValid(false);
            result.addMessages("No variables found to recode on Recode command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "]");
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public boolean preserveOriginalVariable() {
        return true;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (this.sdtl.getRecodedVariableRange() != null) {
            Range range = new Range();
            if (this.sdtl.getRecodedVariableRange().getFirst() != null) {
                range.setStart(this.sdtl.getRecodedVariableRange().getFirst());
            }
            if (this.sdtl.getRecodedVariableRange().getLast() != null) {
                range.setEnd(this.sdtl.getRecodedVariableRange().getLast());
            }
            ranges.add(range);
        }
        return ranges;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> vars = new HashSet<String>();
        for (RecodeVariable var : this.sdtl.getRecodedVariables()) {
            vars.add(var.getSource());
        }
        return vars;
    }

    @Override
    public ClassificationUpdate getUpdate() {
        ClassificationUpdate update = new ClassificationUpdate();
        ArrayList newCodes = new ArrayList();
        ArrayList<CodeRangeDetail> newCodeRanges = new ArrayList<CodeRangeDetail>();
        ArrayList<Range> removedCodeRanges = new ArrayList<Range>();
        ArrayList removedCodes = new ArrayList();
        if (this.sdtl.getRules() != null) {
            for (RecodeRule rule : this.sdtl.getRules()) {
                if (rule.getFromValue() == null) continue;
                Class<?> toClass = rule.getTo().getClass();
                for (ExpressionBase fromExpression : rule.getFromValue()) {
                    Class<?> fromClass = fromExpression.getClass();
                    if (NumberRangeExpression.class.isAssignableFrom(fromClass) || StringRangeExpression.class.isAssignableFrom(fromClass)) {
                        CodeRangeDetail codeRangeDetail = new CodeRangeDetail();
                        codeRangeDetail.setLabel(rule.getLabel());
                        String fromValue = null;
                        String toValue = null;
                        if (StringRangeExpression.class.isAssignableFrom(fromExpression.getClass())) {
                            StringRangeExpression sre = (StringRangeExpression)fromExpression;
                            fromValue = sre.getRangeStart();
                            toValue = sre.getRangeEnd();
                        } else if (NumberRangeExpression.class.isAssignableFrom(fromExpression.getClass())) {
                            NumberRangeExpression nre = (NumberRangeExpression)fromExpression;
                            ExpressionBase startExpression = nre.getNumberRangeStart();
                            ExpressionBase endExpression = nre.getNumberRangeEnd();
                            fromValue = this.checkConstantExpressions(startExpression);
                            toValue = this.checkConstantExpressions(endExpression);
                        }
                        Range fromRange = new Range();
                        fromRange.setEnd(toValue);
                        fromRange.setStart(fromValue);
                        codeRangeDetail.setFromRange(fromRange);
                        codeRangeDetail.setTargetValue(rule.getTo());
                        removedCodeRanges.add(fromRange);
                        newCodeRanges.add(codeRangeDetail);
                    } else if (MissingValueConstantExpression.class.isAssignableFrom(fromClass)) {
                        // empty if block
                    }
                    if (rule.getTo() == null || StringConstantExpression.class.isAssignableFrom(toClass) || NumericConstantExpression.class.isAssignableFrom(toClass) || MissingValueConstantExpression.class.isAssignableFrom(toClass)) continue;
                    ValidationResult v = new ValidationResult();
                    v.setValid(false);
                    v.addMessages("RecodeRule \"toValue\" [" + rule.getTo() + "]is not of the expected type");
                }
            }
        }
        update.setNewCodes(newCodes.toArray(new CodeDetail[newCodes.size()]));
        update.setNewCodeRanges(newCodeRanges.toArray(new CodeRangeDetail[newCodeRanges.size()]));
        update.setRemovedCodeRanges(removedCodeRanges.toArray(new Range[removedCodeRanges.size()]));
        update.setRemovedCodes(removedCodes.toArray(new String[removedCodes.size()]));
        return update;
    }

    @Override
    public NewVariable[] getNewVariables() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        for (RecodeVariable rv : this.sdtl.getRecodedVariables()) {
            NewVariable newVar = new NewVariable();
            if (rv.getSource().equals(rv.getTarget())) break;
            String baseVarName = rv.getSource();
            newVar.setNewVariableName(rv.getTarget());
            newVar.setBasisVariableName(baseVarName);
            newVars.add(newVar);
        }
        return newVars.toArray(new NewVariable[newVars.size()]);
    }

    @Override
    public boolean requiresCopyOfClassification() {
        return this.requiresCopyOfClassification;
    }

    public void setRequiresCopyOfClassification(boolean requiresCopyOfClassification) {
        this.requiresCopyOfClassification = requiresCopyOfClassification;
    }

    @Override
    public boolean copyFloatingCodes() {
        return this.copyFloatingCodes;
    }

    public void setCopyFloatingCodes(boolean copyFloatingCodes) {
        this.copyFloatingCodes = copyFloatingCodes;
    }
}

