/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.MergeFileDescription;
import org.c2metadata.sdtl.pojo.RenamePair;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.DeletesVariable;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.ds.MergesDatasets;
import us.mtna.data.transform.command.ds.UpdatesCases;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.UpdaterMergeFileDescription;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.pojo.DataType;

public class MergeDatasets
implements MergesDatasets,
CreatesVariables,
DeletesVariable,
UpdatesVariables,
UpdatesCases,
SelectsVariables {
    private org.c2metadata.sdtl.pojo.command.MergeDatasets sdtl;

    public MergeDatasets(org.c2metadata.sdtl.pojo.command.MergeDatasets sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public boolean preserveOriginalVariable() {
        return true;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getMergeFiles() == null || this.sdtl.getMergeFiles().length < 2) {
            result.setValid(false);
            result.addMessages("MergeDatasets command must have at least two MergeFileDescriptions. Command: [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "]");
        } else {
            int i = 0;
            for (MergeFileDescription desc : this.sdtl.getMergeFiles()) {
                StringBuilder sb;
                if (desc.getFileName() == null) {
                    result.setValid(false);
                    result.addMessages("No file name found on the merge file description at index [" + i + "] in command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "]");
                }
                if (desc.getMergeType() == null) {
                    result.setValid(false);
                    result.addMessages("No merge type found on the merge file description at index [" + i + "] in command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "]");
                } else if (this.parseMergeType(desc.getMergeType()) == null) {
                    result.setValid(false);
                    sb = new StringBuilder();
                    for (Enum enum_ : UpdaterMergeFileDescription.MergeType.values()) {
                        sb.append(enum_.toString()).append(" ");
                    }
                    result.addMessages("The mergeType [" + desc.getMergeType() + "] on the merge file description at index [" + i + "] in command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "] did not match one of the expected values: [" + sb.toString() + "]");
                }
                if (desc.getUpdate() == null) {
                    result.setValid(false);
                    result.addMessages("No update string found on the merge file description at index [" + i + "] in command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "]");
                } else if (this.parseUpdateType(desc.getUpdate()) == null) {
                    result.setValid(false);
                    sb = new StringBuilder();
                    for (Enum enum_ : UpdaterMergeFileDescription.UpdateType.values()) {
                        sb.append(enum_.toString()).append(" ");
                    }
                    result.addMessages("The update type [" + desc.getUpdate() + "] on the merge file description at index [" + i + "] in command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "] did not match one of the expected values: [" + sb.toString() + "]");
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public Set<String> getMergeByVariables() {
        return this.getVariablesFromVariableReferenceBaseArray(this.sdtl.getMergeByVariables());
    }

    @Override
    public Set<String> getKeepVariables() {
        HashSet<String> keeps = new HashSet<String>();
        for (MergeFileDescription desc : this.sdtl.getMergeFiles()) {
            keeps.addAll(this.getVariablesFromVariableReferenceBaseArray(desc.getKeepVariables()));
        }
        return keeps;
    }

    @Override
    public List<UpdaterMergeFileDescription> getMergeFileDscr() {
        ArrayList<UpdaterMergeFileDescription> list = new ArrayList<UpdaterMergeFileDescription>();
        for (MergeFileDescription dscr : this.sdtl.getMergeFiles()) {
            UpdaterMergeFileDescription file = new UpdaterMergeFileDescription();
            file.setDropVariables(dscr.getDropVariables());
            file.setFileName(dscr.getFileName());
            file.setKeepVariables(dscr.getKeepVariables());
            file.setMergeFlagVariable(dscr.getMergeFlagVariable());
            file.setMergeType(this.parseMergeType(dscr.getMergeType()));
            file.setNewRow(dscr.isNewRow());
            file.setUpdate(this.parseUpdateType(dscr.getUpdate()));
            file.setRenameVariables(this.getVarNamePairsFromRenamePairs(dscr.getRenameVariables()));
            list.add(file);
        }
        return list;
    }

    public UpdaterMergeFileDescription.MergeType parseMergeType(String text) {
        switch (text.toUpperCase().trim()) {
            case "SEQUENTIAL": {
                return UpdaterMergeFileDescription.MergeType.SEQUENTIAL;
            }
            case "ONETOONE": {
                return UpdaterMergeFileDescription.MergeType.ONE_TO_ONE;
            }
            case "MANYTOONE": {
                return UpdaterMergeFileDescription.MergeType.MANY_TO_ONE;
            }
            case "ONETOMANY": {
                return UpdaterMergeFileDescription.MergeType.ONE_TO_MANY;
            }
            case "CARTESIAN": {
                return UpdaterMergeFileDescription.MergeType.CARTESIAN;
            }
            case "UNMATCHED": {
                return UpdaterMergeFileDescription.MergeType.UNMATCHED;
            }
            case "SASMATCHMERGE": {
                return UpdaterMergeFileDescription.MergeType.SAS_MATCH_MERGE;
            }
        }
        return null;
    }

    public UpdaterMergeFileDescription.UpdateType parseUpdateType(String text) {
        switch (text.toUpperCase().trim()) {
            case "MASTER": {
                return UpdaterMergeFileDescription.UpdateType.MASTER;
            }
            case "IGNORE": {
                return UpdaterMergeFileDescription.UpdateType.IGNORE;
            }
            case "FILLNEW": {
                return UpdaterMergeFileDescription.UpdateType.FILL_NEW;
            }
            case "UPDATEMISSING": {
                return UpdaterMergeFileDescription.UpdateType.UPDATE_MISSING;
            }
            case "REPLACE": {
                return UpdaterMergeFileDescription.UpdateType.REPLACE;
            }
        }
        return null;
    }

    private List<VariableNamePair> getVarNamePairsFromRenamePairs(RenamePair[] pairs) {
        ArrayList<VariableNamePair> list = new ArrayList<VariableNamePair>();
        if (pairs != null) {
            for (RenamePair pair : pairs) {
                if (pair.getNewVariable() == null || pair.getOldVariable() == null || pair.getNewVariable().getVariableName() == null || pair.getOldVariable().getVariableName() == null) continue;
                list.add(new VariableNamePair(pair.getOldVariable().getVariableName(), pair.getNewVariable().getVariableName()));
            }
        }
        return list;
    }

    @Override
    public String getFirstVariable() {
        return this.sdtl.getFirstVariable();
    }

    @Override
    public String getLastVariable() {
        return this.sdtl.getLastVariable();
    }

    @Override
    public NewVariable[] getNewVariables() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        if (this.sdtl.getFirstVariable() != null) {
            NewVariable first = new NewVariable();
            first.setNewVariableName(this.sdtl.getFirstVariable());
            newVars.add(first);
        }
        if (this.sdtl.getLastVariable() != null) {
            NewVariable last = new NewVariable();
            last.setNewVariableName(this.sdtl.getLastVariable());
            newVars.add(last);
        }
        return newVars.toArray(new NewVariable[0]);
    }

    @Override
    public Set<String> getDeletedVars() {
        HashSet<String> drops = new HashSet<String>();
        for (MergeFileDescription desc : this.sdtl.getMergeFiles()) {
            drops.addAll(this.getVariablesFromVariableReferenceBaseArray(desc.getDropVariables()));
        }
        return drops;
    }

    @Override
    public List<Range> getDeletedVariableRanges() {
        ArrayList<Range> drops = new ArrayList<Range>();
        for (MergeFileDescription desc : this.sdtl.getMergeFiles()) {
            drops.addAll(this.getRangesFromVariableReferenceBaseArray(desc.getDropVariables()));
        }
        return drops;
    }

    @Override
    public Set<String> getKeepVars() {
        HashSet<String> kept = new HashSet<String>();
        for (MergeFileDescription file : this.sdtl.getMergeFiles()) {
            kept.addAll(this.getVariablesFromVariableReferenceBaseArray(file.getKeepVariables()));
        }
        return kept;
    }

    @Override
    public List<Range> getKeepVariableRanges() {
        ArrayList<Range> kept = new ArrayList<Range>();
        for (MergeFileDescription file : this.sdtl.getMergeFiles()) {
            kept.addAll(this.getRangesFromVariableReferenceBaseArray(file.getKeepVariables()));
        }
        return kept;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> allRanges = new ArrayList<Range>();
        allRanges.addAll(this.getKeepVariableRanges());
        allRanges.addAll(this.getDeletedVariableRanges());
        return allRanges;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> allVariables = new HashSet<String>();
        allVariables.addAll(this.getKeepVars());
        allVariables.addAll(this.getDeletedVars());
        if (this.sdtl.getFirstVariable() != null) {
            allVariables.add(this.sdtl.getFirstVariable());
        }
        if (this.sdtl.getLastVariable() != null) {
            allVariables.add(this.sdtl.getLastVariable());
        }
        for (VariableNamePair pair : this.getUpdatedVariables()) {
            allVariables.add(pair.getSource());
        }
        return allVariables;
    }

    @Override
    public VariableNamePair[] getUpdatedVariables() {
        ArrayList<VariableNamePair> pairs = new ArrayList<VariableNamePair>();
        for (MergeFileDescription file : this.sdtl.getMergeFiles()) {
            if (file.getRenameVariables() == null) continue;
            for (RenamePair rp : file.getRenameVariables()) {
                VariableSymbolExpression newVar = rp.getNewVariable();
                VariableSymbolExpression oldVar = rp.getOldVariable();
                VariableNamePair pair = new VariableNamePair(oldVar.getVariableName(), newVar.getVariableName());
                pairs.add(pair);
            }
        }
        VariableNamePair[] pairArray = new VariableNamePair[pairs.size()];
        return pairs.toArray(pairArray);
    }

    @Override
    public DataType getDataType() {
        return null;
    }
}

