/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.IterationDescription;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class LoopOverList
implements SelectsVariables {
    private final org.c2metadata.sdtl.pojo.command.LoopOverList sdtl;

    public LoopOverList(org.c2metadata.sdtl.pojo.command.LoopOverList sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getIterators() == null || this.sdtl.getIterators().length < 1) {
            result.addMessages("No iterators found on the LoopOverList command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "] ");
            result.setValid(false);
        } else {
            int i = 0;
            for (IterationDescription iterator : this.sdtl.getIterators()) {
                if (iterator.getIteratorSymbolName() == null) {
                    result.addMessages("The iteratorDescription at index " + i + " is missing an IteratorSymbolName in the LoopOverList command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "] ");
                    result.setValid(false);
                }
                if (iterator.getIteratorValues() == null || iterator.getIteratorValues().length < 1) {
                    result.addMessages("The iteratorDescription at index " + i + " is missing the iteratorValues in the LoopOverList command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "] ");
                    result.setValid(false);
                }
                ++i;
            }
        }
        if (this.sdtl.getCommands() == null || this.sdtl.getCommands().length < 1) {
            result.addMessages("No commands found on the LoopOverList command [" + this.sdtl.getSourceInformation().getOriginalSourceText() + "] ");
            result.setValid(false);
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (TransformBase base : this.sdtl.getCommands()) {
            ranges.addAll(this.getRangesFromTransformBase(base));
        }
        return ranges;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> vars = new HashSet<String>();
        for (TransformBase base : this.sdtl.getCommands()) {
            vars.addAll(this.parseTransformBase(base));
        }
        return vars;
    }
}

