/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.AppendFileDescription;
import org.c2metadata.sdtl.pojo.RenamePair;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.VariableReferenceBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.DeletesVariable;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.ds.AppendsDatasets;
import us.mtna.data.transform.command.ds.UpdatesCases;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;
import us.mtna.pojo.DataType;

public class AppendDatasets
implements AppendsDatasets,
UpdatesVariables,
UpdatesCases,
DeletesVariable,
SelectsVariables {
    private final org.c2metadata.sdtl.pojo.command.AppendDatasets sdtl;

    public AppendDatasets(org.c2metadata.sdtl.pojo.command.AppendDatasets sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getAppendFiles() == null || this.sdtl.getAppendFiles().length < 1) {
            result.setValid(false);
            result.addMessages("No AppendFileDescriptions were found on the AppenDatasets command.");
        } else {
            for (AppendFileDescription desc : this.sdtl.getAppendFiles()) {
                if (desc.getFileName() != null) continue;
                result.setValid(false);
                result.addMessages("One or more of the AppendFileDescriptions on the AppendDatasets command is missing the fileName.");
            }
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public String[] getFileNames() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (AppendFileDescription description : this.sdtl.getAppendFiles()) {
            fileNames.add(description.getFileName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public VariableNamePair[] getUpdatedVariables() {
        ArrayList<VariableNamePair> pairs = new ArrayList<VariableNamePair>();
        for (AppendFileDescription file : this.sdtl.getAppendFiles()) {
            if (file.getRenameVariables() == null) continue;
            for (RenamePair rp : file.getRenameVariables()) {
                VariableSymbolExpression newVar = rp.getNewVariable();
                VariableSymbolExpression oldVar = rp.getOldVariable();
                VariableNamePair pair = new VariableNamePair(oldVar.getVariableName(), newVar.getVariableName());
                pairs.add(pair);
            }
        }
        VariableNamePair[] pairArray = new VariableNamePair[pairs.size()];
        return pairs.toArray(pairArray);
    }

    @Override
    public Set<String> getDeletedVars() {
        HashSet<String> deleted = new HashSet<String>();
        for (AppendFileDescription file : this.sdtl.getAppendFiles()) {
            deleted.addAll(this.getVariablesFromVariableReferenceBaseArray(file.getDropVariables().toArray(new VariableReferenceBase[file.getDropVariables().size()])));
        }
        return deleted;
    }

    @Override
    public List<Range> getDeletedVariableRanges() {
        ArrayList<Range> deleted = new ArrayList<Range>();
        for (AppendFileDescription file : this.sdtl.getAppendFiles()) {
            deleted.addAll(this.getRangesFromVariableReferenceBaseArray(file.getDropVariables().toArray(new VariableReferenceBase[file.getDropVariables().size()])));
        }
        return deleted;
    }

    @Override
    public String getAppendFlagVariable() {
        return this.sdtl.getAppendFlagVariable();
    }

    @Override
    public Set<String> getKeepVars() {
        HashSet<String> kept = new HashSet<String>();
        for (AppendFileDescription file : this.sdtl.getAppendFiles()) {
            kept.addAll(this.getVariablesFromVariableReferenceBaseArray(file.getKeepVariables().toArray(new VariableReferenceBase[file.getKeepVariables().size()])));
        }
        return kept;
    }

    @Override
    public List<Range> getKeepVariableRanges() {
        ArrayList<Range> kept = new ArrayList<Range>();
        for (AppendFileDescription file : this.sdtl.getAppendFiles()) {
            kept.addAll(this.getRangesFromVariableReferenceBaseArray(file.getKeepVariables().toArray(new VariableReferenceBase[file.getKeepVariables().size()])));
        }
        return kept;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> allRanges = new ArrayList<Range>();
        allRanges.addAll(this.getKeepVariableRanges());
        allRanges.addAll(this.getDeletedVariableRanges());
        return allRanges;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> allVariables = new HashSet<String>();
        allVariables.addAll(this.getKeepVars());
        allVariables.addAll(this.getDeletedVars());
        for (VariableNamePair pair : this.getUpdatedVariables()) {
            allVariables.add(pair.getSource());
        }
        return allVariables;
    }

    @Override
    public DataType getDataType() {
        return null;
    }
}

