/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.c2metadata.sdtl.pojo.command.Recode;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.data.transform.command.SdtlWrapper;
import us.mtna.data.transform.wrapper.sdtl.UnknownCommand;

public class WrapperFactory {
    private static final String wrapperPackage = "us.mtna.data.transform.wrapper.sdtl.";
    private static Logger log = LoggerFactory.getLogger(WrapperFactory.class);

    public static void main(String[] args) {
        Recode cogsRecode = new Recode();
        SdtlWrapper wrapper = WrapperFactory.wrap((TransformBase)cogsRecode);
        System.out.println(wrapper.getClass());
    }

    public static SdtlWrapper wrap(TransformBase command) {
        Class<?> commandClass = command.getClass();
        String wrapperClassName = wrapperPackage + commandClass.getSimpleName();
        try {
            Class<?> wrapperClass = Class.forName(wrapperClassName);
            Constructor<?> constructor = wrapperClass.getConstructor(commandClass);
            log.trace("creating new instance of constructor [" + constructor.getName() + "] with command[" + commandClass + "]");
            return (SdtlWrapper)constructor.newInstance(command);
        }
        catch (ClassNotFoundException e) {
            log.debug("Class was not found when trying to create constructor for command [" + command.getCommand() + "]. Creating an UnknownCommand instead.");
            return new UnknownCommand(command);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("constructor not found for [" + commandClass + "]", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("error invoking constructor for [" + commandClass + "]", e);
        }
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        WrapperFactory.log = log;
    }
}

