/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.NumericConstantExpression;
import org.c2metadata.sdtl.pojo.expression.VariableRangeExpression;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class Compute
implements SelectsVariables,
CreatesVariables {
    private final org.c2metadata.sdtl.pojo.command.Compute sdtl;

    public Compute(org.c2metadata.sdtl.pojo.command.Compute sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getExpression() == null) {
            result.addMessages("No expression to evaluate on command [" + this.sdtl.getCommand() + "]");
            result.setValid(false);
        }
        if (this.sdtl.getVariable() == null) {
            result.addMessages("No variable to compute found on command [" + this.sdtl.getCommand() + "]");
            result.setValid(false);
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        return this.getRangesFromVariableReferenceBase(this.sdtl.getVariable());
    }

    @Override
    public Set<String> getVariables() {
        return this.getVariablesFromVariableReferenceBase(this.sdtl.getVariable());
    }

    @Override
    public NewVariable[] getNewVariables() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        if (this.sdtl.getVariable() != null) {
            NewVariable newVar = new NewVariable();
            if (VariableSymbolExpression.class.isAssignableFrom(this.sdtl.getVariable().getClass())) {
                VariableSymbolExpression symbol = (VariableSymbolExpression)this.sdtl.getVariable();
                if (symbol.getVariableName() != null) {
                    newVar.setNewVariableName(symbol.getVariableName());
                }
                if (!NumericConstantExpression.class.isAssignableFrom(this.sdtl.getExpression().getClass())) {
                    Set<String> vars = this.parseExpression(this.sdtl.getExpression());
                    for (String v : vars) {
                        newVar.addSourceVariables(v);
                        newVar.setBasisVariableName(v);
                    }
                }
                newVars.add(newVar);
            } else if (VariableRangeExpression.class.isAssignableFrom(this.sdtl.getVariable().getClass())) {
                VariableRangeExpression rangeExpr = (VariableRangeExpression)this.sdtl.getVariable();
                Range range = new Range();
                if (rangeExpr.getFirst() != null) {
                    range.setStart(rangeExpr.getFirst());
                } else if (rangeExpr.getLast() != null) {
                    range.setEnd(rangeExpr.getLast());
                }
                newVar.setSourceVariableRange(range);
                newVars.add(newVar);
            }
        }
        return newVars.toArray(new NewVariable[newVars.size()]);
    }
}

