/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.pojo;

import java.util.Comparator;
import us.mtna.pojo.Attribute;
import us.mtna.pojo.ResourceImpl;

public class Code
extends ResourceImpl {
    private String value;
    private String label;
    private boolean missing = false;
    public static final Comparator<Code> NumericCodeValueComparator = new Comparator<Code>(){

        @Override
        public int compare(Code c1, Code c2) {
            try {
                Double value1 = Double.valueOf(c1.getCodeValue());
                Double value2 = Double.valueOf(c2.getCodeValue());
                return value1.compareTo(value2);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static final Comparator<Code> AlphabeticalCodeValueComparator = new Comparator<Code>(){

        @Override
        public int compare(Code c1, Code c2) {
            String value1 = c1.getCodeValue();
            String value2 = c2.getCodeValue();
            return value1.compareTo(value2);
        }
    };

    public Attribute<String> getCodeValueAttribute() {
        Attribute<String> codeValue = new Attribute<String>(String.class);
        codeValue.setName("codeValue");
        if (this.value != null) {
            codeValue.setValue(this.value);
        }
        return codeValue;
    }

    public Attribute<String> getCodeLabelAttribute() {
        Attribute<String> codeLabel = new Attribute<String>(String.class);
        codeLabel.setName("codeLabel");
        if (this.label != null) {
            codeLabel.setValue(this.label);
        }
        return codeLabel;
    }

    public String getCodeValue() {
        return this.value;
    }

    public void setCodeValue(String codeValue) {
        this.value = codeValue;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }
}

