/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.List;
import org.c2metadata.sdtl.pojo.MergeFileDescription;
import org.c2metadata.sdtl.pojo.RenamePair;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.VariableReferenceBase;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.ds.MergesDatasets;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.UpdaterMergeFileDescription;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class MergeDatasets
implements MergesDatasets,
CreatesVariables {
    private org.c2metadata.sdtl.pojo.command.MergeDatasets sdtl;

    public MergeDatasets(org.c2metadata.sdtl.pojo.command.MergeDatasets sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getMergeFiles() == null || this.sdtl.getMergeFiles().length < 2) {
            result.setValid(false);
            result.addMessages("MergeDatasets command must have at least two MergeFileDescriptions. Command: [" + this.sdtl.getCommand() + "]");
        } else {
            int i = 0;
            MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
            int n = mergeFileDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                MergeFileDescription desc = mergeFileDescriptionArray[n2];
                if (desc.getFileName() == null) {
                    result.setValid(false);
                    result.addMessages("No file name found on the merge file description at index [" + i + "] in command [" + this.sdtl.getCommand() + "]");
                }
                ++i;
                ++n2;
            }
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public VariableReferenceBase getMergeByVariables() {
        return this.sdtl.getMergeByVariables();
    }

    @Override
    public VariableReferenceBase[] getKeepVariables() {
        VariableReferenceBase[] bases = new VariableReferenceBase[]{this.sdtl.getKeepVariables()};
        return bases;
    }

    @Override
    public VariableReferenceBase[] getDropVariables() {
        VariableReferenceBase[] bases = new VariableReferenceBase[]{this.sdtl.getDropVariables()};
        return bases;
    }

    @Override
    public List<UpdaterMergeFileDescription> getMergeFileDscr() {
        ArrayList<UpdaterMergeFileDescription> list = new ArrayList<UpdaterMergeFileDescription>();
        MergeFileDescription[] mergeFileDescriptionArray = this.sdtl.getMergeFiles();
        int n = mergeFileDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MergeFileDescription dscr = mergeFileDescriptionArray[n2];
            UpdaterMergeFileDescription file = new UpdaterMergeFileDescription();
            file.setDropVariables(dscr.getDropVariables());
            file.setFileName(dscr.getFileName());
            file.setKeepVariables(dscr.getKeepVariables());
            file.setMergeFlagVariable(dscr.getMergeFlagVariable());
            file.setMergeType(dscr.getMergeType());
            file.setNewRow(dscr.isNewRow());
            file.setOverlap(dscr.getOverlap());
            file.setRenameVariables(this.getVarNamePairsFromRenamePairs(dscr.getRenameVariables()));
            list.add(file);
            ++n2;
        }
        return list;
    }

    private List<VariableNamePair> getVarNamePairsFromRenamePairs(RenamePair[] pairs) {
        ArrayList<VariableNamePair> list = new ArrayList<VariableNamePair>();
        if (pairs != null) {
            RenamePair[] renamePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                RenamePair pair = renamePairArray[n2];
                if (pair.getNewVariable() != null && pair.getOldVariable() != null && pair.getNewVariable().getVariableName() != null && pair.getOldVariable().getVariableName() != null) {
                    list.add(new VariableNamePair(pair.getOldVariable().getVariableName(), pair.getNewVariable().getVariableName()));
                }
                ++n2;
            }
        }
        return list;
    }

    @Override
    public String getFirstVariable() {
        return this.sdtl.getFirstVariable();
    }

    @Override
    public String getLastVariable() {
        return this.sdtl.getLastVariable();
    }

    @Override
    public NewVariable[] getNewVariables() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        if (this.sdtl.getFirstVariable() != null) {
            NewVariable first = new NewVariable();
            first.setNewVariableName(this.sdtl.getFirstVariable());
            newVars.add(first);
        }
        if (this.sdtl.getLastVariable() != null) {
            NewVariable last = new NewVariable();
            last.setNewVariableName(this.sdtl.getLastVariable());
            newVars.add(last);
        }
        return newVars.toArray(new NewVariable[0]);
    }
}

