/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Variable;

public class Metadata {
    private Map<String, Classification> classifs;
    private List<Variable> variables = new ArrayList<Variable>();

    public Metadata() {
        this.classifs = new LinkedHashMap<String, Classification>();
    }

    public Map<String, Classification> getClassifs() {
        return this.classifs;
    }

    public void setClassifs(Map<String, Classification> classifs) {
        this.classifs.clear();
        this.classifs.putAll(classifs);
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public void addVariables(Variable ... vars) {
        Variable[] variableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            Variable v = variableArray[n2];
            this.variables.add(v);
            ++n2;
        }
    }

    public Classification lookupClassificationById(String id) {
        return this.classifs.get(id);
    }

    public Map<String, Classification> populateClassificationMap(List<Classification> classificationAttributes) {
        HashMap<String, Classification> classificationAttributeMap = new HashMap<String, Classification>();
        for (Classification classification : classificationAttributes) {
            classificationAttributeMap.put(classification.getId(), classification);
        }
        return classificationAttributeMap;
    }

    public Map<String, Variable> getVarNameMap() {
        TreeMap<String, Variable> variableNameMap = new TreeMap<String, Variable>(String.CASE_INSENSITIVE_ORDER);
        for (Variable v : this.variables) {
            v.getName();
            variableNameMap.put(v.getName(), v);
        }
        return variableNameMap;
    }
}

