/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.c2metadata.sdtl.pojo.RecodeRule;
import org.c2metadata.sdtl.pojo.RecodeVariable;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.ExpressionBase;
import org.c2metadata.sdtl.pojo.expression.MissingValueConstantExpression;
import org.c2metadata.sdtl.pojo.expression.NumberRangeExpression;
import org.c2metadata.sdtl.pojo.expression.NumericConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringRangeExpression;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesClassification;
import us.mtna.data.transform.command.object.ClassificationUpdate;
import us.mtna.data.transform.command.object.CodeDetail;
import us.mtna.data.transform.command.object.CodeRangeDetail;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.wrapper.sdtl.ValidationResult;

public class Recode
implements SelectsVariables,
UpdatesClassification,
CreatesVariables {
    private final org.c2metadata.sdtl.pojo.command.Recode sdtl;
    private boolean requiresCopyOfClassification;
    private boolean copyFloatingCodes;

    public Recode(org.c2metadata.sdtl.pojo.command.Recode sdtl) {
        this.sdtl = sdtl;
        this.requiresCopyOfClassification = true;
        this.copyFloatingCodes = true;
    }

    @Override
    public ValidationResult validate() {
        ValidationResult result = new ValidationResult();
        if (this.sdtl.getRecodedVariables() == null || this.sdtl.getRecodedVariables().length < 1) {
            result.setValid(false);
            result.addMessages("No RecodeRules found when trying to execute command [" + this.sdtl.getCommand().toString() + "]");
        }
        return result;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (this.sdtl.getRecodedVariableRange() != null) {
            Range range = new Range();
            if (this.sdtl.getRecodedVariableRange().getFirst() != null) {
                range.setStart(this.sdtl.getRecodedVariableRange().getFirst());
            }
            if (this.sdtl.getRecodedVariableRange().getLast() != null) {
                range.setEnd(this.sdtl.getRecodedVariableRange().getLast());
            }
            ranges.add(range);
        }
        return ranges;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> vars = new HashSet<String>();
        RecodeVariable[] recodeVariableArray = this.sdtl.getRecodedVariables();
        int n = recodeVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecodeVariable var = recodeVariableArray[n2];
            vars.add(var.getSource());
            ++n2;
        }
        return vars;
    }

    @Override
    public ClassificationUpdate getUpdate() {
        ClassificationUpdate update = new ClassificationUpdate();
        ArrayList newCodes = new ArrayList();
        ArrayList<CodeRangeDetail> newCodeRanges = new ArrayList<CodeRangeDetail>();
        ArrayList<Range> removedCodeRanges = new ArrayList<Range>();
        ArrayList removedCodes = new ArrayList();
        if (this.sdtl.getRules() != null) {
            RecodeRule[] recodeRuleArray = this.sdtl.getRules();
            int n = recodeRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                RecodeRule rule = recodeRuleArray[n2];
                if (rule.getFromValue() != null) {
                    Class<?> toClass = rule.getTo().getClass();
                    ExpressionBase[] expressionBaseArray = rule.getFromValue();
                    int n3 = expressionBaseArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExpressionBase fromExpression = expressionBaseArray[n4];
                        Class<?> fromClass = fromExpression.getClass();
                        if (NumberRangeExpression.class.isAssignableFrom(fromClass) || StringRangeExpression.class.isAssignableFrom(fromClass)) {
                            CodeRangeDetail codeRangeDetail = new CodeRangeDetail();
                            codeRangeDetail.setLabel(rule.getLabel());
                            String fromValue = null;
                            String toValue = null;
                            if (StringRangeExpression.class.isAssignableFrom(fromExpression.getClass())) {
                                StringRangeExpression sre = (StringRangeExpression)fromExpression;
                                fromValue = sre.getRangeStart();
                                toValue = sre.getRangeEnd();
                            } else if (NumberRangeExpression.class.isAssignableFrom(fromExpression.getClass())) {
                                NumberRangeExpression nre = (NumberRangeExpression)fromExpression;
                                ExpressionBase startExpression = nre.getNumberRangeStart();
                                ExpressionBase endExpression = nre.getNumberRangeEnd();
                                fromValue = this.checkConstantExpressions(startExpression);
                                toValue = this.checkConstantExpressions(endExpression);
                            }
                            Range fromRange = new Range();
                            fromRange.setEnd(toValue);
                            fromRange.setStart(fromValue);
                            codeRangeDetail.setFromRange(fromRange);
                            codeRangeDetail.setTargetValue(rule.getTo());
                            removedCodeRanges.add(fromRange);
                            newCodeRanges.add(codeRangeDetail);
                        } else {
                            MissingValueConstantExpression.class.isAssignableFrom(fromClass);
                        }
                        if (!(rule.getTo() == null || StringConstantExpression.class.isAssignableFrom(toClass) || NumericConstantExpression.class.isAssignableFrom(toClass) || MissingValueConstantExpression.class.isAssignableFrom(toClass))) {
                            ValidationResult v = new ValidationResult();
                            v.setValid(false);
                            v.addMessages("RecodeRule \"toValue\" [" + rule.getTo() + "]is not of the expected type");
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        update.setNewCodes(newCodes.toArray(new CodeDetail[newCodes.size()]));
        update.setNewCodeRanges(newCodeRanges.toArray(new CodeRangeDetail[newCodeRanges.size()]));
        update.setRemovedCodeRanges(removedCodeRanges.toArray(new Range[removedCodeRanges.size()]));
        update.setRemovedCodes(removedCodes.toArray(new String[removedCodes.size()]));
        return update;
    }

    @Override
    public NewVariable[] getNewVariables() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        RecodeVariable[] recodeVariableArray = this.sdtl.getRecodedVariables();
        int n = recodeVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecodeVariable rv = recodeVariableArray[n2];
            NewVariable newVar = new NewVariable();
            if (rv.getSource().equals(rv.getTarget())) break;
            String baseVarName = rv.getSource();
            newVar.setNewVariableName(rv.getTarget());
            newVar.setBasisVariableName(baseVarName);
            newVars.add(newVar);
            ++n2;
        }
        return newVars.toArray(new NewVariable[newVars.size()]);
    }

    @Override
    public boolean requiresCopyOfClassification() {
        return this.requiresCopyOfClassification;
    }

    public void setRequiresCopyOfClassification(boolean requiresCopyOfClassification) {
        this.requiresCopyOfClassification = requiresCopyOfClassification;
    }

    @Override
    public boolean copyFloatingCodes() {
        return this.copyFloatingCodes;
    }

    public void setCopyFloatingCodes(boolean copyFloatingCodes) {
        this.copyFloatingCodes = copyFloatingCodes;
    }
}

