/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.reporting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import us.mtna.config.ComparisonConfig;
import us.mtna.config.VariablePair;
import us.mtna.pojo.Attribute;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.Metadata;
import us.mtna.pojo.SummaryStatistics;
import us.mtna.pojo.Variable;
import us.mtna.reporting.ComparisonResult;
import us.mtna.reporting.Report;
import us.mtna.reporting.ResultType;
import us.mtna.reporting.SummaryResult;

public class DataSetComparisonManager {
    private ComparisonConfig configuration;

    public Report compareDataSets(DataSet ds1, DataSet ds2, ComparisonConfig configuration) {
        Metadata metadata1 = ds1.getMetadata();
        Metadata metadata2 = ds2.getMetadata();
        Report report = new Report();
        int ds1RecordCount = ds1.getRecordCount();
        int ds2RecordCount = ds2.getRecordCount();
        report.setConfiguration(configuration);
        report.setDs1(ds1);
        report.setDs2(ds2);
        report.setSourceDsRecordCount(ds1RecordCount);
        report.setTargetDsRecordCount(ds2RecordCount);
        if (configuration == null) {
            configuration = new ComparisonConfig();
        }
        if (!configuration.getVariableComparison().getVariablePairs().isEmpty()) {
            this.compareVariablePairs(metadata1, metadata2, report, configuration);
        } else {
            this.compareVariablesWithAutomatching(metadata1, metadata2, report, configuration);
        }
        return report;
    }

    private List<ComparisonResult> getClassifComparisonResults(Metadata metadata1, Metadata metadata2, Variable v1, Variable v2) {
        Classification c2;
        ArrayList<ComparisonResult> classificationComparisonResultList = new ArrayList<ComparisonResult>();
        Classification c1 = metadata1.lookupClassificationById(v1.getClassificationId());
        if (c1 != null & (c2 = metadata2.lookupClassificationById(v2.getClassificationId())) != null) {
            ComparisonResult classificationComparisonResult = this.compareCodes(c1, c2);
            classificationComparisonResultList.add(classificationComparisonResult);
        }
        return classificationComparisonResultList;
    }

    public void compareVariablePairs(Metadata metadata1, Metadata metadata2, Report report, ComparisonConfig configuration) {
        ArrayList<ComparisonResult> comparisonResultList = new ArrayList<ComparisonResult>();
        Map<String, Variable> variableNameMap1 = metadata1.getVarNameMap();
        Map<String, Variable> variableNameMap2 = metadata2.getVarNameMap();
        Map<String, List<Variable>> sourceVariableClassificationMap = new HashMap<String, List<Variable>>();
        Map<String, List<Variable>> targetVariableClassificationMap = new HashMap<String, List<Variable>>();
        List<VariablePair> variablePairs = configuration.getVariableComparison().getVariablePairs();
        for (VariablePair pair : variablePairs) {
            Variable v1 = variableNameMap1.get(pair.getSource());
            Variable v2 = variableNameMap2.get(pair.getTarget());
            ComparisonResult comparisonResult = this.compareVariableAttributes(v1, v2, configuration);
            comparisonResultList.add(comparisonResult);
            if (!configuration.getClassificationComparison().isCompared()) continue;
            List<ComparisonResult> classificationComparisonResultList = this.getClassifComparisonResults(metadata1, metadata2, v1, v2);
            sourceVariableClassificationMap = this.populateVarClassifMap(v1, sourceVariableClassificationMap);
            targetVariableClassificationMap = this.populateVarClassifMap(v2, targetVariableClassificationMap);
            report.setTargetVarToClassifMap(targetVariableClassificationMap);
            report.setSrcVarToClassifMap(sourceVariableClassificationMap);
            report.addClassComparisonResultListToReport(classificationComparisonResultList);
        }
        report.addVarComparisonResultListToReport(comparisonResultList);
    }

    public void compareVariablesWithAutomatching(Metadata metadata1, Metadata metadata2, Report report, ComparisonConfig configuration) {
        ComparisonResult comparisonResult;
        List<Variable> ds1Variables = metadata1.getVariables();
        List<Variable> ds2Variables = metadata2.getVariables();
        ArrayList<String> uniqueSourceVariables = new ArrayList<String>();
        ArrayList<Variable> uniqueTargetVariables = new ArrayList<Variable>();
        ArrayList<Variable> targetVarsToRemove = new ArrayList<Variable>();
        ArrayList<ComparisonResult> comparisonResultList = new ArrayList<ComparisonResult>();
        ArrayList<ComparisonResult> classificationComparisonResultList = new ArrayList<ComparisonResult>();
        Map<String, List<Variable>> sourceVariableClassificationMap = new HashMap<String, List<Variable>>();
        Map<String, List<Variable>> targetVariableClassificationMap = new HashMap<String, List<Variable>>();
        HashMap<String, Variable> ds2Vars = new HashMap<String, Variable>();
        HashMap<String, Variable> ds2VarsLower = new HashMap<String, Variable>();
        HashMap<String, String> ds2LowerCase = new HashMap<String, String>();
        HashMap<String, String> ds2Spacing = new HashMap<String, String>();
        HashMap<String, String> ds2SpecialChars = new HashMap<String, String>();
        HashMap<String, String> ds2CaseSpace = new HashMap<String, String>();
        HashMap<String, String> ds2CaseSpaceChars = new HashMap<String, String>();
        for (Variable v2 : ds2Variables) {
            ds2VarsLower.put(v2.getName().toLowerCase(), v2);
            ds2Vars.put(v2.getName(), v2);
            targetVariableClassificationMap = this.populateVarClassifMap(v2, targetVariableClassificationMap);
            ds2LowerCase.put(v2.getName().toLowerCase(), v2.getName());
            ds2Spacing.put(v2.getName().replaceAll("\\s+", ""), v2.getName());
            ds2SpecialChars.put(v2.getName().replaceAll("[^A-Za-z0-9]", ""), v2.getName());
            ds2CaseSpace.put(v2.getName().toLowerCase().replaceAll("\\s+", ""), v2.getName());
            ds2CaseSpaceChars.put(v2.getName().toLowerCase().replaceAll("/[^A-Za-z0-9]+/", ""), v2.getName());
        }
        for (Variable v1 : ds1Variables) {
            Attribute<String> v2Name;
            Variable v;
            String name;
            ResultType type;
            sourceVariableClassificationMap = this.populateVarClassifMap(v1, sourceVariableClassificationMap);
            Attribute<String> v1Name = v1.getNameAttr();
            if (ds2LowerCase.values().contains(v1.getName())) {
                Variable v2 = (Variable)ds2VarsLower.get(v1.getName().toLowerCase());
                Classification c1 = metadata1.lookupClassificationById(v1.getClassificationId());
                Classification c2 = metadata2.lookupClassificationById(v2.getClassificationId());
                if (configuration.getClassificationComparison().isCompared() && c1 != null & c2 != null) {
                    ComparisonResult classificationComparisonResult = this.compareCodes(c1, c2);
                    classificationComparisonResultList.add(classificationComparisonResult);
                }
                comparisonResult = this.compareVariableAttributes(v1, v2, configuration);
                comparisonResultList.add(comparisonResult);
                String name2 = (String)ds2LowerCase.get(v1.getName().toLowerCase());
                Variable v3 = (Variable)ds2Vars.get(name2);
                targetVarsToRemove.add(v3);
                continue;
            }
            if (ds2Spacing.containsKey(v1.getName().replaceAll("\\s+", ""))) {
                type = !configuration.getVariableComparison().getLabelComparison().isSpaceMismatch() ? ResultType.MISMATCH : ResultType.SPACE_MISMATCH;
                name = (String)ds2Spacing.get(v1.getName().replaceAll("\\s+", ""));
                v = (Variable)ds2Vars.get(name);
                v2Name = v.getNameAttr();
                targetVarsToRemove.add(v);
                comparisonResult = new ComparisonResult(v1Name, v2Name, type);
                comparisonResultList.add(comparisonResult);
                continue;
            }
            if (ds2LowerCase.containsKey(v1.getName().toLowerCase())) {
                type = !configuration.getVariableComparison().getLabelComparison().isCaseMismatch() ? ResultType.MISMATCH : ResultType.CASE_MISMATCH;
                name = (String)ds2LowerCase.get(v1.getName().toLowerCase());
                v = (Variable)ds2Vars.get(name);
                v2Name = v.getNameAttr();
                targetVarsToRemove.add(v);
                comparisonResult = new ComparisonResult(v1Name, v2Name, type);
                comparisonResultList.add(comparisonResult);
                continue;
            }
            if (ds2SpecialChars.containsKey(v1.getName().replaceAll("[^A-Za-z0-9]", ""))) {
                type = !configuration.getVariableComparison().getLabelComparison().isSpecialCharMismatch() ? ResultType.MISMATCH : ResultType.SPECIAL_CHAR_MISMATCH;
                name = (String)ds2SpecialChars.get(v1.getName().replaceAll("[^A-Za-z0-9]", ""));
                v = (Variable)ds2Vars.get(name);
                v2Name = v.getNameAttr();
                targetVarsToRemove.add(v);
                comparisonResult = new ComparisonResult(v1Name, v2Name, type);
                comparisonResultList.add(comparisonResult);
                continue;
            }
            if (ds2CaseSpaceChars.containsKey(v1.getName().toLowerCase().replaceAll("/[^A-Za-z0-9]+/", ""))) {
                type = !configuration.getVariableComparison().getLabelComparison().isCloseMatch() ? ResultType.MISMATCH : ResultType.CLOSE_MATCH;
                name = (String)ds2CaseSpace.get(v1.getName().toLowerCase().replaceAll("\\s+", ""));
                v = (Variable)ds2Vars.get(name);
                v2Name = v.getNameAttr();
                targetVarsToRemove.add(v);
                comparisonResult = new ComparisonResult(v1Name, v2Name, type);
                comparisonResultList.add(comparisonResult);
                continue;
            }
            uniqueSourceVariables.add(v1.getName().toLowerCase());
            type = ResultType.NO_TARGET;
            v2Name = null;
            comparisonResult = new ComparisonResult(v1Name, v2Name, type);
            comparisonResultList.add(comparisonResult);
        }
        uniqueTargetVariables.addAll(ds2Variables);
        uniqueTargetVariables.removeAll(targetVarsToRemove);
        for (Variable v : uniqueTargetVariables) {
            comparisonResult = new ComparisonResult(null, v.getNameAttr(), ResultType.NO_SOURCE);
            comparisonResultList.add(comparisonResult);
        }
        SummaryResult summaryResult = new SummaryResult(uniqueSourceVariables.size(), uniqueTargetVariables.size(), ds1Variables.size(), ds2Variables.size());
        report.setSrcVarToClassifMap(sourceVariableClassificationMap);
        report.setTargetVarToClassifMap(targetVariableClassificationMap);
        report.setSummaryResult(summaryResult);
        report.addClassComparisonResultListToReport(classificationComparisonResultList);
        report.addVarComparisonResultListToReport(comparisonResultList);
    }

    private Map<String, List<Variable>> populateVarClassifMap(Variable v, Map<String, List<Variable>> variableClassificationMap) {
        List variableList = variableClassificationMap.getOrDefault(v.getClassificationId(), new ArrayList());
        variableList.add(v);
        variableClassificationMap.put(v.getClassificationId(), variableList);
        return variableClassificationMap;
    }

    public ComparisonResult compareVariableAttributes(Variable v1, Variable v2, ComparisonConfig configuration) {
        List<Attribute<?>> v1Attributes = v1.getAttributes();
        List<Attribute<?>> v2Attributes = v2.getAttributes();
        ArrayList<ComparisonResult> childList = new ArrayList<ComparisonResult>();
        List<Object> attributeComparisonResults = new ArrayList();
        Map<String, Attribute<?>> v1AttributeMap = this.populateAttMap(v1Attributes);
        Map<String, Attribute<?>> v2AttributeMap = this.populateAttMap(v2Attributes);
        ResultType resultType = ResultType.MATCH;
        for (Map.Entry<String, Attribute<?>> entry : v1AttributeMap.entrySet()) {
            if (v2AttributeMap.containsKey(entry.getKey())) {
                Attribute<?> sourceAttribute = entry.getValue();
                Attribute<?> targetAttribute = v2AttributeMap.get(entry.getKey());
                attributeComparisonResults = this.compareAttributes(sourceAttribute, targetAttribute, configuration);
                for (ComparisonResult comparisonResult : attributeComparisonResults) {
                    if (comparisonResult.getType() == ResultType.MATCH) continue;
                    resultType = ResultType.MISMATCH;
                }
            }
            childList.addAll(attributeComparisonResults);
        }
        ComparisonResult comparisonResult = new ComparisonResult(v1.getNameAttr(), v2.getNameAttr(), resultType);
        comparisonResult.addChildResultsToList(childList);
        return comparisonResult;
    }

    public ComparisonResult compareCodes(Classification c1, Classification c2) {
        Map<String, Attribute<Code>> c1Map = this.populateMapWithCodesAndLabels(c1);
        Map<String, Attribute<Code>> c2Map = this.populateMapWithCodesAndLabels(c2);
        ArrayList<ComparisonResult> childList = new ArrayList<ComparisonResult>();
        childList.add(this.compareClassificationSize(c1, c2));
        childList.addAll(this.compareCodeMaps(c1Map, c2Map));
        ResultType resultType = ResultType.MATCH;
        for (ComparisonResult child : childList) {
            if (child.getType() == ResultType.MATCH) continue;
            resultType = ResultType.MISMATCH;
            break;
        }
        ComparisonResult cr = new ComparisonResult(c1.getIdAttribute(), c2.getIdAttribute(), resultType);
        cr.addChildResultsToList(childList);
        return cr;
    }

    private List<ComparisonResult> compareCodeMaps(Map<String, Attribute<Code>> c1Map, Map<String, Attribute<Code>> c2Map) {
        ArrayList<ComparisonResult> crList = new ArrayList<ComparisonResult>();
        ArrayList<String> removals = new ArrayList<String>();
        for (Map.Entry<String, Attribute<Code>> entry : c1Map.entrySet()) {
            Attribute<Code> sourceCode = entry.getValue();
            if (!c2Map.containsKey(entry.getKey())) continue;
            Attribute<Code> targetCode = c2Map.get(entry.getKey());
            ResultType resultType = this.compareCodes(sourceCode.getValue(), targetCode.getValue());
            crList.add(new ComparisonResult(sourceCode, targetCode, resultType));
            removals.add(entry.getKey());
        }
        for (String string : removals) {
            c1Map.remove(string);
            c2Map.remove(string);
        }
        for (Attribute attribute : c1Map.values()) {
            crList.add(new ComparisonResult(attribute, null, ResultType.NO_TARGET));
        }
        for (Attribute attribute : c2Map.values()) {
            crList.add(new ComparisonResult(null, attribute, ResultType.NO_SOURCE));
        }
        return crList;
    }

    private ResultType compareCodes(Code code1, Code code2) {
        if (this.compareCodeLabels(code1, code2)) {
            return ResultType.MATCH;
        }
        if (this.compareCodeLabelsIgnoreCase(code1, code2)) {
            return ResultType.CASE_MISMATCH;
        }
        if (this.compareCodeLabelsIgnoreSpace(code1, code2)) {
            return ResultType.SPACE_MISMATCH;
        }
        if (this.compareCodeLabelsIgnoreSpecialCharacters(code1, code2)) {
            return ResultType.SPECIAL_CHAR_MISMATCH;
        }
        if (this.compareCodeLabelsIgnoreCaseSpaceChars(code1, code2)) {
            return ResultType.CLOSE_MATCH;
        }
        return ResultType.MISMATCH;
    }

    private boolean compareCodeLabels(Code code1, Code code2) {
        return code1.getLabel().equals(code2.getLabel());
    }

    private boolean compareCodeLabelsIgnoreCase(Code code1, Code code2) {
        return code1.getLabel().equalsIgnoreCase(code2.getLabel());
    }

    private boolean compareCodeLabelsIgnoreSpace(Code code1, Code code2) {
        String label1 = code1.getLabel().replaceAll("\\s+", "");
        String label2 = code2.getLabel().replaceAll("\\s+", "");
        return label1.equals(label2);
    }

    private boolean compareCodeLabelsIgnoreSpecialCharacters(Code code1, Code code2) {
        String label1 = code1.getLabel().replaceAll("[^A-Za-z0-9]", "");
        String label2 = code2.getLabel().replaceAll("[^A-Za-z0-9]", "");
        return label1.equals(label2);
    }

    private boolean compareCodeLabelsIgnoreCaseAndSpace(Code code1, Code code2) {
        String label1 = code1.getLabel().replaceAll("\\s+", "");
        String label2 = code2.getLabel().replaceAll("\\s+", "");
        return label1.equalsIgnoreCase(label2);
    }

    private boolean compareCodeLabelsIgnoreCaseSpaceChars(Code code1, Code code2) {
        String label1 = code1.getLabel().replaceAll("/[^A-Za-z0-9]+/", "");
        String label2 = code2.getLabel().replaceAll("/[^A-Za-z0-9]+/", "");
        return label1.equals(label2);
    }

    private Map<String, Attribute<Code>> populateMapWithCodesAndLabels(Classification c) {
        HashMap<String, Attribute<Code>> codeLabelMap = new HashMap<String, Attribute<Code>>();
        if (c.getCodes() != null) {
            for (Attribute<Code> code : c.getCodes()) {
                codeLabelMap.put(code.getValue().getCodeValue(), code);
            }
        }
        return codeLabelMap;
    }

    private ComparisonResult compareClassificationSize(Classification c1, Classification c2) {
        int c1Size = c1.getCodeCount().getValue();
        int c2Size = c2.getCodeCount().getValue();
        ResultType resultType = ResultType.MATCH;
        if (c1Size != c2Size) {
            resultType = c1Size < c2Size ? ResultType.GREATER_THAN : ResultType.LESS_THAN;
        }
        return new ComparisonResult(c1.getCodeCount(), c2.getCodeCount(), resultType);
    }

    private List<ComparisonResult> compareAttributes(Attribute<?> attribute1, Attribute<?> attribute2, ComparisonConfig configuration) {
        ComparisonResult childResult;
        ArrayList<ComparisonResult> comparisonResultList = new ArrayList<ComparisonResult>();
        String reportString = "";
        if (!attribute1.getClazz().equals(attribute2.getClazz())) {
            reportString = String.valueOf(reportString) + "The class for the Attribute in DataSet1 is " + attribute1.getClazz() + " & " + "The class for the Attribute in Data Set 2 is " + attribute2.getClazz() + ". " + System.lineSeparator();
            childResult = new ComparisonResult(attribute1, attribute2, ResultType.MISMATCH);
            comparisonResultList.add(childResult);
        }
        if (!attribute1.getName().equals(attribute2.getName())) {
            reportString = String.valueOf(reportString) + "The name for the Attribute in DataSet1 is " + attribute1.getName() + " & " + "The name for the Attribute in Data Set 2 is " + attribute2.getName() + ". " + System.lineSeparator();
            childResult = new ComparisonResult(attribute1, attribute2, ResultType.MISMATCH);
            comparisonResultList.add(childResult);
        }
        if (!attribute1.getName().equals("summaryStats")) {
            if (!attribute1.getValue().equals(attribute2.getValue())) {
                reportString = String.valueOf(reportString) + "The value for the Attribute in DataSet 1 is " + attribute1.getValue().toString() + " & " + "The value for the Attribute in DataSet 2 is " + attribute2.getValue().toString() + ". " + System.lineSeparator();
                childResult = new ComparisonResult(attribute1, attribute2, ResultType.MISMATCH);
                comparisonResultList.add(childResult);
            }
        } else if (configuration.getVariableComparison().getSumStatsComparison().isCompared()) {
            List<ComparisonResult> statisticalMeasuresComparisons = new ArrayList<ComparisonResult>();
            statisticalMeasuresComparisons = this.compareSummaryStatisticsMeasures(attribute1, attribute2, statisticalMeasuresComparisons, configuration);
            ResultType rt = ResultType.MATCH;
            for (ComparisonResult cr : statisticalMeasuresComparisons) {
                if (cr.getType() == ResultType.MATCH) continue;
                rt = ResultType.MISMATCH;
            }
            childResult = new ComparisonResult(attribute1, attribute2, rt);
            childResult.addChildResultsToList(statisticalMeasuresComparisons);
            comparisonResultList.add(childResult);
        }
        return comparisonResultList;
    }

    private void compareWeightedVarRefs(Attribute<?> weightedVariableNamesAttribute1, Attribute<?> weightedVariableNamesAttribute2, List<ComparisonResult> statisticalMeasuresComparisons) {
        ResultType resultType = ResultType.MISMATCH;
        HashSet wv1 = (HashSet)weightedVariableNamesAttribute1.getValue();
        HashSet wv2 = (HashSet)weightedVariableNamesAttribute2.getValue();
        if (!wv1.isEmpty() || !wv2.isEmpty()) {
            if (!wv1.isEmpty() && !wv2.isEmpty()) {
                for (String att : wv1) {
                    if (!wv2.contains(att)) continue;
                    resultType = ResultType.MATCH;
                }
            } else {
                resultType = wv1.isEmpty() && !wv2.isEmpty() ? ResultType.NO_SOURCE : (wv2.isEmpty() && !wv1.isEmpty() ? ResultType.NO_TARGET : ResultType.MISMATCH);
            }
            statisticalMeasuresComparisons.add(new ComparisonResult(weightedVariableNamesAttribute1, weightedVariableNamesAttribute2, resultType));
        }
    }

    public void compareStatisticalMeasures(Double measure1, Double measure2, Attribute<?> m1Att, Attribute<?> m2Att, List<ComparisonResult> statisticalMeasuresComparisons) {
        ComparisonResult childResult = new ComparisonResult(null, null, null);
        if (measure1 != null && measure2 != null) {
            if (Double.compare(measure1, measure2) == 0) {
                childResult = new ComparisonResult(m1Att, m2Att, ResultType.MATCH);
            } else if (Double.compare(measure1, measure2) < 0) {
                childResult = new ComparisonResult(m1Att, m2Att, ResultType.GREATER_THAN);
            } else if (Double.compare(measure1, measure2) > 0) {
                childResult = new ComparisonResult(m1Att, m2Att, ResultType.LESS_THAN);
            }
            statisticalMeasuresComparisons.add(childResult);
        }
    }

    private List<ComparisonResult> compareSummaryStatisticsMeasures(Attribute<?> attribute1, Attribute<?> attribute2, List<ComparisonResult> statisticalMeasuresComparisons, ComparisonConfig configure) {
        SummaryStatistics sumStats1 = (SummaryStatistics)attribute1.getValue();
        SummaryStatistics sumStats2 = (SummaryStatistics)attribute2.getValue();
        if (configure.getVariableComparison().getSumStatsComparison().isUnweighted()) {
            if (configure.getVariableComparison().getSumStatsComparison().isMax()) {
                this.compareStatisticalMeasures(sumStats1.getMax(), sumStats2.getMax(), sumStats1.getMaxAttribute(), sumStats2.getMaxAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isMin()) {
                this.compareStatisticalMeasures(sumStats1.getMin(), sumStats2.getMin(), sumStats1.getMinAttribute(), sumStats2.getMinAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isMean()) {
                this.compareStatisticalMeasures(sumStats1.getMean(), sumStats2.getMean(), sumStats1.getMeanAttribute(), sumStats2.getMeanAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isMode()) {
                this.compareStatisticalMeasures(sumStats1.getMode(), sumStats2.getMode(), sumStats1.getModeAttribute(), sumStats2.getModeAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isInvalid()) {
                this.compareStatisticalMeasures(sumStats1.getInvalid(), sumStats2.getInvalid(), sumStats1.getInvalidAttribute(), sumStats2.getInvalidAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isValid()) {
                this.compareStatisticalMeasures(sumStats1.getValid(), sumStats2.getValid(), sumStats1.getValidAttribute(), sumStats2.getValidAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isStdDev()) {
                this.compareStatisticalMeasures(sumStats1.getStdDev(), sumStats2.getStdDev(), sumStats1.getStdDevAttribute(), sumStats2.getStdDevAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isOther()) {
                this.compareStatisticalMeasures(sumStats1.getOther(), sumStats2.getOther(), sumStats1.getOtherAttribute(), sumStats2.getOtherAttribute(), statisticalMeasuresComparisons);
            }
        }
        if (configure.getVariableComparison().getSumStatsComparison().isWeighted()) {
            this.compareWeightedVarRefs(sumStats1.getWeightedVariableNamesAttribute(), sumStats2.getWeightedVariableNamesAttribute(), statisticalMeasuresComparisons);
            if (configure.getVariableComparison().getSumStatsComparison().isMax()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedMax(), sumStats2.getWeightedMax(), sumStats1.getWeightedMaxAttribute(), sumStats2.getWeightedMaxAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isMin()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedMin(), sumStats2.getWeightedMin(), sumStats1.getWeightedMinAttribute(), sumStats2.getWeightedMinAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isMean()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedMean(), sumStats2.getWeightedMean(), sumStats1.getWeightedMeanAttribute(), sumStats2.getWeightedMeanAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isMode()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedMode(), sumStats2.getWeightedMode(), sumStats1.getWeightedModeAttribute(), sumStats2.getWeightedModeAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isInvalid()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedInvalid(), sumStats2.getWeightedInvalid(), sumStats1.getWeightedInvalidAttribute(), sumStats2.getWeightedInvalidAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isValid()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedValid(), sumStats2.getWeightedValid(), sumStats1.getWeightedValidAttribute(), sumStats2.getWeightedValidAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isStdDev()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedStdDev(), sumStats2.getWeightedStdDev(), sumStats1.getWeightedStdDevAttribute(), sumStats2.getWeightedStdDevAttribute(), statisticalMeasuresComparisons);
            }
            if (configure.getVariableComparison().getSumStatsComparison().isOther()) {
                this.compareStatisticalMeasures(sumStats1.getWeightedOther(), sumStats2.getWeightedOther(), sumStats1.getWeightedOtherAttribute(), sumStats2.getWeightedOtherAttribute(), statisticalMeasuresComparisons);
            }
        }
        return statisticalMeasuresComparisons;
    }

    private Map<String, Attribute<?>> populateAttMap(List<Attribute<?>> variableAttributes) {
        HashMap variableAtttributeMap = new HashMap();
        for (Attribute<?> attribute : variableAttributes) {
            variableAtttributeMap.put(attribute.getName(), attribute);
        }
        return variableAtttributeMap;
    }

    public ComparisonConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ComparisonConfig configuration) {
        this.configuration = configuration;
    }
}

