/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.data.transform.wrapper.sdtl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.c2metadata.sdtl.pojo.expression.DoubleConstantExpression;
import org.c2metadata.sdtl.pojo.expression.ExpressionBase;
import org.c2metadata.sdtl.pojo.expression.FunctionCallExpression;
import org.c2metadata.sdtl.pojo.expression.GroupedExpression;
import org.c2metadata.sdtl.pojo.expression.IntConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringConstantExpression;
import org.c2metadata.sdtl.pojo.expression.UnknownExpression;
import org.c2metadata.sdtl.pojo.expression.UnsupportedExpression;
import org.c2metadata.sdtl.pojo.expression.VariableListExpression;
import org.c2metadata.sdtl.pojo.expression.VariableRangeExpression;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.SelectsVariable;
import us.mtna.data.transform.command.object.NewVariable;

public class Compute
implements SelectsVariable,
CreatesVariables {
    private final org.c2metadata.sdtl.pojo.command.Compute sdtl;

    public Compute(org.c2metadata.sdtl.pojo.command.Compute sdtl) {
        this.sdtl = sdtl;
    }

    @Override
    public TransformBase getOriginalCommand() {
        return this.sdtl;
    }

    @Override
    public String getFirst() {
        if (VariableRangeExpression.class.isAssignableFrom(this.sdtl.getExpression().getClass())) {
            VariableRangeExpression vs = (VariableRangeExpression)this.sdtl.getExpression();
            return vs.getFirst();
        }
        return null;
    }

    @Override
    public String getLast() {
        if (VariableRangeExpression.class.isAssignableFrom(this.sdtl.getExpression().getClass())) {
            VariableRangeExpression vs = (VariableRangeExpression)this.sdtl.getExpression();
            return vs.getLast();
        }
        return null;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> vars = new HashSet<String>();
        if (VariableSymbolExpression.class.isAssignableFrom(this.sdtl.getExpression().getClass())) {
            VariableSymbolExpression vs = (VariableSymbolExpression)this.sdtl.getExpression();
            vars.add(vs.getVariableName());
        } else if (VariableListExpression.class.isAssignableFrom(this.sdtl.getExpression().getClass())) {
            VariableListExpression vs = (VariableListExpression)this.sdtl.getExpression();
            vars.addAll(vs.getVariableNames());
        }
        return vars;
    }

    @Override
    public NewVariable[] getNewVariable() {
        ArrayList<NewVariable> newVars = new ArrayList<NewVariable>();
        NewVariable var = new NewVariable();
        String basisVariableName = null;
        ExpressionBase expr = this.sdtl.getExpression();
        this.checkForNestedExpressions(expr, var);
        var.setBasisVariableName(basisVariableName);
        var.setNewVariableName(this.sdtl.getVariable());
        newVars.add(var);
        return newVars.toArray(new NewVariable[newVars.size()]);
    }

    private void checkForNestedExpressions(ExpressionBase expression, NewVariable newVariable) {
        if (VariableSymbolExpression.class.isAssignableFrom(expression.getClass())) {
            VariableSymbolExpression expr = (VariableSymbolExpression)expression;
            newVariable.addSourceVariables(expr.getVariableName());
        } else if (VariableListExpression.class.isAssignableFrom(expression.getClass())) {
            VariableListExpression expr = (VariableListExpression)expression;
            newVariable.addSourceVariables(expr.getVariableNames().toArray(new String[expr.getVariableNames().size()]));
        } else if (VariableRangeExpression.class.isAssignableFrom(expression.getClass())) {
            VariableRangeExpression expr = (VariableRangeExpression)expression;
            newVariable.addSourceVariables(expr.getFirst(), expr.getLast());
        } else if (FunctionCallExpression.class.isAssignableFrom(expression.getClass())) {
            FunctionCallExpression expr = (FunctionCallExpression)expression;
            ExpressionBase[] expressionBaseArray = expr.getArguments();
            int n = expressionBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExpressionBase eb = expressionBaseArray[n2];
                this.checkForNestedExpressions(eb, newVariable);
                ++n2;
            }
        } else if (GroupedExpression.class.isAssignableFrom(expression.getClass())) {
            GroupedExpression expr = (GroupedExpression)expression;
            this.checkForNestedExpressions(expr.getExpression(), newVariable);
        } else if (DoubleConstantExpression.class.isAssignableFrom(expression.getClass())) {
            DoubleConstantExpression expr = (DoubleConstantExpression)expression;
            newVariable.setDataType(expr.getType());
        } else if (IntConstantExpression.class.isAssignableFrom(expression.getClass())) {
            IntConstantExpression expr = (IntConstantExpression)expression;
            newVariable.setDataType(expr.getType());
        } else if (StringConstantExpression.class.isAssignableFrom(expression.getClass())) {
            StringConstantExpression expr = (StringConstantExpression)expression;
            newVariable.setDataType(expr.getType());
        } else if (UnknownExpression.class.isAssignableFrom(expression.getClass())) {
            UnknownExpression unknownExpression = (UnknownExpression)expression;
        } else if (UnsupportedExpression.class.isAssignableFrom(expression.getClass())) {
            UnsupportedExpression unsupportedExpression = (UnsupportedExpression)expression;
        }
    }
}

