/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import us.mtna.data.transform.command.object.FileDetails;
import us.mtna.dataset.updater.DataSetManager;
import us.mtna.dataset.updater.exception.UnknownDataSetException;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.file.matching.FileDescription;
import us.mtna.pojo.file.matching.FileMatcher;
import us.mtna.reader.ResourceCopyUtility;

public class DefaultDataSetManager
implements DataSetManager {
    private LinkedHashMap<String, DataSet> datasets = new LinkedHashMap();
    private FileMatcher fileMatcher;

    public void mapDatasets(List<DataSet> datasets) {
        for (DataSet d : datasets) {
            this.datasets.put(d.getFile().getFileName(), d);
        }
    }

    public void mapDatasets(List<DataSet> datasets, DataSet primaryDataset) {
        this.datasets.put(primaryDataset.getDataSetId(), (DataSet)ResourceCopyUtility.copyResource(DataSet.class, (Object)primaryDataset));
        for (DataSet dataset : datasets) {
            this.datasets.put(dataset.getFile().getFileName(), dataset);
        }
    }

    @Override
    public DataSet loadDataSet(String file) {
        if (this.datasets.size() == 1) {
            return this.datasets.values().iterator().next();
        }
        DataSet dataSet = this.datasets.get(file = file.replaceAll("'", ""));
        if (dataSet != null) {
            return dataSet;
        }
        if (this.fileMatcher != null) {
            List descriptions = this.getFileMatcher().getParameters().getFileDescriptions();
            for (FileDescription fd : descriptions) {
                dataSet = this.loadDataSet(fd);
            }
        }
        if (dataSet == null) {
            throw new UnknownDataSetException(file);
        }
        return dataSet;
    }

    public DataSet loadDataSet(FileDescription fd) throws UnknownDataSetException {
        if (this.datasets.get(fd.getInputFileName()) != null) {
            return this.datasets.get(fd.getInputFileName());
        }
        if (this.datasets.get(fd.getFileNameDdi()) != null) {
            return this.datasets.get(fd.getFileNameDdi());
        }
        if (this.datasets.get(fd.getDdiXmlFile()) != null) {
            return this.datasets.get(fd.getDdiXmlFile());
        }
        throw new UnknownDataSetException(fd.getInputFileName());
    }

    public DataSet loadDataSet(FileDetails file) throws UnknownDataSetException {
        if (this.datasets.get(file.getFileName()) != null) {
            return this.datasets.get(file.getFileName());
        }
        if (this.datasets.get(file.getFilePath()) != null) {
            return this.datasets.get(file.getFilePath());
        }
        if (this.datasets.get(file.getFileNameAndExtension()) != null) {
            return this.datasets.get(file.getFileNameAndExtension());
        }
        if (this.datasets.get(file.getExtension()) != null) {
            return this.datasets.get(file.getExtension());
        }
        if (this.datasets.get(file.getUri()) != null) {
            return this.datasets.get(file.getUri());
        }
        throw new UnknownDataSetException(file.toString());
    }

    public DataSet loadMatchingDataSet(String file) {
        if (this.datasets.size() == 1) {
            return this.datasets.values().iterator().next();
        }
        DataSet dataSet = this.datasets.get(file = file.replaceAll("'", ""));
        if (dataSet != null) {
            return dataSet;
        }
        List descriptions = this.getFileMatcher().getParameters().getFileDescriptions();
        for (FileDescription fd : descriptions) {
            if (fd.getFileNameDdi().equals(file)) {
                return this.datasets.get(fd.getDdiXmlFile());
            }
            if (!file.equals(fd.getInputFileName())) continue;
            return this.datasets.get(fd.getFileNameDdi());
        }
        if (dataSet == null) {
            throw new UnknownDataSetException(file);
        }
        return null;
    }

    @Override
    public void saveDataSet(DataSet dataSet) {
        DataSet copydataSet = (DataSet)ResourceCopyUtility.copyResource(DataSet.class, (Object)dataSet);
        this.datasets.put(copydataSet.getDataSetId(), copydataSet);
    }

    @Override
    public Collection<DataSet> getDataSets() {
        return this.datasets.values();
    }

    public DataSet getDataSet(String id) {
        return this.datasets.get(id);
    }

    @Override
    public void setDatasets(LinkedHashMap<String, DataSet> datasets) {
        this.datasets = datasets;
    }

    public FileMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    @Override
    public void setFileMatcher(FileMatcher fileMatcher) {
        this.fileMatcher = fileMatcher;
    }
}

