/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.c2metadata.sdtl.pojo.Program;
import org.c2metadata.sdtl.pojo.command.TransformBase;
import org.ddialliance.ddi_2_5.xml.xmlbeans.CodeBookDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.c2metadata.xml.Ddi25XmlUpdater;
import us.mtna.data.transform.command.SdtlWrapper;
import us.mtna.data.transform.wrapper.sdtl.WrapperFactory;
import us.mtna.dataset.updater.DataSetUpdater;
import us.mtna.dataset.updater.InputInformation;
import us.mtna.dataset.updater.ValidationUtility;
import us.mtna.dataset.updater.exception.InvalidSdtlException;
import us.mtna.dataset.updater.exception.TransformationException;
import us.mtna.ddi.merge.DdiMerger;
import us.mtna.ddi.merge.exception.MergeException;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.Transform;
import us.mtna.pojo.file.matching.FileMatcher;
import us.mtna.reader.ReaderImplDDI25;
import us.mtna.reader.exceptions.ReaderException;
import us.mtna.transform.cogs.json.PseudocodeService;
import us.mtna.transform.cogs.json.TransformMapper;

public class Ddi25OutputGenerator {
    public static Logger log = LoggerFactory.getLogger(Ddi25OutputGenerator.class);
    public boolean validate = true;

    public String getUpdatedXmlAsString(Program sdtl, InputStream xml) throws ReaderException, TransformationException {
        return this.produceDDI(sdtl, this.parse(xml), null).xmlText();
    }

    public String getUpdatedXmlAsString(Program sdtl, InputStream xml, FileMatcher matcher) throws ReaderException, TransformationException {
        return this.produceDDI(sdtl, this.parse(xml), matcher).xmlText();
    }

    public String getUpdatedXmlAsString(InputInformation[] fileInformation, Program program, List<DataSet> datasets, XmlObject xmlObject) throws ReaderException, TransformationException {
        return this.produceDDIWithDsMap(fileInformation, program, datasets, xmlObject).xmlText();
    }

    public InputStream getUpdatedXmlAsStream(Program sdtl, InputStream xml) throws ReaderException, TransformationException {
        return this.produceDDI(sdtl, this.parse(xml), null).newInputStream();
    }

    public InputStream getUpdatedXmlAsStream(Program sdtl, InputStream xml, FileMatcher matcher) throws ReaderException, TransformationException {
        return this.produceDDI(sdtl, this.parse(xml), matcher).newInputStream();
    }

    public String getUpdatedXmlAsString(Program sdtl, InputStream ... xml) throws ReaderException, TransformationException, MergeException {
        return this.produceDDIMultiDocumemnt(sdtl, null, xml).xmlText();
    }

    public String getUpdatedXmlAsString(Program sdtl, FileMatcher matcher, InputStream ... xml) throws ReaderException, TransformationException, MergeException {
        return this.produceDDIMultiDocumemnt(sdtl, matcher, xml).xmlText();
    }

    public InputStream getUpdatedXmlAsStream(Program sdtl, InputStream ... xml) throws ReaderException, TransformationException, MergeException {
        return this.produceDDIMultiDocumemnt(sdtl, null, xml).newInputStream();
    }

    public InputStream getUpdatedXmlAsStream(Program sdtl, FileMatcher matcher, InputStream ... xml) throws ReaderException, TransformationException, MergeException {
        return this.produceDDIMultiDocumemnt(sdtl, matcher, xml).newInputStream();
    }

    public void setPseudocodeService(PseudocodeService service) {
        TransformMapper.setPseudocodeService((PseudocodeService)service);
    }

    protected CodeBookDocument parse(InputStream xml) {
        try {
            return (CodeBookDocument)XmlObject.Factory.parse((InputStream)xml);
        }
        catch (IOException | XmlException e) {
            throw new ReaderException("Error reading input stream as XML ", e);
        }
    }

    protected XmlObject produceDDI(Program sdtlProgram, CodeBookDocument xml, FileMatcher matcher) throws ReaderException {
        Object result;
        log.trace("Preparing to read xml into dataset objects");
        ReaderImplDDI25 reader = new ReaderImplDDI25();
        List readerDataSets = reader.getDataSets((XmlObject)xml);
        log.trace("Reader process complete." + readerDataSets.size() + " datasets found.");
        DataSet dataset = this.determinePrimaryDataset(readerDataSets);
        log.trace("Primary dataset determined [" + dataset.getFileDscrId() + "]");
        DataSetUpdater datasetUpdater = new DataSetUpdater(dataset, readerDataSets);
        datasetUpdater.getDataSetManager().setFileMatcher(matcher);
        if (this.validate && !(result = ValidationUtility.validate(sdtlProgram)).isValid()) {
            String language = sdtlProgram.getSourceLanguage() != null ? sdtlProgram.getSourceLanguage() : "";
            throw new InvalidSdtlException((List<String>)result.getMessages(), language);
        }
        for (TransformBase base : sdtlProgram.getCommands()) {
            log.trace("preparing to update with command " + (base.getSourceInformation() != null ? base.getSourceInformation().getOriginalSourceText() : "[no source provided]"));
            SdtlWrapper wrapper = WrapperFactory.wrap((TransformBase)base);
            Transform transform = TransformMapper.mapTransformBase((TransformBase)base, (String)sdtlProgram.getSourceLanguage());
            datasetUpdater.updateDataSet(wrapper, transform);
        }
        Ddi25XmlUpdater updater = new Ddi25XmlUpdater();
        updater.setLog(log);
        return updater.updateXml((XmlObject)xml, new DataSet[]{dataset});
    }

    protected XmlObject produceDDIWithDsMap(InputInformation[] fileInformation, Program program, List<DataSet> datasets, XmlObject xmlObject) throws ReaderException {
        Object result;
        log.trace("Preparing to read xml into dataset objects");
        DataSet primary = datasets.get(0);
        DataSetUpdater datasetUpdater = new DataSetUpdater(primary, datasets);
        if (this.validate && !(result = ValidationUtility.validate(program)).isValid()) {
            String language = program.getSourceLanguage() != null ? program.getSourceLanguage() : "";
            throw new InvalidSdtlException((List<String>)result.getMessages(), language);
        }
        for (TransformBase base : program.getCommands()) {
            log.trace("preparing to update with command " + (base.getSourceInformation() != null ? base.getSourceInformation().getOriginalSourceText() : "[no source provided]"));
            SdtlWrapper wrapper = WrapperFactory.wrap((TransformBase)base);
            Transform transform = TransformMapper.mapTransformBase((TransformBase)base, (String)program.getSourceLanguage());
            datasetUpdater.updateDataSet(wrapper, transform);
        }
        Ddi25XmlUpdater updater = new Ddi25XmlUpdater();
        updater.setLog(log);
        return updater.updateXml(xmlObject, new DataSet[]{primary});
    }

    protected XmlObject produceDDIMultiDocumemnt(Program sdtlProgram, FileMatcher matcher, InputStream ... inputs) throws ReaderException {
        return this.produceDDI(sdtlProgram, new DdiMerger().merge(inputs), matcher);
    }

    private DataSet determinePrimaryDataset(List<DataSet> datasets) {
        return datasets.get(datasets.size() - 1);
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        Ddi25OutputGenerator.log = log;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }
}

