/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.c2metadata.sdtl.pojo.FunctionArgument;
import org.c2metadata.sdtl.pojo.expression.AllVariablesExpression;
import org.c2metadata.sdtl.pojo.expression.CompositeVariableNameExpression;
import org.c2metadata.sdtl.pojo.expression.ExpressionBase;
import org.c2metadata.sdtl.pojo.expression.FunctionCallExpression;
import org.c2metadata.sdtl.pojo.expression.GroupedExpression;
import org.c2metadata.sdtl.pojo.expression.MissingValueConstantExpression;
import org.c2metadata.sdtl.pojo.expression.NumericConstantExpression;
import org.c2metadata.sdtl.pojo.expression.StringConstantExpression;
import org.c2metadata.sdtl.pojo.expression.VariableListExpression;
import org.c2metadata.sdtl.pojo.expression.VariableRangeExpression;
import org.c2metadata.sdtl.pojo.expression.VariableReferenceBase;
import org.c2metadata.sdtl.pojo.expression.VariableSymbolExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.DeletesVariable;
import us.mtna.data.transform.command.SdtlWrapper;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesClassification;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.ds.AppendsDatasets;
import us.mtna.data.transform.command.ds.LoadsDataset;
import us.mtna.data.transform.command.ds.MergesDatasets;
import us.mtna.data.transform.command.ds.ReordersDataset;
import us.mtna.data.transform.command.ds.SavesDataset;
import us.mtna.data.transform.command.object.ClassificationUpdate;
import us.mtna.data.transform.command.object.ClassificationUtils;
import us.mtna.data.transform.command.object.CodeDetail;
import us.mtna.data.transform.command.object.MinMax;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.UpdaterMergeFileDescription;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.dataset.updater.CodeMappingUtility;
import us.mtna.dataset.updater.DataSetManager;
import us.mtna.dataset.updater.DataSetManagerFactory;
import us.mtna.dataset.updater.exception.MissingSourceVariableException;
import us.mtna.dataset.updater.exception.UnknownDataSetException;
import us.mtna.dataset.updater.impl.DefaultDataSetManagerFactory;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.DataType;
import us.mtna.pojo.Transform;
import us.mtna.pojo.Variable;
import us.mtna.reader.ResourceCopyUtility;

public class DataSetUpdater {
    private DataSet primaryDataset;
    private final DataSetManager dataSetManager;
    private boolean allowComputeClassifications;
    private Map<String, HashSet<String>> possibleCodes;
    private final HashMap<String, Variable> variableMap;
    private Logger log = LoggerFactory.getLogger(DataSetUpdater.class);
    private static DataSetManagerFactory managerFactory = new DefaultDataSetManagerFactory();

    public DataSetUpdater(DataSet primaryDataset, List<DataSet> datasets) {
        this.primaryDataset = primaryDataset;
        this.variableMap = new HashMap();
        this.possibleCodes = new HashMap<String, HashSet<String>>();
        this.dataSetManager = managerFactory.getInstance(datasets);
    }

    public DataSetUpdater(DataSet primaryDataset) {
        this(primaryDataset, Collections.emptyList());
    }

    public synchronized DataSet updateDataSet(SdtlWrapper wrapper, Transform transform) {
        for (String property : wrapper.getOriginalCommand().getUnknownProperties()) {
            this.log.info("Unknown property [" + property + "] found on command " + wrapper.getOriginalCommand().getCommand());
        }
        this.variableMap.clear();
        if (LoadsDataset.class.isAssignableFrom(wrapper.getClass())) {
            LoadsDataset loads = (LoadsDataset)wrapper;
            this.primaryDataset = this.dataSetManager.loadDataSet(loads.getDatasetId());
            this.log.debug("Loading dataset [" + loads.getDatasetId() + "] and setting as the primary dataset.");
        }
        if (MergesDatasets.class.isAssignableFrom(wrapper.getClass())) {
            MergesDatasets merges = (MergesDatasets)wrapper;
            this.matchByVariable(merges, transform);
        }
        if (AppendsDatasets.class.isAssignableFrom(wrapper.getClass())) {
            AppendsDatasets appends = (AppendsDatasets)wrapper;
            this.appendDatasets(appends, transform);
        }
        if (this.primaryDataset == null) {
            this.log.info("Primary dataset is null after performing dataset commands and the program cannot continue.");
            throw new UnknownDataSetException("Dataset is null after performing Dataset commands and the program cannot continue.");
        }
        if (CreatesVariables.class.isAssignableFrom(wrapper.getClass())) {
            CreatesVariables creates = (CreatesVariables)wrapper;
            this.createVariables(creates, transform);
        }
        if (SelectsVariables.class.isAssignableFrom(wrapper.getClass())) {
            this.getSelectedVariables(wrapper, transform);
        }
        if (ReordersDataset.class.isAssignableFrom(wrapper.getClass())) {
            ReordersDataset reorders = (ReordersDataset)wrapper;
            this.reorderDataset(reorders, transform);
        }
        if (DeletesVariable.class.isAssignableFrom(wrapper.getClass())) {
            DeletesVariable deletes = (DeletesVariable)wrapper;
            this.markVariablesAsDeleted(transform, deletes);
        }
        if (UpdatesVariables.class.isAssignableFrom(wrapper.getClass())) {
            UpdatesVariables updatesVar = (UpdatesVariables)wrapper;
            this.updateVariables(updatesVar);
        }
        if (UpdatesClassification.class.isAssignableFrom(wrapper.getClass())) {
            UpdatesClassification updatesClassif = (UpdatesClassification)wrapper;
            this.updateClassification(updatesClassif);
        }
        if (SavesDataset.class.isAssignableFrom(wrapper.getClass())) {
            SavesDataset saves = (SavesDataset)wrapper;
            this.saveDataset(saves, transform);
        }
        return this.primaryDataset;
    }

    private void reorderDataset(ReordersDataset reordersDataset, Transform transform) {
        LinkedHashSet<String> variableOrder = new LinkedHashSet<String>();
        for (VariableReferenceBase base : reordersDataset.getVariableOrder()) {
            variableOrder.addAll(this.parseExpressionBase((ExpressionBase)base, this.primaryDataset.getMetadata().getVarNameMap()));
        }
        ArrayList<Variable> newOrder = new ArrayList<Variable>();
        this.log.trace("Reordering dataset with command [" + transform.getOriginalCommand().getCommand() + "]");
        for (String variableName : variableOrder) {
            Variable variable = this.variableMap.get(variableName);
            newOrder.add(variable);
        }
        if (!newOrder.isEmpty()) {
            this.primaryDataset.getMetadata().setVariables(newOrder);
        }
        this.primaryDataset.addCommands(new Transform[]{transform});
    }

    private void saveDataset(SavesDataset savesDataset, Transform transform) {
        this.log.trace("Saving dataset with ID [" + savesDataset.getDatasetId() + "]");
        this.primaryDataset.addCommands(new Transform[]{transform});
        this.dataSetManager.saveDataSet(this.primaryDataset);
    }

    private void appendDatasets(AppendsDatasets appendsDatasets, Transform transform) {
        LinkedHashMap orderedVarMap = new LinkedHashMap();
        DataSet newDataSet = new DataSet();
        newDataSet.addCommands(new Transform[]{transform});
        for (String datasetId : appendsDatasets.getFileNames()) {
            DataSet dataset = this.dataSetManager.loadDataSet(datasetId);
            orderedVarMap.putAll(dataset.getMetadata().getVarNameMap());
            this.log.info("Appending variables from dataset [id=" + datasetId + "] into target dataset [" + newDataSet.getId() + "]");
        }
        newDataSet.getMetadata().setVariables(new LinkedList(orderedVarMap.values()));
        this.setPrimaryDataset(newDataSet);
    }

    private void matchByVariable(MergesDatasets merges, Transform transform) {
        DataSet ds = new DataSet();
        ds.addCommands(new Transform[]{transform});
        HashMap datasetVars = new HashMap();
        for (UpdaterMergeFileDescription file : merges.getMergeFileDscr()) {
            LinkedHashSet<Object> vars = new LinkedHashSet<Object>();
            if (file.getFileName() == null) continue;
            ds = this.dataSetManager.loadDataSet(file.getFileName());
            for (Variable v : ds.getMetadata().getVarNameMap().values()) {
                vars.add(v);
            }
            if (file.getMergeFlagVariable() != null) {
                Variable v = new Variable();
                v.addTransforms(new Transform[]{transform});
                v.setName(file.getMergeFlagVariable());
                vars.add(v);
            }
            datasetVars.put(ds.getId(), vars);
            if (file.getRenameVariables() != null && !file.getRenameVariables().isEmpty()) {
                for (VariableNamePair pair : file.getRenameVariables()) {
                    if (pair.getSource() == null || pair.getTarget() == null || ds.getMetadata().getVarNameMap().get(pair.getSource()) == null) continue;
                    Variable varToRename = (Variable)ds.getMetadata().getVarNameMap().get(pair.getSource());
                    varToRename.setName(pair.getTarget());
                }
            }
            this.keepAndDropVars(file.getKeepVariables(), file.getDropVariables(), transform, ds.getMetadata().getVarNameMap());
        }
        LinkedHashSet<String> matchByVars = this.parseExpressionBase((ExpressionBase)merges.getMergeByVariables(), ds.getMetadata().getVarNameMap());
        LinkedHashMap<String, Variable> finalList = new LinkedHashMap<String, Variable>();
        for (Map.Entry entry : datasetVars.entrySet()) {
            for (Variable v : (LinkedHashSet)entry.getValue()) {
                if (finalList.keySet().contains(v.getName())) {
                    if (matchByVars.contains(v.getName())) continue;
                    this.log.warn("Duplicate variable name [" + v.getName() + "] found when merging datasets. The duplicate variable was added.");
                    finalList.put(v.getName(), v);
                    continue;
                }
                finalList.put(v.getName(), v);
            }
        }
        this.keepAndDropVars(merges.getKeepVariables(), merges.getDropVariables(), transform, finalList);
        ds.getMetadata().setVariables(new LinkedList<Variable>(finalList.values()));
    }

    private void keepAndDropVars(VariableReferenceBase[] keeps, VariableReferenceBase[] drops, Transform transform, Map<String, Variable> variableMap) {
        LinkedHashSet<String> keepVars = new LinkedHashSet<String>();
        LinkedHashSet<String> dropVars = new LinkedHashSet<String>();
        if (keeps != null) {
            for (VariableReferenceBase keep : keeps) {
                keepVars.addAll(this.parseExpressionBase((ExpressionBase)keep, variableMap));
            }
        }
        if (drops != null) {
            for (VariableReferenceBase drop : drops) {
                dropVars.addAll(this.parseExpressionBase((ExpressionBase)drop, variableMap));
            }
        }
        if (!keepVars.isEmpty()) {
            for (Map.Entry entry : variableMap.entrySet()) {
                if (keepVars.contains(entry.getKey())) continue;
                ((Variable)entry.getValue()).setDeleted(true);
                ((Variable)entry.getValue()).addTransforms(new Transform[]{transform});
            }
        }
        if (!dropVars.isEmpty()) {
            for (String string : dropVars) {
                if (variableMap.get(string) == null) continue;
                Variable v = variableMap.get(string);
                v.setDeleted(true);
                v.addTransforms(new Transform[]{transform});
            }
        }
    }

    private void getSelectedVariables(SdtlWrapper wrapper, Transform transform) {
        SelectsVariables selector = (SelectsVariables)wrapper;
        Map datasetVariableMap = this.primaryDataset.getMetadata().getVarNameMap();
        if (!selector.getRanges().isEmpty()) {
            datasetVariableMap.putAll(this.extractAndReturnRangeVariables(transform, selector.getRanges(), datasetVariableMap));
        }
        if (selector.getVariables() != null) {
            for (String variableName : selector.getVariables()) {
                if (datasetVariableMap.get(variableName) == null) continue;
                if (!new ArrayList<Transform>(Arrays.asList(((Variable)datasetVariableMap.get(variableName)).getTransforms())).contains(transform)) {
                    ((Variable)datasetVariableMap.get(variableName)).addTransforms(new Transform[]{transform});
                }
                this.log.trace("Adding variable [name=" + variableName + "] to the variable list");
                this.variableMap.put(variableName, (Variable)datasetVariableMap.get(variableName));
            }
        }
    }

    private HashMap<String, Variable> extractAndReturnRangeVariables(Transform transform, List<Range> ranges, Map<String, Variable> datasetVariableMap) {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (Range range : ranges) {
            if (range.getStart() == null) continue;
            if (range.getEnd() != null) {
                for (Variable variable : this.primaryDataset.getVariablesInRange(range.getStart(), range.getEnd())) {
                    if (!new ArrayList<Transform>(Arrays.asList(variable.getTransforms())).contains(transform)) {
                        variable.addTransforms(new Transform[]{transform});
                    }
                    variables.put(variable.getName(), variable);
                }
                continue;
            }
            if (!new ArrayList<Transform>(Arrays.asList(datasetVariableMap.get(range.getStart()).getTransforms())).contains(transform)) {
                datasetVariableMap.get(range.getStart()).addTransforms(new Transform[]{transform});
            }
            variables.put(range.getStart(), datasetVariableMap.get(range.getStart()));
        }
        return variables;
    }

    private void createVariables(CreatesVariables createsVariables, Transform transform) {
        for (NewVariable newVariable : createsVariables.getNewVariables()) {
            Variable variable;
            if (this.allowComputeClassifications) {
                this.addPossibleCodes(newVariable);
            }
            if (newVariable.getBasisVariableName() != null) {
                variable = this.createCopyOfBasisVariable(transform, newVariable);
            } else {
                if (this.primaryDataset.getMetadata().getVarNameMap().containsKey(newVariable.getNewVariableName())) {
                    this.populateVariableFromMetadata(transform, newVariable);
                    continue;
                }
                variable = this.createNewVariable(transform, newVariable);
            }
            variable.addTransforms(new Transform[]{transform});
            variable.setName(newVariable.getNewVariableName());
            this.primaryDataset.getMetadata().getVariables().add(variable);
            this.primaryDataset.getMetadata().getVarNameMap().put(variable.getName(), variable);
            this.variableMap.put(variable.getName(), variable);
            this.log.trace("Registering variable [id=" + variable.getId() + "] in the metadata.");
        }
    }

    private void addPossibleCodes(NewVariable newVariable) {
        HashSet<String> newVariableCodes = new HashSet<String>();
        for (String possibleCode : newVariable.getPossibleCodes()) {
            newVariableCodes.add(possibleCode);
        }
        if (this.possibleCodes.keySet().contains(newVariable.getNewVariableName())) {
            HashSet<String> existingCodes = this.possibleCodes.get(newVariable.getNewVariableName());
            existingCodes.addAll(newVariableCodes);
            this.possibleCodes.put(newVariable.getNewVariableName(), existingCodes);
        } else {
            this.possibleCodes.put(newVariable.getNewVariableName(), newVariableCodes);
        }
    }

    private Variable createNewVariable(Transform transform, NewVariable newVariable) {
        Variable variable = new Variable();
        variable.setClassificationId(UUID.randomUUID().toString());
        this.primaryDataset.getMetadata().getClassifs().put(variable.getClassificationId(), new Classification());
        this.addSourceVariablesFromRange(transform, newVariable);
        transform.addSourceIds(newVariable.getSourceVariables().toArray(new String[0]));
        this.log.trace("Creating new variable [id=" + variable.getId() + "] and registering its new classification in the metadata.");
        return variable;
    }

    private Variable populateVariableFromMetadata(Transform transform, NewVariable newVariable) {
        Variable variable = (Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getNewVariableName());
        this.checkForNullSourceVariable(transform, newVariable.getNewVariableName(), variable);
        this.addSourceVariablesFromRange(transform, newVariable);
        transform.addSourceIds(new String[]{((Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getNewVariableName())).getId()});
        variable.removeAllTransforms();
        variable.addTransforms(new Transform[]{transform});
        variable.setId(UUID.randomUUID().toString());
        variable.setName(newVariable.getNewVariableName());
        this.log.trace("Creating new variable with name [" + newVariable.getNewVariableName() + "]. A variable with the same name was found in the metadata, so a copy of that variable is being used as the basis");
        return variable;
    }

    private void addSourceVariablesFromRange(Transform transform, NewVariable newVariable) {
        if (newVariable.getSourceVariableRange() != null) {
            Range range = newVariable.getSourceVariableRange();
            List sourceVarsFromRange = this.primaryDataset.getVariablesInRange(range.getStart(), range.getEnd());
            for (Variable variable : sourceVarsFromRange) {
                transform.addSourceIds(new String[]{variable.getName()});
            }
        }
    }

    private Variable createCopyOfBasisVariable(Transform transform, NewVariable newVariable) {
        Variable originalVariable = (Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getBasisVariableName());
        Variable variableCopy = (Variable)ResourceCopyUtility.copyResource(Variable.class, this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getBasisVariableName()));
        this.checkForNullSourceVariable(transform, newVariable.getBasisVariableName(), variableCopy);
        variableCopy.setName(newVariable.getNewVariableName());
        variableCopy.setClassificationId(originalVariable.getClassificationId());
        variableCopy.removeAllTransforms();
        variableCopy.setId(UUID.randomUUID().toString());
        transform.addSourceIds(new String[]{originalVariable.getId()});
        this.log.trace("Creating a variable based on variable [name=" + newVariable.getBasisVariableName() + "] from the datset with properties from command [" + transform.getOriginalCommand().getCommand() + "]");
        return variableCopy;
    }

    private void checkForNullSourceVariable(Transform transform, String name, Variable variable) {
        if (variable == null) {
            this.log.warn("Variable [" + name + "] is null, cannot continue with recode");
            throw new MissingSourceVariableException("Variable [" + name + "] is null, cannot continue with recode.", name, transform.getOriginalCommand().getCommand());
        }
    }

    private void markVariablesAsDeleted(Transform transform, DeletesVariable deletes) {
        boolean listEmpty = false;
        boolean rangeEmpty = false;
        if (deletes.getDeletedVars() == null || deletes.getDeletedVars().isEmpty()) {
            listEmpty = true;
        }
        if (deletes.getDeletedVariableRanges() == null || deletes.getDeletedVariableRanges().isEmpty()) {
            rangeEmpty = true;
        }
        if (listEmpty && rangeEmpty) {
            this.log.debug("The list of variables to be deleted is empty.");
            return;
        }
        Map datasetVariableMap = this.primaryDataset.getMetadata().getVarNameMap();
        datasetVariableMap.putAll(this.extractAndReturnRangeVariables(transform, deletes.getDeletedVariableRanges(), datasetVariableMap));
        for (String deletedVariable : deletes.getDeletedVars()) {
            Variable variable = this.variableMap.get(deletedVariable);
            if (variable != null) {
                variable.setDeleted(true);
                this.log.trace("Setting variable [name=" + variable.getName() + "] as deleted.");
                continue;
            }
            this.log.debug("Attempted to delete variable [name=" + deletedVariable + "] but it could not be found.");
        }
    }

    private void updateVariables(UpdatesVariables updatesVariables) {
        for (Variable variable : this.variableMap.values()) {
            if (updatesVariables.getUpdatedVariables() != null) {
                for (VariableNamePair pair : updatesVariables.getUpdatedVariables()) {
                    if (!variable.getName().equals(pair.getSource())) continue;
                    variable.setName(pair.getTarget());
                    if (pair.getLabel() == null) continue;
                    variable.setLabel(pair.getLabel());
                }
                continue;
            }
            this.log.debug("The list of variables to update is null.");
        }
    }

    private void updateClassification(UpdatesClassification updateClassification) {
        ClassificationUpdate update = updateClassification.getUpdate();
        ArrayList<String> usedCodes = new ArrayList<String>();
        for (Variable variable : this.variableMap.values()) {
            if (variable == null) {
                variable = new Variable();
            }
            Classification classification = this.determineClassificationToUse(updateClassification, variable);
            this.checkForDataTypeChange(variable, classification);
            this.removeCodes(update, usedCodes, classification);
            this.updateCodes(update, usedCodes, classification);
            this.addCodes(update, usedCodes, classification);
            if (updateClassification.copyFloatingCodes()) continue;
            List untouched = ClassificationUtils.getUntouchedCodes((Classification)classification, usedCodes);
            for (Code code : untouched) {
                classification.removeCode(code.getCodeValue());
                this.log.trace("UpdatesClassification: Removing unused code [" + code.getCodeValue() + "] from classification [" + classification.getId() + "]. (Floating codes are set to not be carried over.)");
            }
        }
    }

    private void checkForDataTypeChange(Variable variable, Classification classification) {
        DataType variableType;
        boolean numericCodes = false;
        if (!classification.getCodeList().isEmpty() && StringUtils.isNumeric((CharSequence)((Code)classification.getCodeList().get(0)).getCodeValue())) {
            numericCodes = true;
        }
        if ((variableType = variable.getDataType()) == DataType.STRING && numericCodes) {
            variable.setDataType(DataType.NUMBER);
        } else if (variableType == DataType.NUMBER && !numericCodes) {
            variable.setDataType(DataType.STRING);
        }
    }

    private Classification determineClassificationToUse(UpdatesClassification updatesClassification, Variable variable) {
        Classification classification;
        if (updatesClassification.requiresCopyOfClassification()) {
            if (!this.possibleCodes.keySet().contains(variable.getName())) {
                Classification oldClassif = this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId()) == null ? new Classification() : this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId());
                classification = (Classification)ResourceCopyUtility.copyResource(Classification.class, (Object)oldClassif);
                classification.setId(UUID.randomUUID().toString());
                this.primaryDataset.getMetadata().getClassifs().put(classification.getId(), classification);
                variable.setClassification(classification);
                this.log.trace("UpdatesClassification requires a new classification, so new classification [" + classification.getId() + "] was created and registered in the metadata .");
            } else {
                Classification classification2 = classification = this.primaryDataset.getMetadata().getClassifs().keySet().contains(variable.getClassificationId()) ? (Classification)this.primaryDataset.getMetadata().getClassifs().get(variable.getClassificationId()) : new Classification();
                if (this.possibleCodes.get(variable.getName()) != null) {
                    HashSet<String> codesToUse = this.possibleCodes.get(variable.getName());
                    ArrayList<Code> codesToAdd = new ArrayList<Code>();
                    for (String codeValue : codesToUse) {
                        Code code = new Code();
                        code.setCodeValue(codeValue);
                        codesToAdd.add(code);
                    }
                    classification.addCodesToCodeList(codesToAdd);
                }
                classification.setId(UUID.randomUUID().toString());
                variable.setClassificationId(classification.getId());
                variable.setClassification(classification);
                this.primaryDataset.getMetadata().getClassifs().put(classification.getId(), classification);
            }
        } else {
            classification = this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId()) == null ? new Classification() : this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId());
            this.log.trace("New classification not required for UpdatesClassification, so classification [" + classification.getId() + "] pulled from the metadata to be updated.");
        }
        return classification;
    }

    private void updateCodes(ClassificationUpdate classificationUpdate, List<String> usedCodes, Classification classification) {
        if (classificationUpdate.getUpdatesCodes() != null) {
            for (CodeDetail codeDetail : classificationUpdate.getUpdatesCodes()) {
                Code code;
                if (!classification.getCodeList().contains(codeDetail.getFromValue())) {
                    if (this.allowComputeClassifications && this.possibleCodes.containsKey(codeDetail.getFromValue())) {
                        classification.addNewCode(this.createCode(codeDetail));
                    }
                    if (codeDetail.getFromValue() == null) {
                        classification.addNewCode(this.createCode(codeDetail));
                    }
                }
                if ((code = classification.lookupCode(codeDetail.getFromValue())) == null) {
                    this.log.trace("UpdatesClassification: no match found when looking up code [" + codeDetail.getFromValue() + "] in classification [" + classification.getId() + "]. Looking up code value numerically");
                    CodeMappingUtility mappingUtility = CodeMappingUtility.getInstance(classification);
                    List<Code> numericallyMatchedCodes = mappingUtility.lookupNumericCode(codeDetail.getFromValue());
                    for (Code c : numericallyMatchedCodes) {
                        this.log.trace("UpdatesClassification: updating code [" + c.getCodeValue() + "].");
                        this.updateCode(c, codeDetail.getLabel(), codeDetail.isMissing(), codeDetail.getMissingType());
                        usedCodes.add(c.getCodeValue());
                    }
                    continue;
                }
                this.log.trace("UpdatesClassification: updating code [" + code.getCodeValue() + "].");
                this.updateCode(code, codeDetail.getLabel(), codeDetail.isMissing(), codeDetail.getMissingType());
                usedCodes.add(code.getCodeValue());
            }
        }
        if (classificationUpdate.getUpdatesCodeRange() != null) {
            for (CodeDetail codeDetail : classificationUpdate.getUpdatesCodeRange()) {
                for (Code code : classification.selectCodeRange(codeDetail.getFromRange().getStart(), codeDetail.getFromRange().getEnd())) {
                    this.log.trace("UpdatesClassification: updating code [" + code.getCodeValue() + "].");
                    this.updateCode(code, codeDetail.getLabel(), codeDetail.isMissing(), codeDetail.getMissingType());
                    usedCodes.add(code.getCodeValue());
                }
            }
        }
        if (classificationUpdate.getUpdatesCodes() != null && classificationUpdate.getUpdatesCodeRange() != null) {
            this.log.trace("UpdatesClassification: no codes found to update.");
        }
    }

    private void removeCodes(ClassificationUpdate classificationUpdate, List<String> usedCodes, Classification classification) {
        if (classificationUpdate.getRemovedCodes() != null) {
            for (String string : classificationUpdate.getRemovedCodes()) {
                classification.removeCode(string);
                usedCodes.add(string);
                this.log.trace("UpdatesClassification: removing code [" + string + "].");
            }
        }
        if (classificationUpdate.getRemovedCodeRanges() != null) {
            for (String string : classificationUpdate.getRemovedCodeRanges()) {
                if (string.getEnd().equals(MinMax.MAXIMUM.getValue()) && !classification.getCodeList().isEmpty()) {
                    string.setEnd(((Code)classification.getCodeList().get(classification.getCodeList().size() - 1)).getCodeValue());
                }
                if (string.getStart().equals(MinMax.MINIMUM.getValue()) && !classification.getCodeList().isEmpty()) {
                    string.setStart(((Code)classification.getCodeList().get(0)).getCodeValue());
                }
                for (Code code : classification.selectCodeRange(string.getStart(), string.getEnd())) {
                    classification.removeCode(code.getCodeValue());
                    usedCodes.add(code.getCodeValue().trim());
                    this.log.trace("UpdatesClassification: removing code [" + code.getCodeValue() + "].");
                }
            }
        }
        if (classificationUpdate.getRemovedCodeRanges() == null && classificationUpdate.getRemovedCodes() == null) {
            this.log.trace("UpdatesClassification: no codes found to remove.");
        }
    }

    private void addCodes(ClassificationUpdate update, List<String> usedCodes, Classification classification) {
        Code code;
        if (update.getNewCodes() != null) {
            for (CodeDetail codeDetail : update.getNewCodes()) {
                code = this.createCode(codeDetail);
                classification.addNewCode(code);
                usedCodes.add(code.getCodeValue());
                this.log.trace("UpdatesClassification: creating code [" + code.getCodeValue() + "].");
            }
        }
        if (update.getNewCodeRanges() != null) {
            for (CodeDetail codeDetail : update.getNewCodeRanges()) {
                code = this.createCode(new CodeDetail(codeDetail.getTargetValue(), codeDetail.getLabel(), codeDetail.isMissing()));
                classification.addNewCode(code);
                usedCodes.add(code.getCodeValue());
                this.log.trace("UpdatesClassification: creating code [" + code.getCodeValue() + "].");
            }
        }
        if (update.getNewCodes() == null && update.getNewCodeRanges() == null) {
            this.log.trace("UpdatesClassification: no new codes created.");
        }
    }

    private void updateCode(Code code, String label, boolean missing, String missingType) {
        code.setLabel(label);
        code.setMissing(missing);
    }

    private Code createCode(CodeDetail codeDetail) {
        Code code = new Code();
        if (codeDetail.getNewValue() != null) {
            code.setCodeValue(codeDetail.getNewValue());
        }
        if (codeDetail.getLabel() != null) {
            code.setLabel(codeDetail.getLabel());
        }
        code.setMissing(codeDetail.isMissing());
        return code;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public static void setDataSetManagerFactory(DataSetManagerFactory managerFactory) {
        DataSetUpdater.managerFactory = managerFactory;
    }

    public void setPrimaryDataset(DataSet dataset) {
        this.primaryDataset = dataset;
    }

    public DataSet getPrimaryDataset() {
        return this.primaryDataset;
    }

    public boolean isAllowComputeClassifications() {
        return this.allowComputeClassifications;
    }

    public void setAllowComputeClassifications(boolean allowComputeClassifications) {
        this.allowComputeClassifications = allowComputeClassifications;
    }

    public Map<String, HashSet<String>> getPossibleCodes() {
        return this.possibleCodes;
    }

    public void setPossibleCodes(Map<String, HashSet<String>> possibleCodes) {
        this.possibleCodes = possibleCodes;
    }

    public DataSetManager getDataSetManager() {
        return this.dataSetManager;
    }

    private LinkedHashSet<String> parseExpressionBase(ExpressionBase expression, Map<String, Variable> varMap) {
        LinkedHashSet<String> vars = new LinkedHashSet<String>();
        if (expression != null) {
            if (VariableSymbolExpression.class.isAssignableFrom(expression.getClass())) {
                VariableSymbolExpression expr = (VariableSymbolExpression)expression;
                vars.add(expr.getVariableName());
            } else if (VariableRangeExpression.class.isAssignableFrom(expression.getClass())) {
                VariableRangeExpression expr = (VariableRangeExpression)expression;
                List<Variable> vasr = this.getVariablesInRange(expr.getFirst(), expr.getLast(), varMap);
                for (Variable v : vasr) {
                    vars.add(v.getName());
                }
            } else if (VariableListExpression.class.isAssignableFrom(expression.getClass())) {
                VariableListExpression expr = (VariableListExpression)expression;
                for (VariableReferenceBase base : expr.getVariables()) {
                    vars.addAll(this.parseExpressionBase((ExpressionBase)base, varMap));
                }
            } else if (FunctionCallExpression.class.isAssignableFrom(expression.getClass())) {
                FunctionCallExpression expr = (FunctionCallExpression)expression;
                for (FunctionArgument eb : expr.getArguments()) {
                    vars.addAll(this.parseExpressionBase(eb.getArgumentValue(), varMap));
                }
            } else if (GroupedExpression.class.isAssignableFrom(expression.getClass())) {
                GroupedExpression expr = (GroupedExpression)expression;
                vars.addAll(this.parseExpressionBase(expr.getExpression(), varMap));
            } else if (NumericConstantExpression.class.isAssignableFrom(expression.getClass())) {
                NumericConstantExpression expr = (NumericConstantExpression)expression;
                vars.add(String.valueOf(expr.getValue()));
            } else if (MissingValueConstantExpression.class.isAssignableFrom(expression.getClass())) {
                MissingValueConstantExpression expr = (MissingValueConstantExpression)expression;
                vars.add(String.valueOf(expr.getValue()));
            } else if (StringConstantExpression.class.isAssignableFrom(expression.getClass())) {
                StringConstantExpression expr = (StringConstantExpression)expression;
                vars.add(expr.getValue());
            } else if (CompositeVariableNameExpression.class.isAssignableFrom(expression.getClass())) {
                CompositeVariableNameExpression composite = (CompositeVariableNameExpression)expression;
                vars.addAll(this.parseExpressionBase(composite.getComputedVariableName(), varMap));
            } else if (AllVariablesExpression.class.isAssignableFrom(expression.getClass())) {
                vars.addAll(varMap.keySet());
            }
        }
        return vars;
    }

    public List<Variable> getVariablesInRange(String from, String to, Map<String, Variable> originalMap) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        HashMap<String, Variable> varMap = new HashMap<String, Variable>();
        for (Map.Entry<String, Variable> entry : originalMap.entrySet()) {
            varMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        boolean useStartPosition = true;
        for (Variable variable : varMap.values()) {
            if (variable.getStartPosition() != null) continue;
            useStartPosition = false;
            break;
        }
        ArrayList<Variable> arrayList = new ArrayList<Variable>(originalMap.values());
        if (useStartPosition) {
            Collections.sort(arrayList, Variable.StartPositionComparator);
        }
        Variable mapFirst = (Variable)varMap.get(from.toUpperCase());
        Variable mapLast = (Variable)varMap.get(to.toUpperCase());
        int toIndex = arrayList.indexOf(mapLast);
        int fromIndex = arrayList.indexOf(mapFirst);
        List subList = arrayList.subList(fromIndex, toIndex + 1);
        for (Variable variable : subList) {
            vars.add(variable);
        }
        return vars;
    }
}

