/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mtna.data.transform.command.CreatesVariables;
import us.mtna.data.transform.command.DeletesVariable;
import us.mtna.data.transform.command.SdtlWrapper;
import us.mtna.data.transform.command.SelectsVariables;
import us.mtna.data.transform.command.UpdatesClassification;
import us.mtna.data.transform.command.UpdatesVariables;
import us.mtna.data.transform.command.ds.JoinsDatasets;
import us.mtna.data.transform.command.ds.LoadsDataset;
import us.mtna.data.transform.command.ds.ReordersDataset;
import us.mtna.data.transform.command.ds.SavesDataset;
import us.mtna.data.transform.command.object.ClassificationUpdate;
import us.mtna.data.transform.command.object.ClassificationUtils;
import us.mtna.data.transform.command.object.CodeDetail;
import us.mtna.data.transform.command.object.NewVariable;
import us.mtna.data.transform.command.object.Range;
import us.mtna.data.transform.command.object.VariableNamePair;
import us.mtna.dataset.updater.CodeMappingUtility;
import us.mtna.dataset.updater.DataSetManager;
import us.mtna.dataset.updater.DataSetManagerFactory;
import us.mtna.dataset.updater.exception.MissingFilesException;
import us.mtna.dataset.updater.exception.MissingSourceVariableException;
import us.mtna.dataset.updater.exception.TransformationException;
import us.mtna.dataset.updater.exception.UnknownDataSetException;
import us.mtna.dataset.updater.impl.DefaultDataSetManagerFactory;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;
import us.mtna.pojo.DataSet;
import us.mtna.pojo.DataType;
import us.mtna.pojo.Transform;
import us.mtna.pojo.Variable;
import us.mtna.reader.ResourceCopyUtility;

public class DataSetUpdater {
    private DataSet primaryDataset;
    private final DataSetManager dataSetManager;
    private boolean allowComputeClassifications;
    private Map<String, HashSet<String>> possibleCodes;
    private final HashMap<String, Variable> variableMap;
    private Logger log = LoggerFactory.getLogger(DataSetUpdater.class);
    private static DataSetManagerFactory managerFactory = new DefaultDataSetManagerFactory();

    public DataSetUpdater(DataSet primaryDataset, List<DataSet> datasets) {
        this.primaryDataset = primaryDataset;
        this.variableMap = new HashMap();
        this.possibleCodes = new HashMap<String, HashSet<String>>();
        this.dataSetManager = managerFactory.getInstance(datasets);
    }

    public DataSetUpdater(DataSet primaryDataset) {
        this(primaryDataset, Collections.emptyList());
    }

    public synchronized void updateDataSet(SdtlWrapper wrapper, Transform transform) throws TransformationException {
        String[] stringArray = wrapper.getOriginalCommand().getUnknownProperties();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            this.log.info("Unknown property [" + property + "] found on command " + wrapper.getOriginalCommand().getCommand());
            ++n2;
        }
        this.variableMap.clear();
        if (LoadsDataset.class.isAssignableFrom(wrapper.getClass())) {
            LoadsDataset loads = (LoadsDataset)wrapper;
            this.primaryDataset = this.dataSetManager.loadDataSet(loads.getDatasetId());
            this.log.debug("Loading dataset [" + loads.getDatasetId() + "] and setting as the primary dataset.");
        }
        if (JoinsDatasets.class.isAssignableFrom(wrapper.getClass())) {
            JoinsDatasets joins = (JoinsDatasets)wrapper;
            this.joinDatasets(joins, transform);
        }
        if (this.primaryDataset == null) {
            this.log.info("Primary dataset is null after performing dataset commands and the program cannot continue.");
            throw new UnknownDataSetException("Dataset is null after performing Dataset commands and the program cannot continue.");
        }
        if (CreatesVariables.class.isAssignableFrom(wrapper.getClass())) {
            CreatesVariables creates = (CreatesVariables)wrapper;
            this.createVariables(creates, transform);
        }
        if (ReordersDataset.class.isAssignableFrom(wrapper.getClass())) {
            ReordersDataset reorders = (ReordersDataset)wrapper;
            this.reorderDataset(reorders, transform);
        }
        if (SelectsVariables.class.isAssignableFrom(wrapper.getClass())) {
            this.getSelectedVariables(wrapper, transform);
        }
        if (DeletesVariable.class.isAssignableFrom(wrapper.getClass())) {
            DeletesVariable deletes = (DeletesVariable)wrapper;
            this.markVariablesAsDeleted(transform, deletes);
        }
        if (UpdatesVariables.class.isAssignableFrom(wrapper.getClass())) {
            UpdatesVariables updatesVar = (UpdatesVariables)wrapper;
            this.updateVariables(updatesVar);
        }
        if (UpdatesClassification.class.isAssignableFrom(wrapper.getClass())) {
            UpdatesClassification updatesClassif = (UpdatesClassification)wrapper;
            this.updateClassification(updatesClassif);
        }
        if (SavesDataset.class.isAssignableFrom(wrapper.getClass())) {
            SavesDataset saves = (SavesDataset)wrapper;
            this.saveDataset(saves, transform);
        }
    }

    private void reorderDataset(ReordersDataset reordersDataset, Transform transform) {
        ArrayList variableOrder = reordersDataset.getVariableOrder();
        ArrayList<Variable> newOrder = new ArrayList<Variable>();
        this.log.trace("Reordering dataset with command [" + transform.getOriginalCommand().getCommand() + "]");
        for (String variableName : variableOrder) {
            Variable variable = this.variableMap.get(variableName);
            newOrder.add(variable);
        }
        if (!newOrder.isEmpty()) {
            this.primaryDataset.getMetadata().setVariables(newOrder);
        }
        this.primaryDataset.addCommands(new Transform[]{transform});
    }

    private void saveDataset(SavesDataset savesDataset, Transform transform) {
        this.log.trace("Saving dataset with ID [" + savesDataset.getDatasetId() + "]");
        if (savesDataset.getVariableOrder() != null && !savesDataset.getVariableOrder().isEmpty()) {
            this.reorderDataset((ReordersDataset)savesDataset, transform);
        }
        this.primaryDataset.addCommands(new Transform[]{transform});
        this.dataSetManager.saveDataSet(this.primaryDataset);
    }

    private void joinDatasets(JoinsDatasets joinsDatasets, Transform transform) {
        DataSet newDataSet;
        if (joinsDatasets.getTargetDataset() != null) {
            newDataSet = joinsDatasets.getTargetDataset();
            newDataSet.addCommands(new Transform[]{transform});
        } else {
            newDataSet = new DataSet();
            newDataSet.addCommands(new Transform[]{transform});
        }
        this.merge(joinsDatasets, newDataSet, transform);
        this.setPrimaryDataset(newDataSet);
        this.log.trace("Setting the primary dataset to [" + newDataSet.getId() + "]");
    }

    private void merge(JoinsDatasets joinsDatasets, DataSet newDataSet, Transform transform) {
        LinkedList orderedVariables = new LinkedList();
        if (joinsDatasets.getSourceDatasetIds() != null) {
            String[] stringArray = joinsDatasets.getSourceDatasetIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String datasetId = stringArray[n2];
                DataSet dataset = this.dataSetManager.loadDataSet(datasetId);
                orderedVariables.addAll(dataset.getMetadata().getVariables());
                this.log.info("Merging dataset [id=" + datasetId + "] into target dataset [" + newDataSet.getId() + "]");
                ++n2;
            }
        } else {
            throw new MissingFilesException("No source datasets found when trying to perform merge using command [" + transform.getOriginalCommand().getCommand().toString() + "]", transform.getOriginalCommand().getCommand());
        }
        newDataSet.getMetadata().setVariables(orderedVariables);
    }

    private void getSelectedVariables(SdtlWrapper wrapper, Transform transform) {
        SelectsVariables selector = (SelectsVariables)wrapper;
        Map datasetVariableMap = this.primaryDataset.getMetadata().getVarNameMap();
        if (!selector.getRanges().isEmpty()) {
            for (Range range : selector.getRanges()) {
                if (range.getStart() == null) continue;
                if (range.getEnd() != null) {
                    for (Variable variable : this.primaryDataset.getVariablesInRange(range.getStart(), range.getEnd())) {
                        if (!new ArrayList<Transform>(Arrays.asList(variable.getTransforms())).contains(transform)) {
                            variable.addTransforms(new Transform[]{transform});
                        }
                        this.log.trace("Adding variable [name=" + variable.getName() + "] to the variable list");
                        this.variableMap.put(variable.getName(), variable);
                    }
                    continue;
                }
                if (!new ArrayList<Transform>(Arrays.asList(((Variable)datasetVariableMap.get(range.getStart())).getTransforms())).contains(transform)) {
                    ((Variable)datasetVariableMap.get(range.getStart())).addTransforms(new Transform[]{transform});
                }
                this.log.trace("Adding variable [name=" + range.getStart() + "] to the variable list");
                this.variableMap.put(range.getStart(), (Variable)datasetVariableMap.get(range.getStart()));
            }
        }
        if (selector.getVariables() != null) {
            for (String variableName : selector.getVariables()) {
                if (datasetVariableMap.get(variableName) == null) continue;
                if (!new ArrayList<Transform>(Arrays.asList(((Variable)datasetVariableMap.get(variableName)).getTransforms())).contains(transform)) {
                    ((Variable)datasetVariableMap.get(variableName)).addTransforms(new Transform[]{transform});
                }
                this.log.trace("Adding variable [name=" + variableName + "] to the variable list");
                this.variableMap.put(variableName, (Variable)datasetVariableMap.get(variableName));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createVariables(CreatesVariables createsVariables, Transform transform) {
        var6_3 = createsVariables.getNewVariables();
        var5_4 = var6_3.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block4: {
                newVariable = var6_3[var4_5];
                if (this.allowComputeClassifications) {
                    this.addPossibleCodes(newVariable);
                }
                if (newVariable.getBasisVariableName() == null) break block4;
                variable = this.createCopyOfBasisVariable(transform, newVariable);
                ** GOTO lbl17
            }
            if (this.primaryDataset.getMetadata().getVarNameMap().containsKey(newVariable.getNewVariableName())) {
                this.populateVariableFromMetadata(transform, newVariable);
            } else {
                variable = this.createNewVariable(transform, newVariable);
lbl17:
                // 2 sources

                variable.addTransforms(new Transform[]{transform});
                variable.setName(newVariable.getNewVariableName());
                this.primaryDataset.getMetadata().getVariables().add(variable);
                this.primaryDataset.getMetadata().getVarNameMap().put(variable.getName(), variable);
                this.variableMap.put(variable.getName(), variable);
                this.log.trace("Registering variable [id=" + variable.getId() + "] in the metadata.");
            }
            ++var4_5;
        }
    }

    private void addPossibleCodes(NewVariable newVariable) {
        HashSet<String> newVariableCodes = new HashSet<String>();
        for (String possibleCode : newVariable.getPossibleCodes()) {
            newVariableCodes.add(possibleCode);
        }
        if (this.possibleCodes.keySet().contains(newVariable.getNewVariableName())) {
            HashSet<String> existingCodes = this.possibleCodes.get(newVariable.getNewVariableName());
            existingCodes.addAll(newVariableCodes);
            this.possibleCodes.put(newVariable.getNewVariableName(), existingCodes);
        } else {
            this.possibleCodes.put(newVariable.getNewVariableName(), newVariableCodes);
        }
    }

    private Variable createNewVariable(Transform transform, NewVariable newVariable) {
        Variable variable = new Variable();
        variable.setClassificationId(UUID.randomUUID().toString());
        this.primaryDataset.getMetadata().getClassifs().put(variable.getClassificationId(), new Classification());
        this.addSourceVariablesFromRange(transform, newVariable);
        transform.addSourceIds(newVariable.getSourceVariables().toArray(new String[0]));
        this.log.trace("Creating new variable [id=" + variable.getId() + "] and registering its new classification in the metadata.");
        return variable;
    }

    private Variable populateVariableFromMetadata(Transform transform, NewVariable newVariable) {
        Variable variable = (Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getNewVariableName());
        this.checkForNullSourceVariable(transform, newVariable.getNewVariableName(), variable);
        this.addSourceVariablesFromRange(transform, newVariable);
        transform.addSourceIds(new String[]{((Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getNewVariableName())).getId()});
        variable.removeAllTransforms();
        variable.addTransforms(new Transform[]{transform});
        variable.setId(UUID.randomUUID().toString());
        variable.setName(newVariable.getNewVariableName());
        this.log.trace("Creating new variable with name [" + newVariable.getNewVariableName() + "]. A variable with the same name was found in the metadata, so a copy of that variable is being used as the basis");
        return variable;
    }

    private void addSourceVariablesFromRange(Transform transform, NewVariable newVariable) {
        if (newVariable.getSourceVariableRange() != null) {
            Range range = newVariable.getSourceVariableRange();
            List sourceVarsFromRange = this.primaryDataset.getVariablesInRange(range.getStart(), range.getEnd());
            for (Variable variable : sourceVarsFromRange) {
                transform.addSourceIds(new String[]{variable.getName()});
            }
        }
    }

    private Variable createCopyOfBasisVariable(Transform transform, NewVariable newVariable) {
        Variable originalVariable = (Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getBasisVariableName());
        Variable variableCopy = (Variable)ResourceCopyUtility.copyResource(Variable.class, (Object)((Variable)this.primaryDataset.getMetadata().getVarNameMap().get(newVariable.getBasisVariableName())));
        this.checkForNullSourceVariable(transform, newVariable.getBasisVariableName(), variableCopy);
        variableCopy.setName(newVariable.getNewVariableName());
        variableCopy.setClassificationId(originalVariable.getClassificationId());
        variableCopy.removeAllTransforms();
        variableCopy.setId(UUID.randomUUID().toString());
        transform.addSourceIds(new String[]{originalVariable.getId()});
        this.log.trace("Creating a variable based on variable [name=" + newVariable.getBasisVariableName() + "] from the datset with properties from command [" + transform.getOriginalCommand().getCommand() + "]");
        return variableCopy;
    }

    private void checkForNullSourceVariable(Transform transform, String name, Variable variable) {
        if (variable == null) {
            this.log.warn("Variable [" + name + "] is null, cannot continue with recode");
            throw new MissingSourceVariableException("Variable [" + name + "] is null, cannot continue with recode.", name, transform.getOriginalCommand().getCommand());
        }
    }

    private void markVariablesAsDeleted(Transform transform, DeletesVariable deletes) {
        if (deletes.getDeletedVars() == null || deletes.getDeletedVars().isEmpty()) {
            this.log.debug("The list of variables to be deleted is empty.");
            return;
        }
        for (String deletedVariable : deletes.getDeletedVars()) {
            Variable variable = this.variableMap.get(deletedVariable);
            if (variable != null) {
                variable.setDeleted(true);
                this.log.trace("Setting variable [name=" + variable.getName() + "] as deleted.");
                continue;
            }
            this.log.debug("Attempted to delete variable [name=" + deletedVariable + "] but it could not be found.");
        }
    }

    private void updateVariables(UpdatesVariables updatesVariables) {
        for (Variable variable : this.variableMap.values()) {
            if (updatesVariables.getUpdatedVariables() != null) {
                VariableNamePair[] variableNamePairArray = updatesVariables.getUpdatedVariables();
                int n = variableNamePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableNamePair pair = variableNamePairArray[n2];
                    if (variable.getName().equals(pair.getSource())) {
                        variable.setName(pair.getTarget());
                        if (pair.getLabel() != null) {
                            variable.setLabel(pair.getLabel());
                        }
                    }
                    ++n2;
                }
                continue;
            }
            this.log.debug("The list of variables to update is null.");
        }
    }

    private void updateClassification(UpdatesClassification updateClassification) {
        ClassificationUpdate update = updateClassification.getUpdate();
        ArrayList<String> usedCodes = new ArrayList<String>();
        for (Variable variable : this.variableMap.values()) {
            if (variable == null) {
                variable = new Variable();
            }
            Classification classification = this.determineClassificationToUse(updateClassification, variable);
            this.checkForDataTypeChange(variable, classification);
            this.removeCodes(update, usedCodes, classification);
            this.updateCodes(update, usedCodes, classification);
            this.addCodes(update, usedCodes, classification);
            if (updateClassification.copyFloatingCodes()) continue;
            List untouched = ClassificationUtils.getUntouchedCodes((Classification)classification, usedCodes);
            for (Code code : untouched) {
                classification.removeCode(code.getCodeValue());
                this.log.trace("UpdatesClassification: Removing unused code [" + code.getCodeValue() + "] from classification [" + classification.getId() + "]. (Floating codes are set to not be carried over.)");
            }
        }
    }

    private void checkForDataTypeChange(Variable variable, Classification classification) {
        DataType variableType;
        boolean numericCodes = false;
        if (!classification.getCodeList().isEmpty() && StringUtils.isNumeric((CharSequence)((Code)classification.getCodeList().get(0)).getCodeValue())) {
            numericCodes = true;
        }
        if ((variableType = variable.getDataType()) == DataType.STRING && numericCodes) {
            variable.setDataType(DataType.NUMBER);
        } else if (variableType == DataType.NUMBER && !numericCodes) {
            variable.setDataType(DataType.STRING);
        }
    }

    private Classification determineClassificationToUse(UpdatesClassification updatesClassification, Variable variable) {
        Classification classification;
        if (updatesClassification.requiresCopyOfClassification()) {
            if (!this.possibleCodes.keySet().contains(variable.getName())) {
                Classification oldClassif = this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId()) == null ? new Classification() : this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId());
                classification = (Classification)ResourceCopyUtility.copyResource(Classification.class, (Object)oldClassif);
                classification.setId(UUID.randomUUID().toString());
                this.primaryDataset.getMetadata().getClassifs().put(classification.getId(), classification);
                variable.setClassification(classification);
                this.log.trace("UpdatesClassification requires a new classification, so new classification [" + classification.getId() + "] was created and registered in the metadata .");
            } else {
                Classification classification2 = classification = this.primaryDataset.getMetadata().getClassifs().keySet().contains(variable.getClassificationId()) ? (Classification)this.primaryDataset.getMetadata().getClassifs().get(variable.getClassificationId()) : new Classification();
                if (this.possibleCodes.get(variable.getName()) != null) {
                    HashSet<String> codesToUse = this.possibleCodes.get(variable.getName());
                    ArrayList<Code> codesToAdd = new ArrayList<Code>();
                    for (String codeValue : codesToUse) {
                        Code code = new Code();
                        code.setCodeValue(codeValue);
                        codesToAdd.add(code);
                    }
                    classification.addCodesToCodeList(codesToAdd);
                }
                classification.setId(UUID.randomUUID().toString());
                variable.setClassificationId(classification.getId());
                variable.setClassification(classification);
                this.primaryDataset.getMetadata().getClassifs().put(classification.getId(), classification);
            }
        } else {
            classification = this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId()) == null ? new Classification() : this.primaryDataset.getMetadata().lookupClassificationById(variable.getClassificationId());
            this.log.trace("New classification not required for UpdatesClassification, so classification [" + classification.getId() + "] pulled from the metadata to be updated.");
        }
        return classification;
    }

    private void updateCodes(ClassificationUpdate classificationUpdate, List<String> usedCodes, Classification classification) {
        int n;
        int n2;
        CodeDetail[] codeDetailArray;
        if (classificationUpdate.getUpdatesCodes() != null) {
            codeDetailArray = classificationUpdate.getUpdatesCodes();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                Code code;
                CodeDetail codeDetail = codeDetailArray[n];
                if (!classification.getCodeList().contains(codeDetail.getFromValue()) && this.allowComputeClassifications && this.possibleCodes.containsKey(codeDetail.getFromValue())) {
                    classification.addNewCode(this.createCode(codeDetail));
                }
                if ((code = classification.lookupCode(codeDetail.getFromValue())) == null) {
                    this.log.trace("UpdatesClassification: no match found when looking up code [" + codeDetail.getFromValue() + "] in classification [" + classification.getId() + "]. Looking up code value numerically");
                    CodeMappingUtility mappingUtility = CodeMappingUtility.getInstance(classification);
                    List<Code> numericallyMatchedCodes = mappingUtility.lookupNumericCode(codeDetail.getFromValue());
                    for (Code c : numericallyMatchedCodes) {
                        this.log.trace("UpdatesClassification: updating code [" + c.getCodeValue() + "].");
                        this.updateCode(c, codeDetail.getLabel(), codeDetail.isMissing(), codeDetail.getMissingType());
                        usedCodes.add(c.getCodeValue());
                    }
                } else {
                    this.log.trace("UpdatesClassification: updating code [" + code.getCodeValue() + "].");
                    this.updateCode(code, codeDetail.getLabel(), codeDetail.isMissing(), codeDetail.getMissingType());
                    usedCodes.add(code.getCodeValue());
                }
                ++n;
            }
        }
        if (classificationUpdate.getUpdatesCodeRange() != null) {
            codeDetailArray = classificationUpdate.getUpdatesCodeRange();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                CodeDetail rangeDetail = codeDetailArray[n];
                for (Code code : classification.selectCodeRange(rangeDetail.getRange().getStart(), rangeDetail.getRange().getEnd())) {
                    this.log.trace("UpdatesClassification: updating code [" + code.getCodeValue() + "].");
                    this.updateCode(code, rangeDetail.getLabel(), rangeDetail.isMissing(), rangeDetail.getMissingType());
                    usedCodes.add(code.getCodeValue());
                }
                ++n;
            }
        }
        if (classificationUpdate.getUpdatesCodes() != null && classificationUpdate.getUpdatesCodeRange() != null) {
            this.log.trace("UpdatesClassification: no codes found to update.");
        }
    }

    private void removeCodes(ClassificationUpdate classificationUpdate, List<String> usedCodes, Classification classification) {
        int n;
        int n2;
        String[] stringArray;
        if (classificationUpdate.getRemovedCodes() != null) {
            stringArray = classificationUpdate.getRemovedCodes();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String codeValue = stringArray[n];
                classification.removeCode(codeValue);
                usedCodes.add(codeValue);
                this.log.trace("UpdatesClassification: removing code [" + codeValue + "].");
                ++n;
            }
        }
        if (classificationUpdate.getRemovedCodeRanges() != null) {
            stringArray = classificationUpdate.getRemovedCodeRanges();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String range = stringArray[n];
                for (Code code : classification.selectCodeRange(range.getStart(), range.getEnd())) {
                    classification.removeCode(code.getCodeValue());
                    usedCodes.add(code.getCodeValue().trim());
                    this.log.trace("UpdatesClassification: removing code [" + code.getCodeValue() + "].");
                }
                ++n;
            }
        }
        if (classificationUpdate.getRemovedCodeRanges() == null && classificationUpdate.getRemovedCodes() == null) {
            this.log.trace("UpdatesClassification: no codes found to remove.");
        }
    }

    private void addCodes(ClassificationUpdate update, List<String> usedCodes, Classification classification) {
        Code code;
        int n;
        int n2;
        CodeDetail[] codeDetailArray;
        if (update.getNewCodes() != null) {
            codeDetailArray = update.getNewCodes();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                CodeDetail codeDetail = codeDetailArray[n];
                code = this.createCode(codeDetail);
                classification.addNewCode(code);
                usedCodes.add(code.getCodeValue());
                this.log.trace("UpdatesClassification: creating code [" + code.getCodeValue() + "].");
                ++n;
            }
        }
        if (update.getNewCodeRanges() != null) {
            codeDetailArray = update.getNewCodeRanges();
            n2 = codeDetailArray.length;
            n = 0;
            while (n < n2) {
                CodeDetail rangeDetail = codeDetailArray[n];
                code = this.createCode(new CodeDetail(rangeDetail.getTargetValue(), rangeDetail.getLabel(), rangeDetail.isMissing()));
                classification.addNewCode(code);
                usedCodes.add(code.getCodeValue());
                this.log.trace("UpdatesClassification: creating code [" + code.getCodeValue() + "].");
                ++n;
            }
        }
        if (update.getNewCodes() == null && update.getNewCodeRanges() == null) {
            this.log.trace("UpdatesClassification: no new codes created.");
        }
    }

    private void updateCode(Code code, String label, boolean missing, String missingType) {
        code.setLabel(label);
        code.setMissing(missing);
    }

    private Code createCode(CodeDetail codeDetail) {
        Code code = new Code();
        if (codeDetail.getNewValue() != null) {
            code.setCodeValue(codeDetail.getNewValue());
        }
        if (codeDetail.getLabel() != null) {
            code.setLabel(codeDetail.getLabel());
        }
        code.setMissing(codeDetail.isMissing());
        return code;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public static void setDataSetManagerFactory(DataSetManagerFactory managerFactory) {
        DataSetUpdater.managerFactory = managerFactory;
    }

    public void setPrimaryDataset(DataSet dataset) {
        this.primaryDataset = dataset;
    }

    public DataSet getPrimaryDataset() {
        return this.primaryDataset;
    }

    public boolean isAllowComputeClassifications() {
        return this.allowComputeClassifications;
    }

    public void setAllowComputeClassifications(boolean allowComputeClassifications) {
        this.allowComputeClassifications = allowComputeClassifications;
    }

    public Map<String, HashSet<String>> getPossibleCodes() {
        return this.possibleCodes;
    }

    public void setPossibleCodes(Map<String, HashSet<String>> possibleCodes) {
        this.possibleCodes = possibleCodes;
    }

    public DataSetManager getDataSetManager() {
        return this.dataSetManager;
    }
}

