/*
 * Decompiled with CFR 0.152.
 */
package us.mtna.dataset.updater;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import us.mtna.pojo.Classification;
import us.mtna.pojo.Code;

public class CodeMappingUtility {
    private static HashMap<Classification, CodeMappingUtility> instanceMap = new HashMap();
    private final HashMap<Double, ArrayList<Code>> codeMap = new HashMap();

    private CodeMappingUtility(Classification classification) {
        for (Code code : classification.getCodeList()) {
            String codeValue = code.getCodeValue();
            if (!StringUtils.isNumeric((CharSequence)codeValue)) continue;
            Double codeDouble = Double.valueOf(codeValue);
            ArrayList<Object> codes = this.codeMap.get(codeDouble);
            if (codes == null) {
                codes = new ArrayList();
                this.codeMap.put(codeDouble, codes);
            }
            codes.add(code);
        }
    }

    public static CodeMappingUtility getInstance(Classification classification) {
        CodeMappingUtility instance = instanceMap.get(classification);
        if (instance == null) {
            instance = new CodeMappingUtility(classification);
            instanceMap.put(classification, instance);
        }
        return instance;
    }

    public List<Code> lookupNumericCode(String codeValue) {
        ArrayList<Code> matchedCodes;
        ArrayList<Code> codes = new ArrayList<Code>();
        if (NumberUtils.isCreatable((String)codeValue) && (matchedCodes = this.codeMap.get(Double.valueOf(codeValue))) != null) {
            codes.addAll(matchedCodes);
        }
        return codes;
    }
}

