package org.openmetadata.util.xmlbeans;

public class ValidatorExpression {
	public enum TYPE {NS_PREFIX,XPATH,XQUERY};
	public enum LOG_LEVEL {INFO,WARNING,ERROR}
	private TYPE type;
	private String prefix;
	private LOG_LEVEL level; 
	private String value;
	private String description;
	
	//===============================================================
	// CONSTRUCTOR(S)
	//===============================================================
	
	/**
	 * Used for spring Beans
	 */
	public ValidatorExpression(){
		
	}
	
	public ValidatorExpression(TYPE type, LOG_LEVEL level, String value) {
		this.type = type;
		this.level = level;
		this.value = value;
	}

	public ValidatorExpression(TYPE type, String prefix, String value) {
		this.type = type;
		this.prefix = prefix;
		this.value = value;
	}

	//===============================================================
	// GETTERS/SETTERS
	//===============================================================

	public TYPE getType() {
		return type;
	}

	public void setType(TYPE type) {
		this.type = type;
	}

	public LOG_LEVEL getLevel() {
		return level;
	}

	public void setLevel(LOG_LEVEL level) {
		this.level = level;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
	public String getPrefix() {
		return prefix;
	}
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}

}
