/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.xmlbeans;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class XhtmlUtilities {
    public static void setXhtmlContent(XmlObject xo, String val) {
        try {
            XmlObject temp = XmlObject.Factory.parse((String)("<xml-fragment>" + val + "</xml-fragment>"));
            XhtmlUtilities.namespaceXHTMLContent(temp);
            XmlCursor cursorXo = xo.newCursor();
            cursorXo.removeXmlContents();
            cursorXo.toFirstContentToken();
            temp.newCursor().copyXmlContents(cursorXo);
            cursorXo.dispose();
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends XmlObject> T createMixedContent(Class<T> xc, String value) {
        try {
            XmlObject xo = (XmlObject)xc.cast(XmlBeans.getContextTypeLoader().parse("<xml-fragment>" + value + "</xml-fragment>", XmlBeans.typeForClass(xc), new XmlOptions().setLoadReplaceDocumentElement(null)));
            XhtmlUtilities.namespaceXHTMLContent(xo);
            return (T)xo;
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMixedContent(XmlObject xo) {
        String text = "";
        XmlCursor cursor = xo.copy().newCursor();
        cursor.toFirstAttribute();
        ArrayList<String> tags = new ArrayList<String>();
        while (cursor.toNextToken() != XmlCursor.TokenType.ENDDOC) {
            XmlCursor.TokenType type = cursor.currentTokenType();
            if (type.equals(XmlCursor.TokenType.TEXT)) {
                text = String.valueOf(text) + StringEscapeUtils.escapeXml((String)cursor.getTextValue());
                continue;
            }
            if (type.equals(XmlCursor.TokenType.START)) {
                XmlCursor.TokenType subType;
                String name = cursor.getName().getLocalPart();
                tags.add(name);
                text = String.valueOf(text) + "<" + name;
                if (cursor.toFirstAttribute()) {
                    text = String.valueOf(text) + " " + cursor.getName().getLocalPart() + "=\"" + cursor.getTextValue() + "\"";
                    while (cursor.toNextAttribute()) {
                        text = String.valueOf(text) + " " + cursor.getName().getLocalPart() + "=\"" + cursor.getTextValue() + "\"";
                    }
                }
                if ((subType = cursor.toNextToken()).equals(XmlCursor.TokenType.END)) {
                    text = String.valueOf(text) + "/>";
                    tags.remove(tags.size() - 1);
                    continue;
                }
                text = String.valueOf(text) + ">";
                cursor.toPrevToken();
                continue;
            }
            if (!type.equals(XmlCursor.TokenType.END) || tags.size() <= 0) continue;
            text = String.valueOf(text) + "</" + (String)tags.get(tags.size() - 1) + ">";
            tags.remove(tags.size() - 1);
        }
        cursor.dispose();
        return text;
    }

    public static void namespaceXHTMLContent(XmlObject xo) {
        XmlCursor cursor = xo.newCursor();
        cursor.toFirstAttribute();
        while (cursor.toNextToken() != XmlCursor.TokenType.ENDDOC) {
            XmlCursor.TokenType type = cursor.currentTokenType();
            if (type.equals(XmlCursor.TokenType.START)) {
                String name = cursor.getName().getLocalPart();
                cursor.setName(new QName("http://www.w3.org/1999/xhtml", name, "xhtml"));
                continue;
            }
            type.equals(XmlCursor.TokenType.END);
        }
        cursor.dispose();
    }
}

