/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.references;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReferenceFileHandler {
    public static Map<String, String> readSimpleReferences(File file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        int buffSize = 8192;
        int nextChar = 0;
        char[] cb = new char[buffSize];
        int startIndex = 0;
        boolean key = true;
        String keyId = null;
        int charCount = reader.read(cb, 0, buffSize);
        while (true) {
            if (nextChar < charCount) {
                char c = cb[nextChar];
                if (c == '\n') {
                    startIndex = nextChar + 1;
                    key = true;
                } else if (c == '\'' || c == '+') {
                    char[] element = new char[nextChar - startIndex];
                    System.arraycopy(cb, startIndex, element, 0, element.length);
                    String id = String.valueOf(element);
                    startIndex = nextChar + 1;
                    if (key) {
                        keyId = id;
                        key = false;
                    } else {
                        map.put(keyId, id);
                    }
                }
                ++nextChar;
                continue;
            }
            int leftover = 0;
            if (startIndex < charCount) {
                leftover = charCount - startIndex;
                System.arraycopy(cb, startIndex, cb, 0, leftover);
            }
            int len_read = reader.read(cb, leftover, cb.length - leftover);
            while (len_read == 0) {
                char[] tmp = new char[cb.length * 2];
                System.arraycopy(cb, 0, tmp, 0, cb.length);
                cb = new char[cb.length * 2];
                System.arraycopy(tmp, 0, cb, 0, cb.length);
                len_read = reader.read(cb, cb.length / 2, cb.length / 2);
            }
            if (len_read <= 0) break;
            charCount = leftover + len_read;
            startIndex = nextChar -= charCount;
        }
        reader.close();
        return map;
    }

    public static Map<String, Set<String>> readReferences(File file) throws IOException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        int buffSize = 8192;
        int nextChar = 0;
        char[] cb = new char[buffSize];
        int startIndex = 0;
        boolean key = true;
        String keyId = null;
        int charCount = reader.read(cb, 0, buffSize);
        while (true) {
            if (nextChar < charCount) {
                char c = cb[nextChar];
                if (c == '\n') {
                    startIndex = nextChar + 1;
                    key = true;
                } else if (c == '\'' || c == '+') {
                    char[] element = new char[nextChar - startIndex];
                    System.arraycopy(cb, startIndex, element, 0, element.length);
                    String id = String.valueOf(element);
                    startIndex = nextChar + 1;
                    if (key) {
                        keyId = id;
                        key = false;
                    } else {
                        ReferenceFileHandler.addReference(map, id, keyId);
                    }
                }
                ++nextChar;
                continue;
            }
            int leftover = 0;
            if (startIndex < charCount) {
                leftover = charCount - startIndex;
                System.arraycopy(cb, startIndex, cb, 0, leftover);
            }
            int len_read = reader.read(cb, leftover, cb.length - leftover);
            while (len_read == 0) {
                char[] tmp = new char[cb.length * 2];
                System.arraycopy(cb, 0, tmp, 0, cb.length);
                cb = new char[cb.length * 2];
                System.arraycopy(tmp, 0, cb, 0, cb.length);
                len_read = reader.read(cb, cb.length / 2, cb.length / 2);
            }
            if (len_read <= 0) break;
            charCount = leftover + len_read;
            startIndex = nextChar -= charCount;
        }
        reader.close();
        return map;
    }

    public static void writeSimpleReferences(Map<String, String> map, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (Map.Entry<String, String> e : map.entrySet()) {
            fw.write(e.getKey() + "+" + e.getValue() + "'\n");
        }
        fw.close();
    }

    public static void writeReferences(Map<String, Set<String>> map, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (Map.Entry<String, Set<String>> e : map.entrySet()) {
            fw.write(e.getKey());
            for (String ref : e.getValue()) {
                fw.write("+" + ref);
            }
            fw.write("'\n");
        }
        fw.close();
    }

    private static void addReference(Map<String, Set<String>> map, String from, String to) {
        if (map.containsKey(to)) {
            map.get(to).add(from);
        } else {
            HashSet<String> referrers = new HashSet<String>();
            referrers.add(from);
            map.put(to, referrers);
        }
    }
}

