/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.ascii;

import java.util.UUID;
import org.openmetadata.fileformat.AsciiFileFormat;

public class AsciiExportOptions {
    AsciiFileFormat asciiFormat;
    private String id;
    private String nullValue;
    private int maxSqlCol;
    private boolean SQL = false;
    private boolean fusion = false;
    private String delimiter = "\t";
    public WIDTH_MODE widthMode = WIDTH_MODE.OPTIMIZE;

    public AsciiExportOptions() {
        this.asciiFormat = new AsciiFileFormat();
    }

    public AsciiExportOptions(AsciiFileFormat asciiFormat) {
        this(UUID.randomUUID().toString(), asciiFormat);
        if (asciiFormat == null) {
            this.asciiFormat = new AsciiFileFormat();
        } else {
            this.asciiFormat = asciiFormat;
            if (this.asciiFormat.getAsciiFormat() == AsciiFileFormat.ASCII_FORMAT.CSV) {
                this.delimiter = ",";
            }
        }
    }

    public AsciiExportOptions(String id, AsciiFileFormat asciiFormat) {
        this.id = id;
        if (asciiFormat == null) {
            this.asciiFormat = new AsciiFileFormat();
        } else {
            this.asciiFormat = asciiFormat;
            if (this.asciiFormat.getAsciiFormat() == AsciiFileFormat.ASCII_FORMAT.CSV) {
                this.delimiter = ",";
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AsciiFileFormat getAsciiFormat() {
        return this.asciiFormat;
    }

    public void setAsciiFormat(AsciiFileFormat asciiFormat) {
        this.asciiFormat = asciiFormat;
        if (this.asciiFormat.getAsciiFormat() == AsciiFileFormat.ASCII_FORMAT.CSV) {
            this.delimiter = ",";
        }
    }

    public int getMaxSqlCol() {
        return this.maxSqlCol;
    }

    public void setMaxSqlCol(int maxSqlCol) {
        this.maxSqlCol = maxSqlCol;
    }

    public boolean isOptimize() {
        return this.widthMode == WIDTH_MODE.OPTIMIZE;
    }

    public void setOptimize(boolean optimize) {
        this.widthMode = WIDTH_MODE.OPTIMIZE;
    }

    public boolean isThrowException() {
        return this.widthMode == WIDTH_MODE.THROW_EXCEPTION;
    }

    public void setThrowException(boolean throwException) {
        this.widthMode = WIDTH_MODE.THROW_EXCEPTION;
    }

    public boolean isAutoAdjust() {
        return this.widthMode == WIDTH_MODE.AUTO_ADJUST;
    }

    public void setAutoAdjust(boolean autoAdjust) {
        this.widthMode = WIDTH_MODE.AUTO_ADJUST;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean isPreCompute() {
        return this.widthMode == WIDTH_MODE.PRE_COMPUTE;
    }

    public void setPreCompute(boolean preCompute) {
        this.widthMode = WIDTH_MODE.PRE_COMPUTE;
    }

    public boolean isReportOnly() {
        return this.widthMode == WIDTH_MODE.REPORT_ONLY;
    }

    public void setReportOnly(boolean reportOnly) {
        this.widthMode = WIDTH_MODE.REPORT_ONLY;
    }

    public boolean isNoAdjustment() {
        return this.widthMode == WIDTH_MODE.NO_ADJUSTMENT;
    }

    public void setNoAdjustment(boolean noAdjustment) {
        if (noAdjustment) {
            this.widthMode = WIDTH_MODE.NO_ADJUSTMENT;
        }
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public WIDTH_MODE getWidthMode() {
        return this.widthMode;
    }

    public void setWidthMode(WIDTH_MODE widthMode) {
        this.widthMode = widthMode;
    }

    public boolean isSQL() {
        return this.SQL;
    }

    public void setSQL(boolean sQL) {
        this.SQL = sQL;
    }

    public boolean isFusion() {
        return this.fusion;
    }

    public void setFusion(boolean fusion) {
        this.fusion = fusion;
    }

    public static enum WIDTH_MODE {
        OPTIMIZE,
        THROW_EXCEPTION,
        AUTO_ADJUST,
        PRE_COMPUTE,
        REPORT_ONLY,
        NO_ADJUSTMENT;

    }
}

