/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageDigest messageDigest(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        int STREAM_BUFFER_LENGTH = 4096;
        MessageDigest md = MessageDigest.getInstance(algorithm);
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] buffer = new byte[4096];
            int read = ((InputStream)is).read(buffer, 0, 4096);
            while (read > -1) {
                md.update(buffer, 0, read);
                read = ((InputStream)is).read(buffer, 0, 4096);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return md;
    }

    public static MessageDigest messageDigest(String str, String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(str.getBytes("UTF-8"));
        return md;
    }

    public static String digestToHex(MessageDigest md) {
        byte[] digest = md.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & digest[i]));
        }
        return hexString.toString();
    }

    public static String md5(File file) {
        try {
            return Digest.digestToHex(Digest.messageDigest(file, "MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String md5(String str) {
        try {
            return Digest.digestToHex(Digest.messageDigest(str, "MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String sha1(File file) {
        try {
            return Digest.digestToHex(Digest.messageDigest(file, "SHA-1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String sha1(String str) {
        try {
            return Digest.digestToHex(Digest.messageDigest(str, "SHA-1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

