/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.query.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.query.Criteria;
import org.openmetadata.store.query.PropertySearch;
import org.openmetadata.store.query.ReferenceSet;
import org.openmetadata.store.query.Sort;
import org.openmetadata.store.query.TextSearch;
import org.openmetadata.store.query.impl.ReferenceSetImpl;

public class CriteriaImpl<B extends IdentifiableBean>
implements Criteria<B> {
    private final Class<B> beanClass;
    private final HashSet<Class<? extends B>> beanClassSet;
    private final int pageSize;
    private final int maxCount;
    private final ArrayList<Sort> sortList;
    private final ReferenceSetImpl references;
    private final ReferenceSetImpl referrers;
    private final TextSearch text;
    private final HashSet<PropertySearch> properties;
    private boolean searchChildContext;
    private boolean searchParentContext;

    public CriteriaImpl(Class<B> beanClass) {
        this(beanClass, 0, 0, null);
    }

    public CriteriaImpl(Class<B> beanClass, int pageSize, int maxCount, TextSearch text) {
        this.beanClass = beanClass;
        this.pageSize = pageSize;
        this.maxCount = maxCount;
        this.sortList = new ArrayList();
        this.references = new ReferenceSetImpl();
        this.referrers = new ReferenceSetImpl();
        this.properties = new HashSet();
        this.text = text;
        this.beanClassSet = new HashSet();
        this.beanClassSet.add(beanClass);
    }

    @Override
    public Class<B> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Set<Class<? extends B>> getBeanClasses() {
        return new HashSet<Class<? extends B>>(this.beanClassSet);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public List<Sort> getSort() {
        return new ArrayList<Sort>(this.sortList);
    }

    @Override
    public boolean searchParentContexts() {
        return this.searchParentContext;
    }

    @Override
    public boolean searchChildContexts() {
        return this.searchChildContext;
    }

    @Override
    public ReferenceSet getReferences() {
        return this.references;
    }

    @Override
    public ReferenceSet getReferrers() {
        return this.referrers;
    }

    @Override
    public boolean searchText() {
        return this.text != null;
    }

    @Override
    public TextSearch getSearchText() {
        return this.text;
    }

    @Override
    public Set<PropertySearch> getSearchProperties() {
        return this.properties;
    }

    public void addBeanClass(Class<? extends B> beanClass) {
        this.beanClassSet.add(beanClass);
    }

    public void addSort(Sort sort) {
        this.sortList.add(sort);
    }

    public void setReferencesDirect(boolean directReferences) {
        this.references.setDirectReferences(directReferences);
    }

    public void addReference(Set<String> references) {
        this.references.addIds(references);
    }

    public void setReferrersDirect(boolean directReferrers) {
        this.referrers.setDirectReferences(directReferrers);
    }

    public void addReferrer(Set<String> referrers) {
        this.referrers.addIds(referrers);
    }

    public void addProperty(PropertySearch property) {
        this.properties.add(property);
    }

    public void setSearchParentContext(boolean searchParentContext) {
        this.searchParentContext = searchParentContext;
    }

    public void setSearchChildContext(boolean searchChildContext) {
        this.searchChildContext = searchChildContext;
    }
}

