/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.managers.impl;

import java.util.HashSet;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.change.impl.ChangeSetImpl;
import org.openmetadata.store.managers.ChangeManager;

public class ContextContainerChangeManager
implements ChangeManager {
    protected final ChangeEvent.Type changeType;
    protected final String contextId;
    protected final HashSet<String> additions;
    protected final HashSet<String> deletions;
    protected final HashSet<String> updates;
    protected final HashSet<String> containerAdditions;
    protected final HashSet<String> containerDeletions;
    protected final HashSet<String> containerUpdates;

    public ContextContainerChangeManager(String contextId) {
        this(contextId, ChangeEvent.Type.UPDATE);
    }

    public ContextContainerChangeManager(String contextId, ChangeEvent.Type changeType) {
        this.contextId = contextId;
        this.changeType = changeType;
        this.additions = new HashSet();
        this.deletions = new HashSet();
        this.updates = new HashSet();
        this.containerAdditions = new HashSet();
        this.containerDeletions = new HashSet();
        this.containerUpdates = new HashSet();
    }

    @Override
    public ChangeSet<String> getUnsavedChanges() {
        ChangeSetImpl<String> changeSet = new ChangeSetImpl<String>();
        if (!this.additions.isEmpty() || !this.deletions.isEmpty() | !this.updates.isEmpty()) {
            changeSet.getUpdates().add(this.contextId);
        }
        return changeSet;
    }

    @Override
    public ChangeSet<String> getSaveSet(String id) {
        ChangeSetImpl<String> changeSet = new ChangeSetImpl<String>();
        changeSet.getAdditions().addAll(this.containerAdditions);
        changeSet.getDeletions().addAll(this.containerDeletions);
        changeSet.getUpdates().addAll(this.containerUpdates);
        return changeSet;
    }

    @Override
    public ChangeSet<String> getDiscardSet(String id) {
        ChangeSetImpl<String> changeSet = new ChangeSetImpl<String>();
        changeSet.getAdditions().addAll(this.additions);
        changeSet.getDeletions().addAll(this.deletions);
        changeSet.getUpdates().addAll(this.updates);
        return changeSet;
    }

    @Override
    public ChangeSet<String> getAllSaveItems(String id) {
        ChangeSetImpl<String> saveSet = new ChangeSetImpl<String>();
        saveSet.getAdditions().addAll(this.additions);
        saveSet.getDeletions().addAll(this.deletions);
        saveSet.getUpdates().addAll(this.updates);
        return saveSet;
    }

    @Override
    public ChangeSet<String> getAllDiscardItems(String id) {
        ChangeSetImpl<String> discardSet = new ChangeSetImpl<String>();
        discardSet.getAdditions().addAll(this.additions);
        discardSet.getDeletions().addAll(this.deletions);
        discardSet.getUpdates().addAll(this.updates);
        return discardSet;
    }

    public void notifyChangeEvent(IdentifiableChangeEvent event) {
        IdentifiableBean bean = event.getBean();
        String id = event.getBean().getPrimaryIdentifier();
        boolean container = bean.getContainerIdentifier().equals(id);
        switch (event.getType()) {
            case DELETE: {
                if (this.additions.contains(id)) {
                    this.additions.remove(id);
                } else {
                    this.deletions.add(id);
                }
                if (!container) break;
                if (this.containerAdditions.contains(id)) {
                    this.containerAdditions.remove(id);
                    break;
                }
                this.containerDeletions.add(id);
                break;
            }
            case CREATE: {
                if (this.updates.contains(id)) {
                    throw new RuntimeException("Object cannot be added after it has been updated.");
                }
                if (this.deletions.contains(id)) {
                    throw new RuntimeException("Object cannot be added after it has been deleted.");
                }
                this.additions.add(id);
                if (!container) break;
                this.containerAdditions.add(id);
                break;
            }
            case UPDATE: {
                if (this.deletions.contains(id)) {
                    throw new RuntimeException("Object cannot be updated after it has been deleted.");
                }
                if (!this.additions.contains(id)) {
                    this.updates.add(id);
                }
                if (container) {
                    if (this.containerAdditions.contains(id)) break;
                    this.containerUpdates.add(id);
                    break;
                }
                String containerId = bean.getContainerIdentifier();
                if (this.containerAdditions.contains(containerId)) break;
                this.containerUpdates.add(containerId);
            }
        }
    }

    @Override
    public void notifyDiscard(String id) {
        if (id.equals(this.contextId)) {
            this.clear();
        }
        this.additions.remove(id);
        this.deletions.remove(id);
        this.updates.remove(id);
        this.containerAdditions.remove(id);
        this.containerDeletions.remove(id);
        this.containerUpdates.remove(id);
    }

    @Override
    public void notifySave(String id) {
        if (!id.equals(this.contextId)) {
            throw new RuntimeException("Only the context can be saved.");
        }
        this.clear();
    }

    public ChangeEvent.Type getChangeType() {
        return this.changeType;
    }

    public boolean isEmpty() {
        return this.additions.isEmpty() && this.deletions.isEmpty() && this.updates.isEmpty();
    }

    protected final void clear() {
        this.additions.clear();
        this.updates.clear();
        this.deletions.clear();
        this.containerAdditions.clear();
        this.containerUpdates.clear();
        this.containerDeletions.clear();
    }
}

