/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.managers.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeListener;
import org.openmetadata.store.managers.ChangeNotificationManager;

public class ChangeNotificationManagerImpl
implements ChangeNotificationManager {
    private HashMap<String, Set<IdentifiableChangeListener>> listenerMap = new HashMap();
    private HashMap<IdentifiableChangeListener, Set<String>> reverseMap = new HashMap();
    private HashSet<IdentifiableChangeListener> delegates = new HashSet();

    @Override
    public void addDelegateListener(IdentifiableChangeListener listener) {
        this.delegates.add(listener);
    }

    @Override
    public void addChangeListener(String id, IdentifiableChangeListener listener) {
        this.getListenerSet(id).add(listener);
        this.getRegistrationSet(listener).add(id);
    }

    @Override
    public void removeChangeListener(String id, IdentifiableChangeListener listener) {
        this.getListenerSet(id).remove(listener);
    }

    @Override
    public void removeChangeListener(IdentifiableChangeListener listener) {
        for (String id : this.getRegistrationSet(listener)) {
            this.removeChangeListener(id, listener);
        }
        this.delegates.remove(listener);
    }

    public void notifyChangeEvent(IdentifiableChangeEvent event) {
        for (IdentifiableChangeListener listener : this.viewListenerSet(event.getBean().getPrimaryIdentifier())) {
            listener.notifyChangeEvent(event);
        }
        for (IdentifiableChangeListener listener : this.delegates) {
            listener.notifyChangeEvent(event);
        }
    }

    protected final Set<IdentifiableChangeListener> getListenerSet(String id) {
        HashSet<IdentifiableChangeListener> set;
        if (this.listenerMap.containsKey(id)) {
            set = this.listenerMap.get(id);
        } else {
            set = new HashSet();
            this.listenerMap.put(id, set);
        }
        return set;
    }

    protected final Set<IdentifiableChangeListener> viewListenerSet(String id) {
        HashSet<IdentifiableChangeListener> set = new HashSet<IdentifiableChangeListener>();
        if (this.listenerMap.containsKey(id)) {
            set.addAll((Collection<IdentifiableChangeListener>)this.listenerMap.get(id));
        }
        return set;
    }

    protected final Set<String> getRegistrationSet(IdentifiableChangeListener listener) {
        HashSet<String> set;
        if (this.reverseMap.containsKey(listener)) {
            set = this.reverseMap.get(listener);
        } else {
            set = new HashSet();
            this.reverseMap.put(listener, set);
        }
        return set;
    }
}

