/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.catalog.impl;

import java.util.Map;
import org.openmetadata.store.access.LockInformation;
import org.openmetadata.store.catalog.WorkspaceNode;
import org.openmetadata.store.catalog.impl.ACatalogItemImpl;
import org.openmetadata.store.catalog.impl.AClientWorkspaceLevelImpl;
import org.openmetadata.store.catalog.impl.AClientWorkspaceNodeImpl;
import org.openmetadata.store.catalog.impl.ASharedWorkspaceLevelImpl;
import org.openmetadata.store.catalog.impl.ASharedWorkspaceNodeImpl;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.repository.ClientWorkspaceRepository;

public class CatalogHandler {
    public static <N extends ASharedWorkspaceNodeImpl<N, L>, L extends ASharedWorkspaceLevelImpl<N, L>> void processLevel(ASharedWorkspaceLevelImpl<N, L> level, Map<String, ? extends LockInformation> locks) {
        ACatalogItemImpl[] aCatalogItemImplArray = (ASharedWorkspaceNodeImpl[])level.getNodes();
        int n = aCatalogItemImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASharedWorkspaceNodeImpl node = aCatalogItemImplArray[n2];
            CatalogHandler.processNode(node, locks);
            ++n2;
        }
        aCatalogItemImplArray = (ASharedWorkspaceLevelImpl[])level.getLevels();
        n = aCatalogItemImplArray.length;
        n2 = 0;
        while (n2 < n) {
            ACatalogItemImpl child = aCatalogItemImplArray[n2];
            CatalogHandler.processLevel(child, locks);
            ++n2;
        }
    }

    public static <N extends ASharedWorkspaceNodeImpl<N, L>, L extends ASharedWorkspaceLevelImpl<N, L>> void processNode(ASharedWorkspaceNodeImpl<N, L> node, Map<String, ? extends LockInformation> locks) {
        String id = node.getPrimaryIdentifier();
        node.setIsLocked(locks.containsKey(id), true);
        ACatalogItemImpl[] aCatalogItemImplArray = (ASharedWorkspaceNodeImpl[])node.getNodes();
        int n = aCatalogItemImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASharedWorkspaceNodeImpl child = aCatalogItemImplArray[n2];
            CatalogHandler.processNode(child, locks);
            ++n2;
        }
        aCatalogItemImplArray = (ASharedWorkspaceLevelImpl[])node.getLevels();
        n = aCatalogItemImplArray.length;
        n2 = 0;
        while (n2 < n) {
            ACatalogItemImpl level = aCatalogItemImplArray[n2];
            CatalogHandler.processLevel(level, locks);
            ++n2;
        }
    }

    public static <N extends AClientWorkspaceNodeImpl<N, L>, L extends AClientWorkspaceLevelImpl<N, L>> void processLevel(AClientWorkspaceLevelImpl<N, L> level, ChangeSet<String> uncommittedChanges, Map<String, ? extends LockInformation> locks, ClientWorkspaceRepository<?> repository) {
        ACatalogItemImpl[] aCatalogItemImplArray = (AClientWorkspaceNodeImpl[])level.getNodes();
        int n = aCatalogItemImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            AClientWorkspaceNodeImpl node = aCatalogItemImplArray[n2];
            CatalogHandler.processNode(node, uncommittedChanges, locks, repository);
            ++n2;
        }
        aCatalogItemImplArray = (AClientWorkspaceLevelImpl[])level.getLevels();
        n = aCatalogItemImplArray.length;
        n2 = 0;
        while (n2 < n) {
            ACatalogItemImpl child = aCatalogItemImplArray[n2];
            CatalogHandler.processLevel(child, uncommittedChanges, locks, repository);
            ++n2;
        }
    }

    public static <N extends AClientWorkspaceNodeImpl<N, L>, L extends AClientWorkspaceLevelImpl<N, L>> void processNode(AClientWorkspaceNodeImpl<N, L> node, ChangeSet<String> uncommittedChanges, Map<String, ? extends LockInformation> locks, ClientWorkspaceRepository<?> repository) {
        String id = node.getPrimaryIdentifier();
        node.setIsShared(!uncommittedChanges.getAdditions().contains(id));
        node.setIsLocked(locks.containsKey(id), true);
        node.setIsAvailableOffline(repository.contains(id));
        if (uncommittedChanges.getAdditions().contains(id)) {
            node.setCommitState(WorkspaceNode.ChangeState.ADDED);
        } else if (uncommittedChanges.getDeletions().contains(id)) {
            node.setCommitState(WorkspaceNode.ChangeState.DELETED);
        } else if (uncommittedChanges.getUpdates().contains(id)) {
            node.setCommitState(WorkspaceNode.ChangeState.UPDATED);
        } else {
            node.setCommitState(WorkspaceNode.ChangeState.NONE);
        }
        ACatalogItemImpl[] aCatalogItemImplArray = (AClientWorkspaceNodeImpl[])node.getNodes();
        int n = aCatalogItemImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            AClientWorkspaceNodeImpl child = aCatalogItemImplArray[n2];
            CatalogHandler.processNode(child, uncommittedChanges, locks, repository);
            ++n2;
        }
        aCatalogItemImplArray = (AClientWorkspaceLevelImpl[])node.getLevels();
        n = aCatalogItemImplArray.length;
        n2 = 0;
        while (n2 < n) {
            ACatalogItemImpl level = aCatalogItemImplArray[n2];
            CatalogHandler.processLevel(level, uncommittedChanges, locks, repository);
            ++n2;
        }
    }
}

