/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.catalog.impl;

import java.util.ArrayList;
import org.openmetadata.store.catalog.CatalogItem;
import org.openmetadata.store.catalog.Level;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.text.ContextualTextSet;

public abstract class ACatalogItemImpl<N extends Node, L extends Level>
implements CatalogItem {
    private final L parentLevel;
    private final N parentNode;
    private final boolean isContext;
    private final String contextId;
    private final ContextualTextSet name;
    private final ContextualTextSet documentation;
    private final ArrayList<N> nodes;
    private final ArrayList<L> levels;

    protected ACatalogItemImpl(ContextualTextSet name, ContextualTextSet documentation, String contextId, L parentLevel, N parentNode) {
        this.name = name;
        this.documentation = documentation;
        this.contextId = contextId;
        this.isContext = contextId != null;
        this.parentLevel = parentLevel;
        this.parentNode = parentNode;
        this.nodes = new ArrayList();
        this.levels = new ArrayList();
    }

    @Override
    public boolean isContext() {
        return this.isContext;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public ContextualTextSet getName() {
        return this.name;
    }

    @Override
    public ContextualTextSet getDescription() {
        return this.documentation;
    }

    public N[] getNodes() {
        return this.nodes.toArray(this.buildNodeArray());
    }

    public L[] getLevels() {
        return this.levels.toArray(this.buildLevelArray());
    }

    @Override
    public boolean hasParentNode() {
        return this.parentNode != null;
    }

    public N getParentNode() {
        return this.parentNode;
    }

    @Override
    public boolean hasParentLevel() {
        return this.parentLevel != null;
    }

    public L getParentLevel() {
        return this.parentLevel;
    }

    protected void addNode(N node) {
        this.nodes.add(node);
    }

    protected void addLevel(L level) {
        this.levels.add(level);
    }

    protected abstract N[] buildNodeArray();

    protected abstract L[] buildLevelArray();
}

