package org.openmetadata.store.snapshot;

import java.util.Calendar;

/**
 * Describes a historical save event. Each snapshot captures and identifier,
 * date, comment, and list of objects which were saved during a save event.
 * 
 * @author Jack Gager
 * 
 */
public interface Snapshot {

	/**
	 * Gets the unique identifier for the snapshot.
	 * 
	 * @return the id of the snapshot
	 */
	public String getId();
		
	/**
	 * Gets the date and time at which the save event occurred.
	 * 
	 * @return the date and time of the save event
	 */
	public Calendar getDate();

	/**
	 * Gets the comment associated with the snapshot.
	 * 
	 * @return
	 */
	public String getComment();

	/**
	 * Gets the identifiers of the items which were saved during the save
	 * event.
	 * 
	 * @return identifiers of the items which were saved
	 */
	public String[] getItemIds();

}
