package org.openmetadata.store.repository.notification;

/**
 * This notifies listeners when a save operation has been saved in a repository.
 * 
 * @author Jack Gager
 * 
 */
public interface SaveNotifier {

	/**
	 * Adds a listener which is to be notified of all save events
	 * 
	 * @param saveListener
	 *            the listener to be added
	 */
	public void addSaveListener(SaveListener saveListener);

	/**
	 * Removes a listener from the collection that is notified of all save
	 * events
	 * 
	 * @param saveListener
	 *            the listener to be removed
	 */
	public void removeSaveListener(SaveListener saveListener);

}
