package org.openmetadata.store.repository.notification;

/**
 * This is a listener which will be notified when an identifiable object has
 * been saved. A single {@link SaveEvent} will be raised containing all of the
 * identifiers of the object which were saved as part of the save operation.
 * 
 * @author Jack Gager
 * 
 */
public interface SaveListener {

	/**
	 * Notifies implementation that the object identified within the
	 * <code>saveEvent</code> has been saved in the repository.
	 * 
	 * @param saveEvent
	 *            the event detailing the save operation
	 */
	public void notifySave(SaveEvent saveEvent);

}
