package org.openmetadata.store.repository.notification;

/**
 * This is an event that is raised with a set of identifiable objects are  saved.
 * 
 * @author Jack Gager
 * 
 */
public interface SaveEvent {

	/**
	 * Gets the unique identifier for the save event. This identifies the
	 * specific save request.
	 * 
	 * @return the event identification
	 */
	public String getEventIdentifier();

	/**
	 * Gets the unique identifications of the objects that were saved as part of
	 * the operation which raised this event
	 * 
	 * @return an array of object unique identifiers which were saved
	 */
	public String[] getPrimaryIdentifiers();

}
